/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.permission;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.Dependent;
import org.jboss.seam.security.annotations.permission.Identifier;
import org.jboss.seam.security.permission.IdentifierStrategy;

@Dependent
public class ClassIdentifierStrategy
implements IdentifierStrategy {
    private Map<Class<?>, String> identifierNames = new ConcurrentHashMap();

    @Override
    public boolean canIdentify(Class<?> targetClass) {
        return Class.class.equals(targetClass);
    }

    @Override
    public String getIdentifier(Object target) {
        if (!(target instanceof Class)) {
            throw new IllegalArgumentException("Target [" + target + "] must be instance of Class");
        }
        return this.getIdentifierName((Class)target);
    }

    private String getIdentifierName(Class<?> cls) {
        if (!this.identifierNames.containsKey(cls)) {
            Identifier identifier;
            String name = null;
            if (cls.isAnnotationPresent(Identifier.class) && (identifier = cls.getAnnotation(Identifier.class)).name() != null && !"".equals(identifier.name().trim())) {
                name = identifier.name();
            }
            if (name == null) {
                name = cls.getName().substring(cls.getName().lastIndexOf(46) + 1);
            }
            this.identifierNames.put(cls, name);
            return name;
        }
        return this.identifierNames.get(cls);
    }
}

