/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.permission;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.permission.Permission;
import org.jboss.seam.security.permission.PermissionResolver;
import org.jboss.seam.security.permission.PermissionStore;
import org.jboss.seam.security.permission.RuleBasedPermissionResolver;

@SessionScoped
public class PersistentPermissionResolver
implements PermissionResolver,
Serializable {
    private static final long serialVersionUID = -603389172032219059L;
    @Inject
    Identity identity;
    @Inject
    PermissionStore permissionStore;
    @Inject
    Instance<RuleBasedPermissionResolver> ruleBasedPermissionResolver;

    public PermissionStore getPermissionStore() {
        return this.permissionStore;
    }

    public void setPermissionStore(PermissionStore permissionStore) {
        this.permissionStore = permissionStore;
    }

    @Override
    public boolean hasPermission(Object target, String action) {
        if (this.permissionStore == null) {
            return false;
        }
        if (!this.identity.isLoggedIn()) {
            return false;
        }
        if (!this.permissionStore.isEnabled()) {
            return false;
        }
        List<Permission> permissions = this.permissionStore.listPermissions(target, action);
        String username = this.identity.getUser().getId();
        if (permissions != null) {
            for (Permission permission : permissions) {
                if (!username.equals(permission.getIdentity().getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void filterSetByAction(Set<Object> targets, String action) {
        if (this.permissionStore == null) {
            return;
        }
        if (!this.identity.isLoggedIn()) {
            return;
        }
        List<Permission> permissions = this.permissionStore.listPermissions(targets, action);
        String username = this.identity.getUser().getId();
        Iterator<Object> iter = targets.iterator();
        block0: while (iter.hasNext()) {
            Object target = iter.next();
            for (Permission permission : permissions) {
                if (!permission.getResource().equals(target) || !username.equals(permission.getIdentity().getName())) continue;
                iter.remove();
                continue block0;
            }
        }
    }
}

