/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.social.facebook;

import javax.inject.Inject;
import org.codehaus.jackson.map.Module;
import org.jboss.logging.Logger;
import org.jboss.seam.social.core.HttpResponse;
import org.jboss.seam.social.core.OAuthServiceJackson;
import org.jboss.seam.social.core.RestVerb;
import org.jboss.seam.social.core.UserProfile;
import org.jboss.seam.social.facebook.Facebook;
import org.jboss.seam.social.facebook.model.UserJackson;

public class FacebookJackson
extends OAuthServiceJackson
implements Facebook {
    static final String USER_PROFILE_URL = "https://graph.facebook.com/me";
    static final String LOGO_URL = "https://d2l6uygi1pgnys.cloudfront.net/2-2-08/images/buttons/facebook_connect.png";
    static final String STATUS_UPDATE_URL = "https://graph.facebook.com/me/feed";
    private static final String VERIFIER_PARAM_NAME = "code";
    @Inject
    private Logger log;
    private UserJackson myProfile;
    private static final long serialVersionUID = -1388022067022793683L;

    public String getServiceLogo() {
        return LOGO_URL;
    }

    @Override
    public UserProfile getMyProfile() {
        return this.myProfile;
    }

    public String getType() {
        return "Facebook";
    }

    public Object updateStatus() {
        return this.updateStatus(this.getStatus());
    }

    public Object updateStatus(String message) {
        HttpResponse resp = this.sendSignedRequest(RestVerb.POST, STATUS_UPDATE_URL, "message", message);
        this.log.debugf("Update staut is %s", (Object)message);
        this.setStatus("");
        this.log.debugf("Response is : %s", (Object)resp.getBody());
        return null;
    }

    @Override
    protected void initMyProfile() {
        HttpResponse resp = this.sendSignedRequest(RestVerb.GET, USER_PROFILE_URL);
        this.myProfile = this.jsonMapper.readValue(resp, UserJackson.class);
    }

    @Override
    public String getVerifierParamName() {
        return VERIFIER_PARAM_NAME;
    }

    @Override
    protected Module getJacksonModule() {
        return null;
    }
}

