/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.social.twitter;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.Module;
import org.jboss.logging.Logger;
import org.jboss.seam.social.core.HttpResponse;
import org.jboss.seam.social.core.OAuthServiceJackson;
import org.jboss.seam.social.core.RestVerb;
import org.jboss.seam.social.core.URLUtils;
import org.jboss.seam.social.core.UserProfile;
import org.jboss.seam.social.twitter.Twitter;
import org.jboss.seam.social.twitter.TwitterModule;
import org.jboss.seam.social.twitter.model.SuggestionCategory;
import org.jboss.seam.social.twitter.model.Tweet;
import org.jboss.seam.social.twitter.model.TwitterProfile;

public class TwitterJackson
extends OAuthServiceJackson
implements Twitter {
    private static final long serialVersionUID = 6806035986656777834L;
    static final String VERIFY_CREDENTIALS_URL = "https://api.twitter.com/1/account/verify_credentials.json";
    static final String GET_USER_PROFILE_URL = "https://api.twitter.com/1/users/show.json";
    static final String SEARCH_USER_URL = "https://api.twitter.com/1/users/search.json";
    static final String SUGGESTION_CATEGORIES = "https://api.twitter.com/1/users/suggestions.json";
    static final String FRIENDS_STATUSES_URL = "https://api.twitter.com/1/statuses/friends.json?screen_name={screen_name}";
    static final String TWEET_URL = "https://api.twitter.com/1/statuses/update.json";
    static final String RETWEET_URL = "https://api.twitter.com/1/statuses/retweet/{tweet_id}.json";
    static final String LOGO_URL = "https://d2l6uygi1pgnys.cloudfront.net/2-2-08/images/buttons/twitter_connect.png";
    @Inject
    Logger log;

    public Tweet updateStatus(String message) {
        HttpResponse resp = this.sendSignedRequest(RestVerb.POST, TWEET_URL, "status", message);
        this.log.infof("update status is %s", (Object)message);
        this.setStatus("");
        return this.jsonMapper.readValue(resp, Tweet.class);
    }

    public String getServiceLogo() {
        return LOGO_URL;
    }

    public String getType() {
        return "Twitter";
    }

    public Tweet updateStatus() {
        return this.updateStatus(this.getStatus());
    }

    public String getProfileId() {
        this.requireAuthorization();
        return this.getMyProfile().getId();
    }

    public String getScreenName() {
        this.requireAuthorization();
        return this.getMyProfile().getScreenName();
    }

    public TwitterProfile getMyProfile() {
        return (TwitterProfile)this.myProfile;
    }

    public TwitterProfile getUserProfile(String screenName) {
        return this.jsonMapper.readValue(this.sendSignedRequest(RestVerb.GET, URLUtils.appendParametersToQueryString(GET_USER_PROFILE_URL, "screen_name", screenName)), TwitterProfile.class);
    }

    public TwitterProfile getUserProfile(long userId) {
        return this.jsonMapper.readValue(this.sendSignedRequest(RestVerb.GET, URLUtils.appendParametersToQueryString(GET_USER_PROFILE_URL, "user_id", String.valueOf(userId))), TwitterProfile.class);
    }

    public List<TwitterProfile> getUsers(Long ... userIds) {
        String joinedIds = URLUtils.commaJoiner.join((Object[])userIds);
        return this.jsonMapper.readValue(this.sendSignedRequest(RestVerb.GET, URLUtils.appendParametersToQueryString(GET_USER_PROFILE_URL, "user_id", joinedIds)), TwitterProfileList.class);
    }

    public List<TwitterProfile> getUsers(String ... screenNames) {
        String joinedScreenNames = URLUtils.commaJoiner.join((Object[])screenNames);
        return this.jsonMapper.readValue(this.sendSignedRequest(RestVerb.GET, URLUtils.appendParametersToQueryString(GET_USER_PROFILE_URL, "screen_name", joinedScreenNames)), TwitterProfileList.class);
    }

    public List<TwitterProfile> searchForUsers(String query) {
        this.requireAuthorization();
        return this.jsonMapper.readValue(this.sendSignedRequest(RestVerb.GET, URLUtils.appendParametersToQueryString(SEARCH_USER_URL, "q", query)), TwitterProfileList.class);
    }

    public List<SuggestionCategory> getSuggestionCategories() {
        this.requireAuthorization();
        return this.jsonMapper.readValue(this.sendSignedRequest(RestVerb.GET, SUGGESTION_CATEGORIES), SuggestionCategoryList.class);
    }

    public List<TwitterProfile> getSuggestions(String slug) {
        return this.jsonMapper.readValue(this.sendSignedRequest(RestVerb.GET, "https://api.twitter.com/1/users/suggestions/" + slug + ".json"), TwitterProfileUsersList.class).getList();
    }

    @Override
    protected void initMyProfile() {
        this.myProfile = (UserProfile)this.jsonMapper.readValue(this.sendSignedRequest(RestVerb.GET, VERIFY_CREDENTIALS_URL), TwitterProfile.class);
    }

    @Override
    protected Module getJacksonModule() {
        return new TwitterModule();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class TwitterProfileUsersList {
        private final List<TwitterProfile> list;

        @JsonCreator
        public TwitterProfileUsersList(@JsonProperty(value="users") List<TwitterProfile> list) {
            this.list = list;
        }

        public List<TwitterProfile> getList() {
            return this.list;
        }
    }

    static class SuggestionCategoryList
    extends ArrayList<SuggestionCategory> {
        SuggestionCategoryList() {
        }
    }

    static class TwitterProfileList
    extends ArrayList<TwitterProfile> {
        TwitterProfileList() {
        }
    }
}

