/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.social;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class URLUtils {
    private static final String EMPTY_STRING = "";
    private static final String UTF_8 = "UTF-8";
    private static final String PAIR_SEPARATOR = "=";
    private static final String PARAM_SEPARATOR = "&";
    private static final char MULTI_VALUE_SEPARATOR = ',';
    private static final char QUERY_STRING_SEPARATOR = '?';
    private static final String ERROR_MSG = String.format("Cannot find specified encoding: %s", "UTF-8");
    private static final Set<EncodingRule> ENCODING_RULES;
    public static Joiner commaJoiner;
    private static Joiner.MapJoiner queryMapJoiner;

    public static String formURLEncodeMap(Map<String, String> map) {
        return map.size() <= 0 ? EMPTY_STRING : URLUtils.doFormUrlEncode(map);
    }

    private static String doFormUrlEncode(Map<String, String> map) {
        Map urlEncodedMap = Maps.transformValues(map, (Function)new Function<String, String>(){

            public String apply(String input) {
                return URLUtils.formURLEncode(input);
            }
        });
        return queryMapJoiner.join(urlEncodedMap);
    }

    public static String percentEncode(String string) {
        String encoded = URLUtils.formURLEncode(string);
        for (EncodingRule rule : ENCODING_RULES) {
            encoded = rule.apply(encoded);
        }
        return encoded;
    }

    public static String formURLEncode(String string) {
        try {
            return URLEncoder.encode(string, UTF_8);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException(ERROR_MSG, uee);
        }
    }

    public static String formURLDecode(String string) {
        try {
            return URLDecoder.decode(string, UTF_8);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException(ERROR_MSG, uee);
        }
    }

    public static String appendParametersToQueryString(String url, Map<String, String> params) {
        String queryString = URLUtils.formURLEncodeMap(params);
        if (queryString.equals(EMPTY_STRING)) {
            return url;
        }
        url = url + (url.indexOf(63) != -1 ? PARAM_SEPARATOR : Character.valueOf('?'));
        url = url + queryString;
        return url;
    }

    public static String appendParametersToQueryString(String url, String key, String value) {
        if (EMPTY_STRING.equals(key) || key == null) {
            return url;
        }
        url = url + (url.indexOf(63) != -1 ? PARAM_SEPARATOR : Character.valueOf('?'));
        url = url + key + PAIR_SEPARATOR + URLUtils.formURLEncode(value);
        return url;
    }

    public static String concatSortedPercentEncodedParams(Map<String, String> params) {
        StringBuilder result = new StringBuilder();
        for (String key : params.keySet()) {
            result.append(key).append(PAIR_SEPARATOR);
            result.append(params.get(key)).append(PARAM_SEPARATOR);
        }
        return result.toString().substring(0, result.length() - 1);
    }

    public static Map<String, String> queryStringToMap(String queryString) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (queryString != null && queryString.length() > 0) {
            for (String param : queryString.split(PARAM_SEPARATOR)) {
                String[] pair = param.split(PAIR_SEPARATOR);
                String key = URLUtils.formURLDecode(pair[0]);
                String value = pair.length > 1 ? URLUtils.formURLDecode(pair[1]) : EMPTY_STRING;
                result.put(key, value);
            }
        }
        return result;
    }

    static {
        commaJoiner = Joiner.on((char)',').skipNulls();
        queryMapJoiner = Joiner.on((String)PARAM_SEPARATOR).withKeyValueSeparator(PAIR_SEPARATOR);
        HashSet<EncodingRule> rules = new HashSet<EncodingRule>();
        rules.add(new EncodingRule("*", "%2A"));
        rules.add(new EncodingRule("+", "%20"));
        rules.add(new EncodingRule("%7E", "~"));
        ENCODING_RULES = Collections.unmodifiableSet(rules);
    }

    private static final class EncodingRule {
        private final String ch;
        private final String toCh;

        EncodingRule(String ch, String toCh) {
            this.ch = ch;
            this.toCh = toCh;
        }

        String apply(String string) {
            return string.replace(this.ch, this.toCh);
        }
    }
}

