/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.social.scribe;

import org.jboss.seam.social.SeamSocialException;
import org.jboss.seam.social.oauth.OAuthProvider;
import org.jboss.seam.social.oauth.OAuthRequest;
import org.jboss.seam.social.oauth.OAuthServiceSettings;
import org.jboss.seam.social.oauth.OAuthToken;
import org.jboss.seam.social.rest.RestVerb;
import org.jboss.seam.social.scribe.OAuthRequestScribe;
import org.jboss.seam.social.scribe.OAuthTokenScribe;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.Api;
import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;

public class OAuthProviderScribe
implements OAuthProvider {
    private static final String SCRIBE_API_PREFIX = "org.scribe.builder.api.";
    private static final String SCRIBE_API_SUFFIX = "Api";
    private OAuthService service;

    OAuthService getService() {
        if (this.service == null) {
            throw new IllegalStateException("OAuthProvider can be used before it is initialized");
        }
        return this.service;
    }

    public OAuthToken getRequestToken() {
        return new OAuthTokenScribe("2.0".equals(this.getVersion()) ? null : this.getService().getRequestToken());
    }

    public OAuthToken getAccessToken(OAuthToken requestToken, String verifier) {
        return this.createToken(this.getService().getAccessToken(this.extractToken(requestToken), new Verifier(verifier)));
    }

    public void signRequest(OAuthToken accessToken, OAuthRequest request) {
        this.getService().signRequest(this.extractToken(accessToken), ((OAuthRequestScribe)request).getDelegate());
    }

    public String getVersion() {
        return this.getService().getVersion();
    }

    public String getAuthorizationUrl(OAuthToken tok) {
        return this.getService().getAuthorizationUrl(this.extractToken(tok));
    }

    public OAuthProviderScribe(OAuthServiceSettings settings) {
        Class<? extends Api> apiClass = this.getApiClass(settings.getServiceName());
        ServiceBuilder serviceBuilder = new ServiceBuilder().provider(apiClass).apiKey(settings.getApiKey()).apiSecret(settings.getApiSecret());
        if (settings.getCallback() != null && !"".equals(settings.getCallback())) {
            serviceBuilder.callback(settings.getCallback());
        }
        if (settings.getScope() != null && !"".equals(settings.getScope())) {
            serviceBuilder.scope(settings.getScope());
        }
        this.service = serviceBuilder.build();
    }

    private Class<? extends Api> getApiClass(String serviceName) {
        String className = SCRIBE_API_PREFIX + serviceName + SCRIBE_API_SUFFIX;
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new SeamSocialException("There no such Scribe Api class " + className, (Throwable)e);
        }
    }

    protected Token extractToken(OAuthToken tok) {
        return ((OAuthTokenScribe)tok).delegate;
    }

    public OAuthRequest requestFactory(RestVerb verb, String uri) {
        return new OAuthRequestScribe(verb, uri);
    }

    public OAuthToken tokenFactory(String token, String secret) {
        return new OAuthTokenScribe(token, secret);
    }

    private OAuthToken createToken(Token token) {
        return new OAuthTokenScribe(token);
    }
}

