/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.bean.generic;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.PassivationCapable;
import org.jboss.seam.solder.bean.ForwardingBean;
import org.jboss.seam.solder.bean.generic.GenericIdentifier;
import org.jboss.seam.solder.bean.generic.GenericManagedBean;
import org.jboss.seam.solder.bean.generic.GenericMarker;
import org.jboss.seam.solder.literal.AnyLiteral;

abstract class AbstactGenericBean<T>
extends ForwardingBean<T>
implements PassivationCapable {
    private final Bean<T> delegate;
    private final Set<Annotation> qualifiers;
    private final BeanManager beanManager;
    private final String id;
    private final boolean alternative;
    private final Class<?> beanClass;

    protected AbstactGenericBean(Bean<T> delegate, Set<Annotation> qualifiers, GenericIdentifier identifier, String id, boolean alternative, Class<?> beanClass, BeanManager beanManager) {
        this.delegate = delegate;
        this.beanManager = beanManager;
        this.qualifiers = new HashSet<Annotation>();
        for (Annotation qualifier : qualifiers) {
            if (qualifier.annotationType().equals(GenericMarker.class)) continue;
            this.qualifiers.add(qualifier);
        }
        this.qualifiers.add((Annotation)AnyLiteral.INSTANCE);
        this.id = this.getClass().getName() + "-" + identifier.toString() + "-" + id;
        this.alternative = alternative;
        this.beanClass = beanClass;
    }

    protected BeanManager getBeanManager() {
        return this.beanManager;
    }

    @Override
    protected Bean<T> delegate() {
        return this.delegate;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof GenericManagedBean) {
            GenericManagedBean that = (GenericManagedBean)obj;
            return this.getId().equals(that.getId());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public boolean isAlternative() {
        return this.alternative;
    }
}

