/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.logging;

import java.io.Serializable;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.seam.solder.logging.Category;
import org.jboss.seam.solder.logging.Logger;
import org.jboss.seam.solder.logging.LoggerProducer;
import org.jboss.seam.solder.logging.TypedCategory;
import org.jboss.seam.solder.logging.TypedMessageLogger;
import org.jboss.seam.solder.messages.Locale;
import org.jboss.seam.solder.reflection.Reflections;
import org.jboss.seam.solder.util.Locales;

class TypedMessageLoggerProducer
implements Serializable {
    TypedMessageLoggerProducer() {
    }

    @Produces
    @TypedMessageLogger
    Object produceTypedLogger(InjectionPoint injectionPoint) {
        Annotated annotated = injectionPoint.getAnnotated();
        if (annotated.isAnnotationPresent(Category.class)) {
            if (annotated.isAnnotationPresent(Locale.class)) {
                return Logger.getMessageLogger(this.getInjectionPointRawType(injectionPoint), ((Category)annotated.getAnnotation(Category.class)).value(), Locales.toLocale(((Locale)annotated.getAnnotation(Locale.class)).value()));
            }
            return Logger.getMessageLogger(this.getInjectionPointRawType(injectionPoint), ((Category)annotated.getAnnotation(Category.class)).value());
        }
        if (annotated.isAnnotationPresent(TypedCategory.class)) {
            if (annotated.isAnnotationPresent(Locale.class)) {
                return Logger.getMessageLogger(this.getInjectionPointRawType(injectionPoint), ((TypedCategory)annotated.getAnnotation(TypedCategory.class)).value().getName(), Locales.toLocale(((Locale)annotated.getAnnotation(Locale.class)).value()));
            }
            return Logger.getMessageLogger(this.getInjectionPointRawType(injectionPoint), ((TypedCategory)annotated.getAnnotation(TypedCategory.class)).value().getName());
        }
        if (annotated.isAnnotationPresent(Locale.class)) {
            return Logger.getMessageLogger(this.getInjectionPointRawType(injectionPoint), LoggerProducer.getDeclaringRawType(injectionPoint).getName(), Locales.toLocale(((Locale)annotated.getAnnotation(Locale.class)).value()));
        }
        return Logger.getMessageLogger(this.getInjectionPointRawType(injectionPoint), LoggerProducer.getDeclaringRawType(injectionPoint).getName());
    }

    private Class<?> getInjectionPointRawType(InjectionPoint injectionPoint) {
        return Reflections.getRawType(injectionPoint.getType());
    }
}

