/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.logging.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.jboss.seam.solder.logging.internal.Cause;
import org.jboss.seam.solder.logging.internal.Message;
import org.jboss.seam.solder.logging.internal.MessageBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MessageBundleInvocationHandler
implements InvocationHandler {
    private final String projectCode;

    protected MessageBundleInvocationHandler(String projectCode) {
        this.projectCode = projectCode;
    }

    protected MessageBundleInvocationHandler(Class<?> type) {
        this(type.getAnnotation(MessageBundle.class));
    }

    protected MessageBundleInvocationHandler(MessageBundle messageBundle) {
        this(messageBundle != null ? messageBundle.projectCode() : null);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String result;
        Message message = method.getAnnotation(Message.class);
        if (message == null) {
            return null;
        }
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        ArrayList<Object> newArgs = new ArrayList<Object>();
        Throwable cause = MessageBundleInvocationHandler.extractCause(parameterAnnotations, args, newArgs);
        switch (message.format()) {
            case PRINTF: {
                result = String.format(this.getFormatString(message), newArgs.toArray());
                break;
            }
            case MESSAGE_FORMAT: {
                result = MessageFormat.format(this.getFormatString(message), newArgs.toArray());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Class<?> returnType = method.getReturnType();
        if (Throwable.class.isAssignableFrom(returnType)) {
            if (cause != null) {
                Constructor<?> constructor = returnType.getConstructor(String.class, Throwable.class);
                return constructor.newInstance(result, cause);
            }
            Constructor<?> constructor = returnType.getConstructor(String.class);
            return constructor.newInstance(result);
        }
        return result;
    }

    protected String getFormatString(Message message) {
        String projectCode;
        String formatString = message.value();
        if (formatString == null) {
            return null;
        }
        int id = message.id();
        if (id > 0 && (projectCode = this.projectCode) != null) {
            StringBuilder b = new StringBuilder(32);
            b.append(projectCode).append('-');
            if (id < 10) {
                b.append("0000");
            } else if (id < 100) {
                b.append("000");
            } else if (id < 1000) {
                b.append("00");
            } else if (id < 10000) {
                b.append("0");
            }
            b.append(id);
            b.append(": ");
            b.append(formatString);
            formatString = b.toString();
        }
        return formatString;
    }

    protected static Throwable extractCause(Annotation[][] parameterAnnotations, Object[] args, List<Object> newArgs) {
        Throwable cause = null;
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation[] annotations = parameterAnnotations[i];
            boolean found = false;
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof Cause)) continue;
                if (cause == null) {
                    cause = (Throwable)args[i];
                }
                found = true;
            }
            if (found) continue;
            newArgs.add(args[i]);
        }
        return cause;
    }
}

