/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.util.collections;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.jboss.seam.solder.util.collections.WrappedCollection;

public class WrappedIterator<K, V>
implements Iterator<V> {
    final Iterator<V> delegateIterator;
    final Collection<V> originalDelegate;
    private final WrappedCollection<K, V> collection;

    WrappedIterator(WrappedCollection<K, V> collection) {
        this.collection = collection;
        this.delegateIterator = collection.getParent().iteratorOrListIterator(collection.delegate);
        this.originalDelegate = collection.delegate;
    }

    WrappedIterator(Iterator<V> delegateIterator, WrappedCollection<K, V> collection) {
        this.delegateIterator = delegateIterator;
        this.collection = collection;
        this.originalDelegate = collection.delegate;
    }

    void validateIterator() {
        this.collection.refreshIfEmpty();
        if (this.collection.delegate != this.originalDelegate) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public boolean hasNext() {
        this.validateIterator();
        return this.delegateIterator.hasNext();
    }

    @Override
    public V next() {
        this.validateIterator();
        return this.delegateIterator.next();
    }

    @Override
    public void remove() {
        this.delegateIterator.remove();
        --this.collection.getParent().totalSize;
        this.collection.removeIfEmpty();
    }

    Iterator<V> getDelegateIterator() {
        this.validateIterator();
        return this.delegateIterator;
    }
}

