/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins.acl;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.security.acl.ACLContext;
import org.jboss.security.acl.ACLPermission;
import org.jboss.security.acl.ACLProvider;
import org.jboss.security.acl.config.ACLProviderEntry;
import org.jboss.security.authorization.AuthorizationException;
import org.jboss.security.authorization.EntitlementHolder;
import org.jboss.security.authorization.Permission;
import org.jboss.security.authorization.Resource;
import org.jboss.security.config.ACLInfo;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.ControlFlag;
import org.jboss.security.config.SecurityConfiguration;
import org.jboss.security.identity.Identity;
import org.jboss.security.plugins.acl.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossACLContext
extends ACLContext {
    private static Logger log = Logger.getLogger(JBossACLContext.class);
    private final boolean trace = log.isTraceEnabled();

    public JBossACLContext(String name) {
        this.securityDomainName = name;
    }

    public <T> EntitlementHolder<T> getEntitlements(final Class<T> clazz, final Resource resource, final Identity identity) throws AuthorizationException {
        Set aggregateEntitlements = null;
        try {
            this.initializeModules(resource, identity);
        }
        catch (PrivilegedActionException e1) {
            throw new RuntimeException(e1);
        }
        try {
            aggregateEntitlements = (Set)AccessController.doPrivileged(new PrivilegedExceptionAction<Set<T>>(){

                @Override
                public Set<T> run() throws AuthorizationException {
                    Set entitlements = JBossACLContext.this.invokeACL(clazz, resource, identity);
                    JBossACLContext.this.invokeTeardown();
                    return entitlements;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception exc = e.getException();
            if (this.trace) {
                log.trace((Object)"Error in authorize:", (Throwable)exc);
            }
            this.invokeTeardown();
            throw (AuthorizationException)((Object)exc);
        }
        final Set result = aggregateEntitlements;
        return new EntitlementHolder<T>(){

            public Set<T> getEntitled() {
                return result;
            }
        };
    }

    public int authorize(final Resource resource, final Identity identity, final Permission permission) throws AuthorizationException {
        Integer result;
        if (!(permission instanceof ACLPermission)) {
            throw new AuthorizationException("Unable to process permission of type " + permission.getClass());
        }
        try {
            this.initializeModules(resource, identity);
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException(pae);
        }
        try {
            result = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws AuthorizationException {
                    return JBossACLContext.this.invokeAuthorize(resource, identity, (ACLPermission)permission);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception exc = e.getException();
            if (this.trace) {
                log.trace((Object)("Error authorizing identity " + identity + ":"), (Throwable)exc);
            }
            this.invokeTeardown();
            throw (AuthorizationException)((Object)exc);
        }
        return result;
    }

    private void initializeModules(Resource resource, Identity identity) throws PrivilegedActionException {
        this.modules.clear();
        ACLInfo aclInfo = this.getACLInfo(this.securityDomainName, resource);
        if (aclInfo == null) {
            throw new IllegalStateException("ACL Info is null");
        }
        ACLProviderEntry[] entries = aclInfo.getACLProviderEntry();
        int len = entries != null ? entries.length : 0;
        for (int i = 0; i < len; ++i) {
            ACLProviderEntry entry = entries[i];
            this.modules.add(this.instantiateModule(entry.getAclProviderName(), entry.getOptions()));
            this.controlFlags.add(entry.getControlFlag());
        }
    }

    private ACLProvider instantiateModule(String name, Map<String, Object> map) throws PrivilegedActionException {
        ACLProvider am = null;
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        try {
            Class<?> clazz = tcl.loadClass(name);
            am = (ACLProvider)clazz.newInstance();
        }
        catch (Exception e) {
            log.debug((Object)"Error instantiating AuthorizationModule:", (Throwable)e);
        }
        if (am == null) {
            throw new IllegalStateException("ACLProvider has not been instantiated");
        }
        am.initialize(this.sharedState, map);
        return am;
    }

    private <T> Set<T> invokeACL(Class<T> clazz, Resource resource, Identity identity) throws AuthorizationException {
        HashSet entitlements = new HashSet();
        int length = this.modules.size();
        for (int i = 0; i < length; ++i) {
            ACLProvider module = (ACLProvider)this.modules.get(i);
            try {
                Set er = module.getEntitlements(clazz, resource, identity);
                if (er == null) {
                    throw new AuthorizationException("module " + module.getClass().getName() + " generated null entitlements.");
                }
                entitlements.addAll(er);
                continue;
            }
            catch (Exception ae) {
                throw new AuthorizationException(ae.getMessage());
            }
        }
        return entitlements;
    }

    private int invokeAuthorize(Resource resource, Identity identity, ACLPermission permission) throws AuthorizationException {
        if (this.modules == null || this.modules.size() == 0) {
            return 1;
        }
        boolean encounteredRequiredError = false;
        int overallDecision = -1;
        for (int i = 0; i < this.modules.size(); ++i) {
            ACLProvider module = (ACLProvider)this.modules.get(i);
            ControlFlag flag = (ControlFlag)this.controlFlags.get(i);
            int decision = -1;
            try {
                int n = decision = module.isAccessGranted(resource, identity, permission) ? 1 : -1;
                if (this.trace) {
                    log.trace((Object)("ACL module " + module.getClass().getName() + (decision == 1 ? " granted " : " denied ") + "access to resource " + resource));
                }
                if (decision == 1) {
                    overallDecision = 1;
                    if (flag != ControlFlag.SUFFICIENT || encounteredRequiredError) continue;
                    if (!this.trace) break;
                    log.trace((Object)"SUFFICIENT module succeeded: overall status=PERMIT");
                    break;
                }
                if (flag == ControlFlag.REQUISITE) {
                    if (this.trace) {
                        log.trace((Object)"REQUISITE module failed: overall status=DENY");
                    }
                    overallDecision = -1;
                    break;
                }
                if (flag != ControlFlag.REQUIRED) continue;
                if (this.trace) {
                    log.trace((Object)"REQUIRED module failed: overall status=DENY");
                }
                encounteredRequiredError = true;
                continue;
            }
            catch (Exception ae) {
                throw new AuthorizationException(ae.getMessage());
            }
        }
        if (encounteredRequiredError) {
            overallDecision = -1;
        }
        return overallDecision;
    }

    private ACLInfo getACLInfo(String domainName, Resource resource) {
        ApplicationPolicy aPolicy = SecurityConfiguration.getApplicationPolicy(domainName);
        if (aPolicy == null) {
            if (this.trace) {
                log.trace((Object)("Application Policy not obtained for domain=" + domainName + ". Trying to obtain the App policy for the default domain of the layer:"));
            }
            aPolicy = SecurityConfiguration.getApplicationPolicy(resource.getLayer().name());
        }
        if (aPolicy == null) {
            throw new IllegalStateException("Application Policy is null for domain:" + domainName);
        }
        return aPolicy.getAclInfo();
    }

    private void invokeTeardown() throws AuthorizationException {
        int length = this.modules.size();
        for (int i = 0; i < length; ++i) {
            ACLProvider module = (ACLProvider)this.modules.get(i);
            boolean bool = module.tearDown();
            if (bool) continue;
            throw new AuthorizationException("TearDown on module failed:" + module.getClass());
        }
        this.modules.clear();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(((Object)((Object)this)).getClass().getCanonicalName()).append("()");
        builder.append(this.securityDomainName).append(")]");
        return builder.toString();
    }
}

