/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.attr;

public class PortRange {
    public static final int UNBOUND = -1;
    private int lowerBound;
    private int upperBound;

    public PortRange() {
        this(-1, -1);
    }

    public PortRange(int singlePort) {
        this(singlePort, singlePort);
    }

    public PortRange(int lowerBound, int upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public static PortRange getInstance(String value) {
        int lowerBound = -1;
        int upperBound = -1;
        if (value.length() == 0 || value.equals("-")) {
            return new PortRange();
        }
        int dashPos = value.indexOf(45);
        if (dashPos == -1) {
            lowerBound = upperBound = Integer.parseInt(value);
        } else if (dashPos == 0) {
            upperBound = Integer.parseInt(value.substring(1));
        } else {
            lowerBound = Integer.parseInt(value.substring(0, dashPos));
            int len = value.length();
            if (dashPos != len - 1) {
                upperBound = Integer.parseInt(value.substring(dashPos + 1, len));
            }
        }
        return new PortRange(lowerBound, upperBound);
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public boolean isLowerBounded() {
        return this.lowerBound != -1;
    }

    public boolean isUpperBounded() {
        return this.upperBound != -1;
    }

    public boolean isSinglePort() {
        return this.lowerBound == this.upperBound && this.lowerBound != -1;
    }

    public boolean isUnbound() {
        return this.lowerBound == -1 && this.upperBound == -1;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PortRange)) {
            return false;
        }
        PortRange other = (PortRange)o;
        if (this.lowerBound != other.lowerBound) {
            return false;
        }
        return this.upperBound == other.upperBound;
    }

    public String encode() {
        if (this.isUnbound()) {
            return "";
        }
        if (this.isSinglePort()) {
            return String.valueOf(this.lowerBound);
        }
        if (!this.isLowerBounded()) {
            return "-" + String.valueOf(this.upperBound);
        }
        if (!this.isUpperBounded()) {
            return String.valueOf(this.lowerBound) + "-";
        }
        return String.valueOf(this.lowerBound) + "-" + String.valueOf(this.upperBound);
    }
}

