/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.shrinkwrap.descriptor.api;

import java.io.OutputStream;

/**
 * End-user domain-specific language (DSL) view of a metadata Descriptor.
 *
 * @author <a href="mailto:aslak@redhat.com">Aslak Knutsen</a>
 * @author <a href="mailto:andrew.rubinger@jboss.org">ALR</a>
 */
public interface Descriptor
{
   /**
    * Get the {@link Descriptor} name. The name can be specified by 
    * user at construction time, or predefined as a default by type.
    * 
    * @return the descriptor name
    */
   String getDescriptorName();
   
   /**
    * Exports the descriptor as a {@link String}
    * @return
    * @throws DescriptorExportException
    */
   String exportAsString() throws DescriptorExportException;

   /**
    * Export the descriptor to a given {@link OutputStream}.
    * The {@link OutputStream} will not be flushed or closed by this operation.
    * 
    * @param output Where to export
    * @throws IllegalArgumentException if output is null
    * @throws DescriptorExportException if problems exporting
    */
   void exportTo(OutputStream output) throws DescriptorExportException, IllegalArgumentException;

}
