package org.jboss.shrinkwrap.descriptor.api.ejbjar31; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.ejbjar.*;
import org.jboss.shrinkwrap.descriptor.api.ejbjar.JavaeeRelationshipRoleSourceCommonType;
/**
 * This interface defines the contract for the <code> relationship-role-sourceType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 * @author <a href="mailto:ggastald@redhat.com">George Gastaldi</a>
 */
public interface RelationshipRoleSourceType<T> extends Child<T>, 
    JavaeeRelationshipRoleSourceCommonType<T, RelationshipRoleSourceType<T>> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: RelationshipRoleSourceType ElementName: xsd:string ElementType : description
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>description</code> elements, 
    * a new <code>description</code> element 
    * @param values list of <code>description</code> objects 
    * @return the current instance of <code>RelationshipRoleSourceType<T></code> 
    */
   public RelationshipRoleSourceType<T> description(String ... values);

   /**
    * Returns all <code>description</code> elements
    * @return list of <code>description</code> 
    */
   public List<String> getAllDescription();

   /**
    * Removes the <code>description</code> element 
    * @return the current instance of <code>RelationshipRoleSourceType<T></code> 
    */
   public RelationshipRoleSourceType<T> removeAllDescription();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: RelationshipRoleSourceType ElementName: javaee:xsdNMTOKENType ElementType : ejb-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>ejb-name</code> element
    * @param ejbName the value for the element <code>ejb-name</code> 
    * @return the current instance of <code>RelationshipRoleSourceType<T></code> 
    */
   public RelationshipRoleSourceType<T> ejbName(String ejbName);

   /**
    * Returns the <code>ejb-name</code> element
    * @return the node defined for the element <code>ejb-name</code> 
    */
   public String getEjbName();

   /**
    * Removes the <code>ejb-name</code> element 
    * @return the current instance of <code>RelationshipRoleSourceType<T></code> 
    */
   public RelationshipRoleSourceType<T> removeEjbName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: RelationshipRoleSourceType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>RelationshipRoleSourceType<T></code> 
    */
   public RelationshipRoleSourceType<T> id(String id);

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
   public String getId();

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>RelationshipRoleSourceType<T></code> 
    */
   public RelationshipRoleSourceType<T> removeId();
}
