package org.jboss.shrinkwrap.descriptor.api.jobXML10; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jobXML10.Listener;
import org.jboss.shrinkwrap.descriptor.api.jobXML.*;
/**
 * This interface defines the contract for the <code> Listeners </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface Listeners<T> extends Child<T>, 
    JslListenersCommType<T, Listeners<T>,
    Listener<Listeners<T>>> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: Listeners ElementName: jsl:Listener ElementType : listener
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>listener</code> element will be created and returned.
    * Otherwise, the first existing <code>listener</code> element will be returned.
    * @return the instance defined for the element <code>listener</code> 
    */
   public Listener<Listeners<T>> getOrCreateListener();

   /**
    * Creates a new <code>listener</code> element 
    * @return the new created instance of <code>Listener<Listeners<T>></code> 
    */
   public Listener<Listeners<T>> createListener();

   /**
    * Returns all <code>listener</code> elements
    * @return list of <code>listener</code> 
    */
   public List<Listener<Listeners<T>>> getAllListener();

   /**
    * Removes all <code>listener</code> elements 
    * @return the current instance of <code>Listener<Listeners<T>></code> 
    */
   public Listeners<T> removeAllListener();
}
