package org.jboss.shrinkwrap.descriptor.api.validationMapping10; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.validationMapping10.ValidatedByType;
import org.jboss.shrinkwrap.descriptor.api.validationMapping.*;
/**
 * This interface defines the contract for the <code> constraint-definitionType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 * @author <a href="mailto:ggastald@redhat.com">George Gastaldi</a>
 */
public interface ConstraintDefinitionType<T> extends Child<T>, 
    MapConstraintDefinitionCommonType<T, ConstraintDefinitionType<T>,
    ValidatedByType<ConstraintDefinitionType<T>>> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConstraintDefinitionType ElementName: map:validated-byType ElementType : validated-by
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>validated-by</code> element with the given value will be created.
    * Otherwise, the existing <code>validated-by</code> element will be returned.
    * @return  a new or existing instance of <code>ValidatedByType<ConstraintDefinitionType<T>></code> 
    */
   public ValidatedByType<ConstraintDefinitionType<T>> getOrCreateValidatedBy();

   /**
    * Removes the <code>validated-by</code> element 
    * @return the current instance of <code>ConstraintDefinitionType<T></code> 
    */
   public ConstraintDefinitionType<T> removeValidatedBy();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConstraintDefinitionType ElementName: xsd:string ElementType : annotation
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>annotation</code> attribute
    * @param annotation the value for the attribute <code>annotation</code> 
    * @return the current instance of <code>ConstraintDefinitionType<T></code> 
    */
   public ConstraintDefinitionType<T> annotation(String annotation);

   /**
    * Returns the <code>annotation</code> attribute
    * @return the value defined for the attribute <code>annotation</code> 
    */
   public String getAnnotation();

   /**
    * Removes the <code>annotation</code> attribute 
    * @return the current instance of <code>ConstraintDefinitionType<T></code> 
    */
   public ConstraintDefinitionType<T> removeAnnotation();
}
