package org.jboss.shrinkwrap.descriptor.api.webfragment31; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.webfragment.*;
/**
 * This interface defines the contract for the <code> ordering-orderingType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface OrderingOrderingType<T> extends Child<T>, 
    JavaeeOrderingOrderingCommonType<T, OrderingOrderingType<T>> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: OrderingOrderingType ElementName: xsd:token ElementType : name
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>name</code> elements, 
    * a new <code>name</code> element 
    * @param values list of <code>name</code> objects 
    * @return the current instance of <code>OrderingOrderingType<T></code> 
    */
   public OrderingOrderingType<T> name(String ... values);

   /**
    * Returns all <code>name</code> elements
    * @return list of <code>name</code> 
    */
   public List<String> getAllName();

   /**
    * Removes the <code>name</code> element 
    * @return the current instance of <code>OrderingOrderingType<T></code> 
    */
   public OrderingOrderingType<T> removeAllName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: OrderingOrderingType ElementName: javaee:ordering-othersType ElementType : others
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>others</code> element 
    * @return the current instance of <code>OrderingOrderingType<T></code> 
    */
   public OrderingOrderingType<T> others();

   /**
    * Removes the <code>others</code> element 
    * @return the current instance of <code>OrderingOrderingType<T></code> 
    */
   public Boolean isOthers();

   /**
    * Removes the <code>others</code> element 
    * @return the current instance of <code>OrderingOrderingType<T></code> 
    */
   public OrderingOrderingType<T> removeOthers();
}
