package org.jboss.shrinkwrap.descriptor.api.jboss51; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jboss51.SessionBeanType;
import org.jboss.shrinkwrap.descriptor.api.jboss51.MessageDrivenBeanType;
import org.jboss.shrinkwrap.descriptor.api.jboss51.ServiceBeanType;
import org.jboss.shrinkwrap.descriptor.api.jboss51.ConsumerBeanType;
import org.jboss.shrinkwrap.descriptor.api.jboss51.GenericBeanType;
/**
 * This interface defines the contract for the <code> enterprise-beansType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface EnterpriseBeansType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: EnterpriseBeansType ElementName: jboss:session-beanType ElementType : session
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>session</code> element will be created and returned.
    * Otherwise, the first existing <code>session</code> element will be returned.
    * @return the instance defined for the element <code>session</code> 
    */
   public SessionBeanType<EnterpriseBeansType<T>> getOrCreateSession();

   /**
    * Creates a new <code>session</code> element 
    * @return the new created instance of <code>SessionBeanType<EnterpriseBeansType<T>></code> 
    */
   public SessionBeanType<EnterpriseBeansType<T>> createSession();

   /**
    * Returns all <code>session</code> elements
    * @return list of <code>session</code> 
    */
   public List<SessionBeanType<EnterpriseBeansType<T>>> getAllSession();

   /**
    * Removes all <code>session</code> elements 
    * @return the current instance of <code>SessionBeanType<EnterpriseBeansType<T>></code> 
    */
   public EnterpriseBeansType<T> removeAllSession();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: EnterpriseBeansType ElementName: jboss:message-driven-beanType ElementType : message-driven
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>message-driven</code> element will be created and returned.
    * Otherwise, the first existing <code>message-driven</code> element will be returned.
    * @return the instance defined for the element <code>message-driven</code> 
    */
   public MessageDrivenBeanType<EnterpriseBeansType<T>> getOrCreateMessageDriven();

   /**
    * Creates a new <code>message-driven</code> element 
    * @return the new created instance of <code>MessageDrivenBeanType<EnterpriseBeansType<T>></code> 
    */
   public MessageDrivenBeanType<EnterpriseBeansType<T>> createMessageDriven();

   /**
    * Returns all <code>message-driven</code> elements
    * @return list of <code>message-driven</code> 
    */
   public List<MessageDrivenBeanType<EnterpriseBeansType<T>>> getAllMessageDriven();

   /**
    * Removes all <code>message-driven</code> elements 
    * @return the current instance of <code>MessageDrivenBeanType<EnterpriseBeansType<T>></code> 
    */
   public EnterpriseBeansType<T> removeAllMessageDriven();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: EnterpriseBeansType ElementName: jboss:service-beanType ElementType : service
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>service</code> element will be created and returned.
    * Otherwise, the first existing <code>service</code> element will be returned.
    * @return the instance defined for the element <code>service</code> 
    */
   public ServiceBeanType<EnterpriseBeansType<T>> getOrCreateService();

   /**
    * Creates a new <code>service</code> element 
    * @return the new created instance of <code>ServiceBeanType<EnterpriseBeansType<T>></code> 
    */
   public ServiceBeanType<EnterpriseBeansType<T>> createService();

   /**
    * Returns all <code>service</code> elements
    * @return list of <code>service</code> 
    */
   public List<ServiceBeanType<EnterpriseBeansType<T>>> getAllService();

   /**
    * Removes all <code>service</code> elements 
    * @return the current instance of <code>ServiceBeanType<EnterpriseBeansType<T>></code> 
    */
   public EnterpriseBeansType<T> removeAllService();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: EnterpriseBeansType ElementName: jboss:consumer-beanType ElementType : consumer
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>consumer</code> element will be created and returned.
    * Otherwise, the first existing <code>consumer</code> element will be returned.
    * @return the instance defined for the element <code>consumer</code> 
    */
   public ConsumerBeanType<EnterpriseBeansType<T>> getOrCreateConsumer();

   /**
    * Creates a new <code>consumer</code> element 
    * @return the new created instance of <code>ConsumerBeanType<EnterpriseBeansType<T>></code> 
    */
   public ConsumerBeanType<EnterpriseBeansType<T>> createConsumer();

   /**
    * Returns all <code>consumer</code> elements
    * @return list of <code>consumer</code> 
    */
   public List<ConsumerBeanType<EnterpriseBeansType<T>>> getAllConsumer();

   /**
    * Removes all <code>consumer</code> elements 
    * @return the current instance of <code>ConsumerBeanType<EnterpriseBeansType<T>></code> 
    */
   public EnterpriseBeansType<T> removeAllConsumer();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: EnterpriseBeansType ElementName: jboss:generic-beanType ElementType : ejb
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>ejb</code> element will be created and returned.
    * Otherwise, the first existing <code>ejb</code> element will be returned.
    * @return the instance defined for the element <code>ejb</code> 
    */
   public GenericBeanType<EnterpriseBeansType<T>> getOrCreateEjb();

   /**
    * Creates a new <code>ejb</code> element 
    * @return the new created instance of <code>GenericBeanType<EnterpriseBeansType<T>></code> 
    */
   public GenericBeanType<EnterpriseBeansType<T>> createEjb();

   /**
    * Returns all <code>ejb</code> elements
    * @return list of <code>ejb</code> 
    */
   public List<GenericBeanType<EnterpriseBeansType<T>>> getAllEjb();

   /**
    * Removes all <code>ejb</code> elements 
    * @return the current instance of <code>GenericBeanType<EnterpriseBeansType<T>></code> 
    */
   public EnterpriseBeansType<T> removeAllEjb();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: EnterpriseBeansType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>EnterpriseBeansType<T></code> 
    */
   public EnterpriseBeansType<T> id(String id);

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
   public String getId();

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>EnterpriseBeansType<T></code> 
    */
   public EnterpriseBeansType<T> removeId();
}
