package org.jboss.shrinkwrap.descriptor.api.jboss51; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.LoaderRepositoryType;
import org.jboss.shrinkwrap.descriptor.api.jboss51.WebservicesType;
import org.jboss.shrinkwrap.descriptor.api.jboss51.EnterpriseBeansType;
import org.jboss.shrinkwrap.descriptor.api.jboss51.AssemblyDescriptorType;
import org.jboss.shrinkwrap.descriptor.api.jboss51.ResourceManagersType;
import org.jboss.shrinkwrap.descriptor.api.javaee5.IconType;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.descriptor.api.DescriptorNamespace;

/** 
 * <p> 
 * This deployment descriptor provides the functionalities as described in the  specification
 * <p> 
 * Example:
 * <p> 
 * <code> 
 *     JbossDescriptor descriptor = Descriptors.create(JbossDescriptor.class);
 * </code> 
 *
 *
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface JbossDescriptor extends Descriptor, DescriptorNamespace<JbossDescriptor> {

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: xsd:string ElementType : description
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>description</code> elements, 
    * a new <code>description</code> element 
    * @param values list of <code>description</code> objects 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor description(String ... values);

   /**
    * Returns all <code>description</code> elements
    * @return list of <code>description</code> 
    */
   public List<String> getAllDescription();

   /**
    * Removes the <code>description</code> element 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeAllDescription();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: xsd:token ElementType : display-name
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>display-name</code> elements, 
    * a new <code>display-name</code> element 
    * @param values list of <code>display-name</code> objects 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor displayName(String ... values);

   /**
    * Returns all <code>display-name</code> elements
    * @return list of <code>display-name</code> 
    */
   public List<String> getAllDisplayName();

   /**
    * Removes the <code>display-name</code> element 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeAllDisplayName();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: javaee:iconType ElementType : icon
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>icon</code> element will be created and returned.
    * Otherwise, the first existing <code>icon</code> element will be returned.
    * @return the instance defined for the element <code>icon</code> 
    */
   public IconType<JbossDescriptor> getOrCreateIcon();

   /**
    * Creates a new <code>icon</code> element 
    * @return the new created instance of <code>IconType<JbossDescriptor></code> 
    */
   public IconType<JbossDescriptor> createIcon();

   /**
    * Returns all <code>icon</code> elements
    * @return list of <code>icon</code> 
    */
   public List<IconType<JbossDescriptor>> getAllIcon();

   /**
    * Removes all <code>icon</code> elements 
    * @return the current instance of <code>IconType<JbossDescriptor></code> 
    */
   public JbossDescriptor removeAllIcon();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: jboss:loader-repositoryType ElementType : loader-repository
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>loader-repository</code> element with the given value will be created.
    * Otherwise, the existing <code>loader-repository</code> element will be returned.
    * @return  a new or existing instance of <code>LoaderRepositoryType<JbossDescriptor></code> 
    */
   public LoaderRepositoryType<JbossDescriptor> getOrCreateLoaderRepository();

   /**
    * Removes the <code>loader-repository</code> element 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeLoaderRepository();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: xsd:token ElementType : jmx-name
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>jmx-name</code> element
    * @param jmxName the value for the element <code>jmx-name</code> 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor jmxName(String jmxName);

   /**
    * Returns the <code>jmx-name</code> element
    * @return the node defined for the element <code>jmx-name</code> 
    */
   public String getJmxName();

   /**
    * Removes the <code>jmx-name</code> element 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeJmxName();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: xsd:token ElementType : security-domain
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>security-domain</code> element
    * @param securityDomain the value for the element <code>security-domain</code> 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor securityDomain(String securityDomain);

   /**
    * Returns the <code>security-domain</code> element
    * @return the node defined for the element <code>security-domain</code> 
    */
   public String getSecurityDomain();

   /**
    * Removes the <code>security-domain</code> element 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeSecurityDomain();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: javaee:true-falseType ElementType : missing-method-permissions-excluded-mode
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>missing-method-permissions-excluded-mode</code> element
    * @param missingMethodPermissionsExcludedMode the value for the element <code>missing-method-permissions-excluded-mode</code> 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor missingMethodPermissionsExcludedMode(String missingMethodPermissionsExcludedMode);

   /**
    * Returns the <code>missing-method-permissions-excluded-mode</code> element
    * @return the node defined for the element <code>missing-method-permissions-excluded-mode</code> 
    */
   public String getMissingMethodPermissionsExcludedMode();

   /**
    * Removes the <code>missing-method-permissions-excluded-mode</code> element 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeMissingMethodPermissionsExcludedMode();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: javaee:string ElementType : unauthenticated-principal
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>unauthenticated-principal</code> element
    * @param unauthenticatedPrincipal the value for the element <code>unauthenticated-principal</code> 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor unauthenticatedPrincipal(String unauthenticatedPrincipal);

   /**
    * Returns the <code>unauthenticated-principal</code> element
    * @return the node defined for the element <code>unauthenticated-principal</code> 
    */
   public String getUnauthenticatedPrincipal();

   /**
    * Removes the <code>unauthenticated-principal</code> element 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeUnauthenticatedPrincipal();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: xsd:token ElementType : jndi-binding-policy
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>jndi-binding-policy</code> element
    * @param jndiBindingPolicy the value for the element <code>jndi-binding-policy</code> 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor jndiBindingPolicy(String jndiBindingPolicy);

   /**
    * Returns the <code>jndi-binding-policy</code> element
    * @return the node defined for the element <code>jndi-binding-policy</code> 
    */
   public String getJndiBindingPolicy();

   /**
    * Removes the <code>jndi-binding-policy</code> element 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeJndiBindingPolicy();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: javaee:string ElementType : jacc-context-id
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>jacc-context-id</code> element
    * @param jaccContextId the value for the element <code>jacc-context-id</code> 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor jaccContextId(String jaccContextId);

   /**
    * Returns the <code>jacc-context-id</code> element
    * @return the node defined for the element <code>jacc-context-id</code> 
    */
   public String getJaccContextId();

   /**
    * Removes the <code>jacc-context-id</code> element 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeJaccContextId();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: jboss:webservicesType ElementType : webservices
   // MaxOccurs: -1  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>webservices</code> element with the given value will be created.
    * Otherwise, the existing <code>webservices</code> element will be returned.
    * @return  a new or existing instance of <code>WebservicesType<JbossDescriptor></code> 
    */
   public WebservicesType<JbossDescriptor> getOrCreateWebservices();

   /**
    * Removes the <code>webservices</code> element 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeWebservices();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: jboss:enterprise-beansType ElementType : enterprise-beans
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>enterprise-beans</code> element with the given value will be created.
    * Otherwise, the existing <code>enterprise-beans</code> element will be returned.
    * @return  a new or existing instance of <code>EnterpriseBeansType<JbossDescriptor></code> 
    */
   public EnterpriseBeansType<JbossDescriptor> getOrCreateEnterpriseBeans();

   /**
    * Removes the <code>enterprise-beans</code> element 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeEnterpriseBeans();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: jboss:assembly-descriptorType ElementType : assembly-descriptor
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>assembly-descriptor</code> element with the given value will be created.
    * Otherwise, the existing <code>assembly-descriptor</code> element will be returned.
    * @return  a new or existing instance of <code>AssemblyDescriptorType<JbossDescriptor></code> 
    */
   public AssemblyDescriptorType<JbossDescriptor> getOrCreateAssemblyDescriptor();

   /**
    * Removes the <code>assembly-descriptor</code> element 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeAssemblyDescriptor();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: jboss:resource-managersType ElementType : resource-managers
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resource-managers</code> element with the given value will be created.
    * Otherwise, the existing <code>resource-managers</code> element will be returned.
    * @return  a new or existing instance of <code>ResourceManagersType<JbossDescriptor></code> 
    */
   public ResourceManagersType<JbossDescriptor> getOrCreateResourceManagers();

   /**
    * Removes the <code>resource-managers</code> element 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeResourceManagers();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: xsd:token ElementType : version
   // MaxOccurs: -  isGeneric: false   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   public static final String VERSION = "5.1";

   /**
    * Sets the <code>version</code> attribute
    * @param version the value for the attribute <code>version</code> 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor version(String version);

   /**
    * Returns the <code>version</code> attribute
    * @return the value defined for the attribute <code>version</code> 
    */
   public String getVersion();

   /**
    * Removes the <code>version</code> attribute 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeVersion();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: xsd:boolean ElementType : metadata-complete
   // MaxOccurs: -  isGeneric: false   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>metadata-complete</code> attribute
    * @param metadataComplete the value for the attribute <code>metadata-complete</code> 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor metadataComplete(Boolean metadataComplete);

   /**
    * Returns the <code>metadata-complete</code> attribute
    * @return the value defined for the attribute <code>metadata-complete</code> 
    */
public Boolean isMetadataComplete();

   /**
    * Removes the <code>metadata-complete</code> attribute 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeMetadataComplete();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossDescriptor ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: false   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor id(String id);

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
   public String getId();

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>JbossDescriptor</code> 
    */
   public JbossDescriptor removeId();
}
