package org.jboss.shrinkwrap.descriptor.api.jboss51; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jboss51.MethodType;
/**
 * This interface defines the contract for the <code> message-propertiesType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface MessagePropertiesType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessagePropertiesType ElementName: xsd:string ElementType : class
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>class</code> element
    * @param clazz the value for the element <code>class</code> 
    * @return the current instance of <code>MessagePropertiesType<T></code> 
    */
   public MessagePropertiesType<T> clazz(String clazz);

   /**
    * Returns the <code>class</code> element
    * @return the node defined for the element <code>class</code> 
    */
   public String getClazz();

   /**
    * Removes the <code>class</code> element 
    * @return the current instance of <code>MessagePropertiesType<T></code> 
    */
   public MessagePropertiesType<T> removeClazz();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessagePropertiesType ElementName: jboss:methodType ElementType : method
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>method</code> element with the given value will be created.
    * Otherwise, the existing <code>method</code> element will be returned.
    * @return  a new or existing instance of <code>MethodType<MessagePropertiesType<T>></code> 
    */
   public MethodType<MessagePropertiesType<T>> getOrCreateMethod();

   /**
    * Removes the <code>method</code> element 
    * @return the current instance of <code>MessagePropertiesType<T></code> 
    */
   public MessagePropertiesType<T> removeMethod();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessagePropertiesType ElementName: xsd:string ElementType : delivery
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>delivery</code> element
    * @param delivery the value for the element <code>delivery</code> 
    * @return the current instance of <code>MessagePropertiesType<T></code> 
    */
   public MessagePropertiesType<T> delivery(String delivery);

   /**
    * Returns the <code>delivery</code> element
    * @return the node defined for the element <code>delivery</code> 
    */
   public String getDelivery();

   /**
    * Removes the <code>delivery</code> element 
    * @return the current instance of <code>MessagePropertiesType<T></code> 
    */
   public MessagePropertiesType<T> removeDelivery();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessagePropertiesType ElementName: xsd:integer ElementType : priority
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>priority</code> element
    * @param priority the value for the element <code>priority</code> 
    * @return the current instance of <code>MessagePropertiesType<T></code> 
    */
   public MessagePropertiesType<T> priority(Integer priority);

   /**
    * Returns the <code>priority</code> element
    * @return the node defined for the element <code>priority</code> 
    */
   public Integer getPriority();

   /**
    * Removes the <code>priority</code> element 
    * @return the current instance of <code>MessagePropertiesType<T></code> 
    */
   public MessagePropertiesType<T> removePriority();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MessagePropertiesType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>MessagePropertiesType<T></code> 
    */
   public MessagePropertiesType<T> id(String id);

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
   public String getId();

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>MessagePropertiesType<T></code> 
    */
   public MessagePropertiesType<T> removeId();
}
