package org.jboss.shrinkwrap.descriptor.api.jboss51; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
/**
 * This interface defines the contract for the <code> methodType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface MethodType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MethodType ElementName: javaee:string ElementType : method-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>method-name</code> element
    * @param methodName the value for the element <code>method-name</code> 
    * @return the current instance of <code>MethodType<T></code> 
    */
   public MethodType<T> methodName(String methodName);

   /**
    * Returns the <code>method-name</code> element
    * @return the node defined for the element <code>method-name</code> 
    */
   public String getMethodName();

   /**
    * Removes the <code>method-name</code> element 
    * @return the current instance of <code>MethodType<T></code> 
    */
   public MethodType<T> removeMethodName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MethodType ElementName: xsd:boolean ElementType : read-only
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>read-only</code> element
    * @param readOnly the value for the element <code>read-only</code> 
    * @return the current instance of <code>MethodType<T></code> 
    */
   public MethodType<T> readOnly(Boolean readOnly);

   /**
    * Returns the <code>read-only</code> element
    * @return the node defined for the element <code>read-only</code> 
    */
   public Boolean isReadOnly();

   /**
    * Removes the <code>read-only</code> element 
    * @return the current instance of <code>MethodType<T></code> 
    */
   public MethodType<T> removeReadOnly();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MethodType ElementName: xsd:boolean ElementType : idempotent
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>idempotent</code> element
    * @param idempotent the value for the element <code>idempotent</code> 
    * @return the current instance of <code>MethodType<T></code> 
    */
   public MethodType<T> idempotent(Boolean idempotent);

   /**
    * Returns the <code>idempotent</code> element
    * @return the node defined for the element <code>idempotent</code> 
    */
   public Boolean isIdempotent();

   /**
    * Removes the <code>idempotent</code> element 
    * @return the current instance of <code>MethodType<T></code> 
    */
   public MethodType<T> removeIdempotent();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MethodType ElementName: javaee:string ElementType : transaction-timeout
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>transaction-timeout</code> element
    * @param transactionTimeout the value for the element <code>transaction-timeout</code> 
    * @return the current instance of <code>MethodType<T></code> 
    */
   public MethodType<T> transactionTimeout(String transactionTimeout);

   /**
    * Returns the <code>transaction-timeout</code> element
    * @return the node defined for the element <code>transaction-timeout</code> 
    */
   public String getTransactionTimeout();

   /**
    * Removes the <code>transaction-timeout</code> element 
    * @return the current instance of <code>MethodType<T></code> 
    */
   public MethodType<T> removeTransactionTimeout();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MethodType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>MethodType<T></code> 
    */
   public MethodType<T> id(String id);

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
   public String getId();

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>MethodType<T></code> 
    */
   public MethodType<T> removeId();
}
