package org.jboss.shrinkwrap.descriptor.api.jboss51; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
/**
 * This interface defines the contract for the <code> producerType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ProducerType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ProducerType ElementName: xsd:token ElementType : class
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>class</code> element
    * @param clazz the value for the element <code>class</code> 
    * @return the current instance of <code>ProducerType<T></code> 
    */
   public ProducerType<T> clazz(String clazz);

   /**
    * Returns the <code>class</code> element
    * @return the node defined for the element <code>class</code> 
    */
   public String getClazz();

   /**
    * Removes the <code>class</code> element 
    * @return the current instance of <code>ProducerType<T></code> 
    */
   public ProducerType<T> removeClazz();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ProducerType ElementName: xsd:string ElementType : connection-factory
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>connection-factory</code> element
    * @param connectionFactory the value for the element <code>connection-factory</code> 
    * @return the current instance of <code>ProducerType<T></code> 
    */
   public ProducerType<T> connectionFactory(String connectionFactory);

   /**
    * Returns the <code>connection-factory</code> element
    * @return the node defined for the element <code>connection-factory</code> 
    */
   public String getConnectionFactory();

   /**
    * Removes the <code>connection-factory</code> element 
    * @return the current instance of <code>ProducerType<T></code> 
    */
   public ProducerType<T> removeConnectionFactory();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ProducerType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>ProducerType<T></code> 
    */
   public ProducerType<T> id(String id);

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
   public String getId();

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>ProducerType<T></code> 
    */
   public ProducerType<T> removeId();
}
