package org.jboss.shrinkwrap.descriptor.api.jbossdeployment10; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.FilterType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.FilterType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.ServiceDispositionType;
/**
 * This interface defines the contract for the <code> moduleDependencyType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ModuleDependencyType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDependencyType ElementName: jboss:filterType ElementType : exports
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exports</code> element will be created and returned.
    * Otherwise, the first existing <code>exports</code> element will be returned.
    * @return the instance defined for the element <code>exports</code> 
    */
   public FilterType<ModuleDependencyType<T>> getOrCreateExports();

   /**
    * Creates a new <code>exports</code> element 
    * @return the new created instance of <code>FilterType<ModuleDependencyType<T>></code> 
    */
   public FilterType<ModuleDependencyType<T>> createExports();

   /**
    * Returns all <code>exports</code> elements
    * @return list of <code>exports</code> 
    */
   public List<FilterType<ModuleDependencyType<T>>> getAllExports();

   /**
    * Removes all <code>exports</code> elements 
    * @return the current instance of <code>FilterType<ModuleDependencyType<T>></code> 
    */
   public ModuleDependencyType<T> removeAllExports();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDependencyType ElementName: jboss:filterType ElementType : imports
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>imports</code> element will be created and returned.
    * Otherwise, the first existing <code>imports</code> element will be returned.
    * @return the instance defined for the element <code>imports</code> 
    */
   public FilterType<ModuleDependencyType<T>> getOrCreateImports();

   /**
    * Creates a new <code>imports</code> element 
    * @return the new created instance of <code>FilterType<ModuleDependencyType<T>></code> 
    */
   public FilterType<ModuleDependencyType<T>> createImports();

   /**
    * Returns all <code>imports</code> elements
    * @return list of <code>imports</code> 
    */
   public List<FilterType<ModuleDependencyType<T>>> getAllImports();

   /**
    * Removes all <code>imports</code> elements 
    * @return the current instance of <code>FilterType<ModuleDependencyType<T>></code> 
    */
   public ModuleDependencyType<T> removeAllImports();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDependencyType ElementName: xsd:string ElementType : name
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>name</code> attribute
    * @param name the value for the attribute <code>name</code> 
    * @return the current instance of <code>ModuleDependencyType<T></code> 
    */
   public ModuleDependencyType<T> name(String name);

   /**
    * Returns the <code>name</code> attribute
    * @return the value defined for the attribute <code>name</code> 
    */
   public String getName();

   /**
    * Removes the <code>name</code> attribute 
    * @return the current instance of <code>ModuleDependencyType<T></code> 
    */
   public ModuleDependencyType<T> removeName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDependencyType ElementName: xsd:string ElementType : slot
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>slot</code> attribute
    * @param slot the value for the attribute <code>slot</code> 
    * @return the current instance of <code>ModuleDependencyType<T></code> 
    */
   public ModuleDependencyType<T> slot(String slot);

   /**
    * Returns the <code>slot</code> attribute
    * @return the value defined for the attribute <code>slot</code> 
    */
   public String getSlot();

   /**
    * Removes the <code>slot</code> attribute 
    * @return the current instance of <code>ModuleDependencyType<T></code> 
    */
   public ModuleDependencyType<T> removeSlot();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDependencyType ElementName: xsd:boolean ElementType : export
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>export</code> attribute
    * @param export the value for the attribute <code>export</code> 
    * @return the current instance of <code>ModuleDependencyType<T></code> 
    */
   public ModuleDependencyType<T> export(Boolean export);

   /**
    * Returns the <code>export</code> attribute
    * @return the value defined for the attribute <code>export</code> 
    */
public Boolean isExport();

   /**
    * Removes the <code>export</code> attribute 
    * @return the current instance of <code>ModuleDependencyType<T></code> 
    */
   public ModuleDependencyType<T> removeExport();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDependencyType ElementName: jboss:serviceDispositionType ElementType : services
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: true isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>services</code> attribute
    * @param services the value for the attribute <code>services</code> 
    * @return the current instance of <code>ModuleDependencyType<T></code> 
    */
   public ModuleDependencyType<T> services(ServiceDispositionType services);

   /**
    * Sets the <code>services</code> attribute
    * @param services the value for the attribute <code>services</code> 
    * @return the current instance of <code>ModuleDependencyType<T></code> 
    */
   public ModuleDependencyType<T> services(String services);

   /**
    * Returns the <code>services</code> attribute
    * @return the value defined for the attribute <code>services</code> 
    */
public ServiceDispositionType getServices();

   /**
    * Returns the <code>services</code> attribute
    * @return the value found for the element <code>services</code> 
    */
   public String  getServicesAsString();

   /**
    * Removes the <code>services</code> attribute 
    * @return the current instance of <code>ModuleDependencyType<T></code> 
    */
   public ModuleDependencyType<T> removeServices();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDependencyType ElementName: xsd:boolean ElementType : optional
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>optional</code> attribute
    * @param optional the value for the attribute <code>optional</code> 
    * @return the current instance of <code>ModuleDependencyType<T></code> 
    */
   public ModuleDependencyType<T> optional(Boolean optional);

   /**
    * Returns the <code>optional</code> attribute
    * @return the value defined for the attribute <code>optional</code> 
    */
public Boolean isOptional();

   /**
    * Removes the <code>optional</code> attribute 
    * @return the current instance of <code>ModuleDependencyType<T></code> 
    */
   public ModuleDependencyType<T> removeOptional();
}
