package org.jboss.shrinkwrap.descriptor.api.jbossdeployment10; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.ResourceType;
/**
 * This interface defines the contract for the <code> resourcesType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ResourcesType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourcesType ElementName: jboss:resourceType ElementType : resource-root
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resource-root</code> element will be created and returned.
    * Otherwise, the first existing <code>resource-root</code> element will be returned.
    * @return the instance defined for the element <code>resource-root</code> 
    */
   public ResourceType<ResourcesType<T>> getOrCreateResourceRoot();

   /**
    * Creates a new <code>resource-root</code> element 
    * @return the new created instance of <code>ResourceType<ResourcesType<T>></code> 
    */
   public ResourceType<ResourcesType<T>> createResourceRoot();

   /**
    * Returns all <code>resource-root</code> elements
    * @return list of <code>resource-root</code> 
    */
   public List<ResourceType<ResourcesType<T>>> getAllResourceRoot();

   /**
    * Removes all <code>resource-root</code> elements 
    * @return the current instance of <code>ResourceType<ResourcesType<T>></code> 
    */
   public ResourcesType<T> removeAllResourceRoot();
}
