package org.jboss.shrinkwrap.descriptor.api.jbossdeployment10; 

/**
 * This class implements the <code> serviceDispositionType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public enum ServiceDispositionType
{
   _NONE("none"),
   _IMPORT("import"),
   _EXPORT("export");

   private String value;

   ServiceDispositionType (String value) { this.value = value; }

   public String toString() {return value;}

   public static ServiceDispositionType getFromStringValue(String value)
   {
      for(ServiceDispositionType type: ServiceDispositionType.values())
      {
         if(value != null && type.toString().equals(value))
        { return type;}
      }
      return null;
   }

}

