package org.jboss.shrinkwrap.descriptor.api.jbossdeployment10; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.FilterType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.DependenciesType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.ExclusionsType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.ResourcesType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.TransformerSetType;
/**
 * This interface defines the contract for the <code> subDeploymentType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface SubDeploymentType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SubDeploymentType ElementName: jboss:filterType ElementType : exports
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exports</code> element with the given value will be created.
    * Otherwise, the existing <code>exports</code> element will be returned.
    * @return  a new or existing instance of <code>FilterType<SubDeploymentType<T>></code> 
    */
   public FilterType<SubDeploymentType<T>> getOrCreateExports();

   /**
    * Removes the <code>exports</code> element 
    * @return the current instance of <code>SubDeploymentType<T></code> 
    */
   public SubDeploymentType<T> removeExports();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SubDeploymentType ElementName: jboss:dependenciesType ElementType : dependencies
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>dependencies</code> element with the given value will be created.
    * Otherwise, the existing <code>dependencies</code> element will be returned.
    * @return  a new or existing instance of <code>DependenciesType<SubDeploymentType<T>></code> 
    */
   public DependenciesType<SubDeploymentType<T>> getOrCreateDependencies();

   /**
    * Removes the <code>dependencies</code> element 
    * @return the current instance of <code>SubDeploymentType<T></code> 
    */
   public SubDeploymentType<T> removeDependencies();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SubDeploymentType ElementName: jboss:exclusionsType ElementType : exclusions
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exclusions</code> element with the given value will be created.
    * Otherwise, the existing <code>exclusions</code> element will be returned.
    * @return  a new or existing instance of <code>ExclusionsType<SubDeploymentType<T>></code> 
    */
   public ExclusionsType<SubDeploymentType<T>> getOrCreateExclusions();

   /**
    * Removes the <code>exclusions</code> element 
    * @return the current instance of <code>SubDeploymentType<T></code> 
    */
   public SubDeploymentType<T> removeExclusions();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SubDeploymentType ElementName: jboss:resourcesType ElementType : resources
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resources</code> element with the given value will be created.
    * Otherwise, the existing <code>resources</code> element will be returned.
    * @return  a new or existing instance of <code>ResourcesType<SubDeploymentType<T>></code> 
    */
   public ResourcesType<SubDeploymentType<T>> getOrCreateResources();

   /**
    * Removes the <code>resources</code> element 
    * @return the current instance of <code>SubDeploymentType<T></code> 
    */
   public SubDeploymentType<T> removeResources();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SubDeploymentType ElementName: jboss:transformerSetType ElementType : transformers
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>transformers</code> element with the given value will be created.
    * Otherwise, the existing <code>transformers</code> element will be returned.
    * @return  a new or existing instance of <code>TransformerSetType<SubDeploymentType<T>></code> 
    */
   public TransformerSetType<SubDeploymentType<T>> getOrCreateTransformers();

   /**
    * Removes the <code>transformers</code> element 
    * @return the current instance of <code>SubDeploymentType<T></code> 
    */
   public SubDeploymentType<T> removeTransformers();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SubDeploymentType ElementName: xsd:string ElementType : name
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>name</code> attribute
    * @param name the value for the attribute <code>name</code> 
    * @return the current instance of <code>SubDeploymentType<T></code> 
    */
   public SubDeploymentType<T> name(String name);

   /**
    * Returns the <code>name</code> attribute
    * @return the value defined for the attribute <code>name</code> 
    */
   public String getName();

   /**
    * Removes the <code>name</code> attribute 
    * @return the current instance of <code>SubDeploymentType<T></code> 
    */
   public SubDeploymentType<T> removeName();
}
