package org.jboss.shrinkwrap.descriptor.api.jbossdeployment12; 

/**
 * This class implements the <code> metaInfDispositionType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public enum MetaInfDispositionType
{
   _NONE("none"),
   _IMPORT("import"),
   _EXPORT("export");

   private String value;

   MetaInfDispositionType (String value) { this.value = value; }

   public String toString() {return value;}

   public static MetaInfDispositionType getFromStringValue(String value)
   {
      for(MetaInfDispositionType type: MetaInfDispositionType.values())
      {
         if(value != null && type.toString().equals(value))
        { return type;}
      }
      return null;
   }

}

