package org.jboss.shrinkwrap.descriptor.api.jbossdeployment12; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment12.FilterType;
/**
 * This interface defines the contract for the <code> resourceType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ResourceType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourceType ElementName: jboss:filterType ElementType : filter
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>filter</code> element with the given value will be created.
    * Otherwise, the existing <code>filter</code> element will be returned.
    * @return  a new or existing instance of <code>FilterType<ResourceType<T>></code> 
    */
   public FilterType<ResourceType<T>> getOrCreateFilter();

   /**
    * Removes the <code>filter</code> element 
    * @return the current instance of <code>ResourceType<T></code> 
    */
   public ResourceType<T> removeFilter();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourceType ElementName: xsd:string ElementType : name
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>name</code> attribute
    * @param name the value for the attribute <code>name</code> 
    * @return the current instance of <code>ResourceType<T></code> 
    */
   public ResourceType<T> name(String name);

   /**
    * Returns the <code>name</code> attribute
    * @return the value defined for the attribute <code>name</code> 
    */
   public String getName();

   /**
    * Removes the <code>name</code> attribute 
    * @return the current instance of <code>ResourceType<T></code> 
    */
   public ResourceType<T> removeName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourceType ElementName: xsd:string ElementType : path
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>path</code> attribute
    * @param path the value for the attribute <code>path</code> 
    * @return the current instance of <code>ResourceType<T></code> 
    */
   public ResourceType<T> path(String path);

   /**
    * Returns the <code>path</code> attribute
    * @return the value defined for the attribute <code>path</code> 
    */
   public String getPath();

   /**
    * Removes the <code>path</code> attribute 
    * @return the current instance of <code>ResourceType<T></code> 
    */
   public ResourceType<T> removePath();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourceType ElementName: xsd:boolean ElementType : use-physical-code-source
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>use-physical-code-source</code> attribute
    * @param usePhysicalCodeSource the value for the attribute <code>use-physical-code-source</code> 
    * @return the current instance of <code>ResourceType<T></code> 
    */
   public ResourceType<T> usePhysicalCodeSource(Boolean usePhysicalCodeSource);

   /**
    * Returns the <code>use-physical-code-source</code> attribute
    * @return the value defined for the attribute <code>use-physical-code-source</code> 
    */
public Boolean isUsePhysicalCodeSource();

   /**
    * Removes the <code>use-physical-code-source</code> attribute 
    * @return the current instance of <code>ResourceType<T></code> 
    */
   public ResourceType<T> removeUsePhysicalCodeSource();
}
