package org.jboss.shrinkwrap.descriptor.api.jbossdeployment13; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.SubsystemType;
/**
 * This interface defines the contract for the <code> exclude-subsystemsType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ExcludeSubsystemsType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ExcludeSubsystemsType ElementName: jboss:subsystemType ElementType : subsystem
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>subsystem</code> element will be created and returned.
    * Otherwise, the first existing <code>subsystem</code> element will be returned.
    * @return the instance defined for the element <code>subsystem</code> 
    */
   public SubsystemType<ExcludeSubsystemsType<T>> getOrCreateSubsystem();

   /**
    * Creates a new <code>subsystem</code> element 
    * @return the new created instance of <code>SubsystemType<ExcludeSubsystemsType<T>></code> 
    */
   public SubsystemType<ExcludeSubsystemsType<T>> createSubsystem();

   /**
    * Returns all <code>subsystem</code> elements
    * @return list of <code>subsystem</code> 
    */
   public List<SubsystemType<ExcludeSubsystemsType<T>>> getAllSubsystem();

   /**
    * Removes all <code>subsystem</code> elements 
    * @return the current instance of <code>SubsystemType<ExcludeSubsystemsType<T>></code> 
    */
   public ExcludeSubsystemsType<T> removeAllSubsystem();
}
