package org.jboss.shrinkwrap.descriptor.api.jbossmodule13; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.descriptor.api.DescriptorNamespace;

/** 
 * <p> 
 * This deployment descriptor provides the functionalities as described in the  specification
 * <p> 
 * Example:
 * <p> 
 * <code> 
 *     ModuleAbsentDescriptor descriptor = Descriptors.create(ModuleAbsentDescriptor.class);
 * </code> 
 *
 *
 * @author <a href="mailto:tcrawley@redhat.com">Toby Crawley</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ModuleAbsentDescriptor extends Descriptor, DescriptorNamespace<ModuleAbsentDescriptor> {

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleAbsentDescriptor ElementName: xsd:string ElementType : name
   // MaxOccurs: -  isGeneric: false   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>name</code> attribute
    * @param name the value for the attribute <code>name</code> 
    * @return the current instance of <code>ModuleAbsentDescriptor</code> 
    */
   public ModuleAbsentDescriptor name(String name);

   /**
    * Returns the <code>name</code> attribute
    * @return the value defined for the attribute <code>name</code> 
    */
   public String getName();

   /**
    * Removes the <code>name</code> attribute 
    * @return the current instance of <code>ModuleAbsentDescriptor</code> 
    */
   public ModuleAbsentDescriptor removeName();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleAbsentDescriptor ElementName: xsd:string ElementType : slot
   // MaxOccurs: -  isGeneric: false   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>slot</code> attribute
    * @param slot the value for the attribute <code>slot</code> 
    * @return the current instance of <code>ModuleAbsentDescriptor</code> 
    */
   public ModuleAbsentDescriptor slot(String slot);

   /**
    * Returns the <code>slot</code> attribute
    * @return the value defined for the attribute <code>slot</code> 
    */
   public String getSlot();

   /**
    * Removes the <code>slot</code> attribute 
    * @return the current instance of <code>ModuleAbsentDescriptor</code> 
    */
   public ModuleAbsentDescriptor removeSlot();
}
