package org.jboss.shrinkwrap.descriptor.api.jbossmodule13; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
/**
 * This interface defines the contract for the <code> permissionType </code> xsd type 
 * @author <a href="mailto:tcrawley@redhat.com">Toby Crawley</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface PermissionType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PermissionType ElementName: xsd:string ElementType : permission
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>permission</code> attribute
    * @param permission the value for the attribute <code>permission</code> 
    * @return the current instance of <code>PermissionType<T></code> 
    */
   public PermissionType<T> permission(String permission);

   /**
    * Returns the <code>permission</code> attribute
    * @return the value defined for the attribute <code>permission</code> 
    */
   public String getPermission();

   /**
    * Removes the <code>permission</code> attribute 
    * @return the current instance of <code>PermissionType<T></code> 
    */
   public PermissionType<T> removePermission();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PermissionType ElementName: xsd:string ElementType : name
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>name</code> attribute
    * @param name the value for the attribute <code>name</code> 
    * @return the current instance of <code>PermissionType<T></code> 
    */
   public PermissionType<T> name(String name);

   /**
    * Returns the <code>name</code> attribute
    * @return the value defined for the attribute <code>name</code> 
    */
   public String getName();

   /**
    * Removes the <code>name</code> attribute 
    * @return the current instance of <code>PermissionType<T></code> 
    */
   public PermissionType<T> removeName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PermissionType ElementName: xsd:string ElementType : actions
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>actions</code> attribute
    * @param actions the value for the attribute <code>actions</code> 
    * @return the current instance of <code>PermissionType<T></code> 
    */
   public PermissionType<T> actions(String actions);

   /**
    * Returns the <code>actions</code> attribute
    * @return the value defined for the attribute <code>actions</code> 
    */
   public String getActions();

   /**
    * Removes the <code>actions</code> attribute 
    * @return the current instance of <code>PermissionType<T></code> 
    */
   public PermissionType<T> removeActions();
}
