package org.jboss.shrinkwrap.descriptor.api.jbossmodule13; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.PropertyType;
/**
 * This interface defines the contract for the <code> propertyListType </code> xsd type 
 * @author <a href="mailto:tcrawley@redhat.com">Toby Crawley</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface PropertyListType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PropertyListType ElementName: jboss:propertyType ElementType : property
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>property</code> element will be created and returned.
    * Otherwise, the first existing <code>property</code> element will be returned.
    * @return the instance defined for the element <code>property</code> 
    */
   public PropertyType<PropertyListType<T>> getOrCreateProperty();

   /**
    * Creates a new <code>property</code> element 
    * @return the new created instance of <code>PropertyType<PropertyListType<T>></code> 
    */
   public PropertyType<PropertyListType<T>> createProperty();

   /**
    * Returns all <code>property</code> elements
    * @return list of <code>property</code> 
    */
   public List<PropertyType<PropertyListType<T>>> getAllProperty();

   /**
    * Removes all <code>property</code> elements 
    * @return the current instance of <code>PropertyType<PropertyListType<T>></code> 
    */
   public PropertyListType<T> removeAllProperty();
}
