package org.jboss.shrinkwrap.descriptor.api.jbossmodule15; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
/**
 * This interface defines the contract for the <code> moduleAliasType </code> xsd type 
 * @author <a href="mailto:tcrawley@redhat.com">Toby Crawley</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ModuleAliasType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleAliasType ElementName: xsd:string ElementType : name
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>name</code> attribute
    * @param name the value for the attribute <code>name</code> 
    * @return the current instance of <code>ModuleAliasType<T></code> 
    */
   public ModuleAliasType<T> name(String name);

   /**
    * Returns the <code>name</code> attribute
    * @return the value defined for the attribute <code>name</code> 
    */
   public String getName();

   /**
    * Removes the <code>name</code> attribute 
    * @return the current instance of <code>ModuleAliasType<T></code> 
    */
   public ModuleAliasType<T> removeName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleAliasType ElementName: xsd:string ElementType : slot
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>slot</code> attribute
    * @param slot the value for the attribute <code>slot</code> 
    * @return the current instance of <code>ModuleAliasType<T></code> 
    */
   public ModuleAliasType<T> slot(String slot);

   /**
    * Returns the <code>slot</code> attribute
    * @return the value defined for the attribute <code>slot</code> 
    */
   public String getSlot();

   /**
    * Removes the <code>slot</code> attribute 
    * @return the current instance of <code>ModuleAliasType<T></code> 
    */
   public ModuleAliasType<T> removeSlot();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleAliasType ElementName: xsd:string ElementType : target-name
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>target-name</code> attribute
    * @param targetName the value for the attribute <code>target-name</code> 
    * @return the current instance of <code>ModuleAliasType<T></code> 
    */
   public ModuleAliasType<T> targetName(String targetName);

   /**
    * Returns the <code>target-name</code> attribute
    * @return the value defined for the attribute <code>target-name</code> 
    */
   public String getTargetName();

   /**
    * Removes the <code>target-name</code> attribute 
    * @return the current instance of <code>ModuleAliasType<T></code> 
    */
   public ModuleAliasType<T> removeTargetName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleAliasType ElementName: xsd:string ElementType : target-slot
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>target-slot</code> attribute
    * @param targetSlot the value for the attribute <code>target-slot</code> 
    * @return the current instance of <code>ModuleAliasType<T></code> 
    */
   public ModuleAliasType<T> targetSlot(String targetSlot);

   /**
    * Returns the <code>target-slot</code> attribute
    * @return the value defined for the attribute <code>target-slot</code> 
    */
   public String getTargetSlot();

   /**
    * Removes the <code>target-slot</code> attribute 
    * @return the current instance of <code>ModuleAliasType<T></code> 
    */
   public ModuleAliasType<T> removeTargetSlot();
}
