package org.jboss.shrinkwrap.descriptor.api.jbossweb60; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.LoaderRepositoryType;
/**
 * This interface defines the contract for the <code> class-loadingType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ClassLoadingType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ClassLoadingType ElementName: jboss:loader-repositoryType ElementType : loader-repository
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>loader-repository</code> element with the given value will be created.
    * Otherwise, the existing <code>loader-repository</code> element will be returned.
    * @return  a new or existing instance of <code>LoaderRepositoryType<ClassLoadingType<T>></code> 
    */
   public LoaderRepositoryType<ClassLoadingType<T>> getOrCreateLoaderRepository();

   /**
    * Removes the <code>loader-repository</code> element 
    * @return the current instance of <code>ClassLoadingType<T></code> 
    */
   public ClassLoadingType<T> removeLoaderRepository();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ClassLoadingType ElementName: xsd:boolean ElementType : java2ClassLoadingCompliance
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>java2ClassLoadingCompliance</code> attribute
    * @param java2ClassLoadingCompliance the value for the attribute <code>java2ClassLoadingCompliance</code> 
    * @return the current instance of <code>ClassLoadingType<T></code> 
    */
   public ClassLoadingType<T> javaClassLoadingCompliance(Boolean java2ClassLoadingCompliance);

   /**
    * Returns the <code>java2ClassLoadingCompliance</code> attribute
    * @return the value defined for the attribute <code>java2ClassLoadingCompliance</code> 
    */
public Boolean isJavaClassLoadingCompliance();

   /**
    * Removes the <code>java2ClassLoadingCompliance</code> attribute 
    * @return the current instance of <code>ClassLoadingType<T></code> 
    */
   public ClassLoadingType<T> removeJavaClassLoadingCompliance();
}
