package org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
/**
 * This interface defines the contract for the <code> artifact-type </code> xsd type 
 * @author <a href="mailto:bmcwhirt@redhat.com">Bob McWhirter</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ArtifactType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ArtifactType ElementName: xsd:string ElementType : groupId
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>groupId</code> attribute
    * @param groupId the value for the attribute <code>groupId</code> 
    * @return the current instance of <code>ArtifactType<T></code> 
    */
   public ArtifactType<T> groupId(String groupId);

   /**
    * Returns the <code>groupId</code> attribute
    * @return the value defined for the attribute <code>groupId</code> 
    */
   public String getGroupId();

   /**
    * Removes the <code>groupId</code> attribute 
    * @return the current instance of <code>ArtifactType<T></code> 
    */
   public ArtifactType<T> removeGroupId();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ArtifactType ElementName: xsd:string ElementType : artifactId
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>artifactId</code> attribute
    * @param artifactId the value for the attribute <code>artifactId</code> 
    * @return the current instance of <code>ArtifactType<T></code> 
    */
   public ArtifactType<T> artifactId(String artifactId);

   /**
    * Returns the <code>artifactId</code> attribute
    * @return the value defined for the attribute <code>artifactId</code> 
    */
   public String getArtifactId();

   /**
    * Removes the <code>artifactId</code> attribute 
    * @return the current instance of <code>ArtifactType<T></code> 
    */
   public ArtifactType<T> removeArtifactId();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ArtifactType ElementName: xsd:string ElementType : classifier
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>classifier</code> attribute
    * @param classifier the value for the attribute <code>classifier</code> 
    * @return the current instance of <code>ArtifactType<T></code> 
    */
   public ArtifactType<T> classifier(String classifier);

   /**
    * Returns the <code>classifier</code> attribute
    * @return the value defined for the attribute <code>classifier</code> 
    */
   public String getClassifier();

   /**
    * Removes the <code>classifier</code> attribute 
    * @return the current instance of <code>ArtifactType<T></code> 
    */
   public ArtifactType<T> removeClassifier();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ArtifactType ElementName: xsd:string ElementType : extension
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>extension</code> attribute
    * @param extension the value for the attribute <code>extension</code> 
    * @return the current instance of <code>ArtifactType<T></code> 
    */
   public ArtifactType<T> extension(String extension);

   /**
    * Returns the <code>extension</code> attribute
    * @return the value defined for the attribute <code>extension</code> 
    */
   public String getExtension();

   /**
    * Removes the <code>extension</code> attribute 
    * @return the current instance of <code>ArtifactType<T></code> 
    */
   public ArtifactType<T> removeExtension();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ArtifactType ElementName: xsd:string ElementType : version
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>version</code> attribute
    * @param version the value for the attribute <code>version</code> 
    * @return the current instance of <code>ArtifactType<T></code> 
    */
   public ArtifactType<T> version(String version);

   /**
    * Returns the <code>version</code> attribute
    * @return the value defined for the attribute <code>version</code> 
    */
   public String getVersion();

   /**
    * Removes the <code>version</code> attribute 
    * @return the current instance of <code>ArtifactType<T></code> 
    */
   public ArtifactType<T> removeVersion();
}
