package org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.ArtifactType;
/**
 * This interface defines the contract for the <code> artifact-versions-type </code> xsd type 
 * @author <a href="mailto:bmcwhirt@redhat.com">Bob McWhirter</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ArtifactVersionsType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ArtifactVersionsType ElementName: wildfly:artifact-type ElementType : artifact
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>artifact</code> element will be created and returned.
    * Otherwise, the first existing <code>artifact</code> element will be returned.
    * @return the instance defined for the element <code>artifact</code> 
    */
   public ArtifactType<ArtifactVersionsType<T>> getOrCreateArtifact();

   /**
    * Creates a new <code>artifact</code> element 
    * @return the new created instance of <code>ArtifactType<ArtifactVersionsType<T>></code> 
    */
   public ArtifactType<ArtifactVersionsType<T>> createArtifact();

   /**
    * Returns all <code>artifact</code> elements
    * @return list of <code>artifact</code> 
    */
   public List<ArtifactType<ArtifactVersionsType<T>>> getAllArtifact();

   /**
    * Removes all <code>artifact</code> elements 
    * @return the current instance of <code>ArtifactType<ArtifactVersionsType<T>></code> 
    */
   public ArtifactVersionsType<T> removeAllArtifact();
}
