package org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
/**
 * This interface defines the contract for the <code> property-type </code> xsd type 
 * @author <a href="mailto:bmcwhirt@redhat.com">Bob McWhirter</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface PropertyType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PropertyType ElementName: xsd:string ElementType : name
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>name</code> attribute
    * @param name the value for the attribute <code>name</code> 
    * @return the current instance of <code>PropertyType<T></code> 
    */
   public PropertyType<T> name(String name);

   /**
    * Returns the <code>name</code> attribute
    * @return the value defined for the attribute <code>name</code> 
    */
   public String getName();

   /**
    * Removes the <code>name</code> attribute 
    * @return the current instance of <code>PropertyType<T></code> 
    */
   public PropertyType<T> removeName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PropertyType ElementName: xsd:string ElementType : value
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>value</code> attribute
    * @param value the value for the attribute <code>value</code> 
    * @return the current instance of <code>PropertyType<T></code> 
    */
   public PropertyType<T> value(String value);

   /**
    * Returns the <code>value</code> attribute
    * @return the value defined for the attribute <code>value</code> 
    */
   public String getValue();

   /**
    * Removes the <code>value</code> attribute 
    * @return the current instance of <code>PropertyType<T></code> 
    */
   public PropertyType<T> removeValue();
}
