package org.jboss.shrinkwrap.descriptor.impl.jboss51; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jboss51.AnnotationPropertyType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;

/**
 * This class implements the <code> annotation-propertyType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class AnnotationPropertyTypeImpl<T> implements Child<T>, AnnotationPropertyType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public AnnotationPropertyTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public AnnotationPropertyTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationPropertyType ElementName: xsd:string ElementType : description
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>description</code> elements, 
    * a new <code>description</code> element 
    * @param values list of <code>description</code> objects 
    * @return the current instance of <code>AnnotationPropertyType<T></code> 
    */
   public AnnotationPropertyType<T> description(String ... values)
   {
      if (values != null)
      {
         for(String name: values)
         {
            childNode.createChild("description").text(name);
         }
      }
      return this;
   }

   /**
    * Returns all <code>description</code> elements
    * @return list of <code>description</code> 
    */
public List<String> getAllDescription()
   {
      List<String> result = new ArrayList<String>();
      List<Node> nodes = childNode.get("description");
      for (Node node : nodes)
      {
         result.add(node.getText());
      }
      return result;
   }

   /**
    * Removes the <code>description</code> element 
    * @return the current instance of <code>AnnotationPropertyType<T></code> 
    */
   public AnnotationPropertyType<T> removeAllDescription()
   {
      childNode.removeChildren("description");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationPropertyType ElementName: xsd:token ElementType : property-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>property-name</code> element
    * @param propertyName the value for the element <code>property-name</code> 
    * @return the current instance of <code>AnnotationPropertyType<T></code> 
    */
   public AnnotationPropertyType<T> propertyName(String propertyName)
   {
      childNode.getOrCreate("property-name").text(propertyName);
      return this;
   }

   /**
    * Returns the <code>property-name</code> element
    * @return the node defined for the element <code>property-name</code> 
    */
   public String getPropertyName()
   {
      return childNode.getTextValueForPatternName("property-name");
   }

   /**
    * Removes the <code>property-name</code> element 
    * @return the current instance of <code>AnnotationPropertyType<T></code> 
    */
   public AnnotationPropertyType<T> removePropertyName()
   {
      childNode.removeChildren("property-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationPropertyType ElementName: xsd:token ElementType : property-value
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>property-value</code> element
    * @param propertyValue the value for the element <code>property-value</code> 
    * @return the current instance of <code>AnnotationPropertyType<T></code> 
    */
   public AnnotationPropertyType<T> propertyValue(String propertyValue)
   {
      childNode.getOrCreate("property-value").text(propertyValue);
      return this;
   }

   /**
    * Returns the <code>property-value</code> element
    * @return the node defined for the element <code>property-value</code> 
    */
   public String getPropertyValue()
   {
      return childNode.getTextValueForPatternName("property-value");
   }

   /**
    * Removes the <code>property-value</code> element 
    * @return the current instance of <code>AnnotationPropertyType<T></code> 
    */
   public AnnotationPropertyType<T> removePropertyValue()
   {
      childNode.removeChildren("property-value");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationPropertyType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>AnnotationPropertyType<T></code> 
    */
   public AnnotationPropertyType<T> id(String id)
   {
      childNode.attribute("id", id);
      return this;
   }

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
      public String getId()
   {
      return childNode.getAttribute("id");
   }

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>AnnotationPropertyType<T></code> 
    */
   public AnnotationPropertyType<T> removeId()
   {
      childNode.removeAttribute("id");
      return this;
   }
}
