package org.jboss.shrinkwrap.descriptor.impl.jboss51; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jboss51.CacheConfigType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;

/**
 * This class implements the <code> cache-configType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class CacheConfigTypeImpl<T> implements Child<T>, CacheConfigType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public CacheConfigTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public CacheConfigTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CacheConfigType ElementName: javaee:string ElementType : cache-value
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>cache-value</code> element
    * @param cacheValue the value for the element <code>cache-value</code> 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> cacheValue(String cacheValue)
   {
      childNode.getOrCreate("cache-value").text(cacheValue);
      return this;
   }

   /**
    * Returns the <code>cache-value</code> element
    * @return the node defined for the element <code>cache-value</code> 
    */
   public String getCacheValue()
   {
      return childNode.getTextValueForPatternName("cache-value");
   }

   /**
    * Removes the <code>cache-value</code> element 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> removeCacheValue()
   {
      childNode.removeChildren("cache-value");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CacheConfigType ElementName: javaee:xsdIntegerType ElementType : cache-max-size
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>cache-max-size</code> element
    * @param cacheMaxSize the value for the element <code>cache-max-size</code> 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> cacheMaxSize(Integer cacheMaxSize)
   {
      childNode.getOrCreate("cache-max-size").text(cacheMaxSize);
      return this;
   }

   /**
    * Returns the <code>cache-max-size</code> element
    * @return the node defined for the element <code>cache-max-size</code> 
    */
   public Integer getCacheMaxSize()
   {
      if (childNode.getTextValueForPatternName("cache-max-size") != null && !childNode.getTextValueForPatternName("cache-max-size").equals("null")) {
         return Integer.valueOf(childNode.getTextValueForPatternName("cache-max-size"));
      }
      return null;
   }

   /**
    * Removes the <code>cache-max-size</code> element 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> removeCacheMaxSize()
   {
      childNode.removeChildren("cache-max-size");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CacheConfigType ElementName: javaee:xsdIntegerType ElementType : idle-timeout-seconds
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>idle-timeout-seconds</code> element
    * @param idleTimeoutSeconds the value for the element <code>idle-timeout-seconds</code> 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> idleTimeoutSeconds(Integer idleTimeoutSeconds)
   {
      childNode.getOrCreate("idle-timeout-seconds").text(idleTimeoutSeconds);
      return this;
   }

   /**
    * Returns the <code>idle-timeout-seconds</code> element
    * @return the node defined for the element <code>idle-timeout-seconds</code> 
    */
   public Integer getIdleTimeoutSeconds()
   {
      if (childNode.getTextValueForPatternName("idle-timeout-seconds") != null && !childNode.getTextValueForPatternName("idle-timeout-seconds").equals("null")) {
         return Integer.valueOf(childNode.getTextValueForPatternName("idle-timeout-seconds"));
      }
      return null;
   }

   /**
    * Removes the <code>idle-timeout-seconds</code> element 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> removeIdleTimeoutSeconds()
   {
      childNode.removeChildren("idle-timeout-seconds");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CacheConfigType ElementName: javaee:xsdIntegerType ElementType : remove-timeout-seconds
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>remove-timeout-seconds</code> element
    * @param removeTimeoutSeconds the value for the element <code>remove-timeout-seconds</code> 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> removeTimeoutSeconds(Integer removeTimeoutSeconds)
   {
      childNode.getOrCreate("remove-timeout-seconds").text(removeTimeoutSeconds);
      return this;
   }

   /**
    * Returns the <code>remove-timeout-seconds</code> element
    * @return the node defined for the element <code>remove-timeout-seconds</code> 
    */
   public Integer getRemoveTimeoutSeconds()
   {
      if (childNode.getTextValueForPatternName("remove-timeout-seconds") != null && !childNode.getTextValueForPatternName("remove-timeout-seconds").equals("null")) {
         return Integer.valueOf(childNode.getTextValueForPatternName("remove-timeout-seconds"));
      }
      return null;
   }

   /**
    * Removes the <code>remove-timeout-seconds</code> element 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> removeRemoveTimeoutSeconds()
   {
      childNode.removeChildren("remove-timeout-seconds");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CacheConfigType ElementName: javaee:string ElementType : cache-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>cache-name</code> element
    * @param cacheName the value for the element <code>cache-name</code> 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> cacheName(String cacheName)
   {
      childNode.getOrCreate("cache-name").text(cacheName);
      return this;
   }

   /**
    * Returns the <code>cache-name</code> element
    * @return the node defined for the element <code>cache-name</code> 
    */
   public String getCacheName()
   {
      return childNode.getTextValueForPatternName("cache-name");
   }

   /**
    * Removes the <code>cache-name</code> element 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> removeCacheName()
   {
      childNode.removeChildren("cache-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CacheConfigType ElementName: javaee:string ElementType : persistence-manager
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>persistence-manager</code> element
    * @param persistenceManager the value for the element <code>persistence-manager</code> 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> persistenceManager(String persistenceManager)
   {
      childNode.getOrCreate("persistence-manager").text(persistenceManager);
      return this;
   }

   /**
    * Returns the <code>persistence-manager</code> element
    * @return the node defined for the element <code>persistence-manager</code> 
    */
   public String getPersistenceManager()
   {
      return childNode.getTextValueForPatternName("persistence-manager");
   }

   /**
    * Removes the <code>persistence-manager</code> element 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> removePersistenceManager()
   {
      childNode.removeChildren("persistence-manager");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CacheConfigType ElementName: javaee:string ElementType : replication-is-passivation
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>replication-is-passivation</code> element
    * @param replicationIsPassivation the value for the element <code>replication-is-passivation</code> 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> replicationIsPassivation(String replicationIsPassivation)
   {
      childNode.getOrCreate("replication-is-passivation").text(replicationIsPassivation);
      return this;
   }

   /**
    * Returns the <code>replication-is-passivation</code> element
    * @return the node defined for the element <code>replication-is-passivation</code> 
    */
   public String getReplicationIsPassivation()
   {
      return childNode.getTextValueForPatternName("replication-is-passivation");
   }

   /**
    * Removes the <code>replication-is-passivation</code> element 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> removeReplicationIsPassivation()
   {
      childNode.removeChildren("replication-is-passivation");
      return this;
   }
}
