package org.jboss.shrinkwrap.descriptor.impl.jboss51; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jboss51.ConsumerBeanType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jboss51.ProducerType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.ProducerTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.ProducerType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.ProducerTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.MethodAttributesType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.MethodAttributesTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.MessagePropertiesType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.MessagePropertiesTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.EjbRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.EjbRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.EjbLocalRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.EjbLocalRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.SecurityIdentityType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.SecurityIdentityTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.ResourceRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.ResourceRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.ResourceEnvRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.ResourceEnvRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.MessageDestinationRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.MessageDestinationRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.MethodAttributesType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.MethodAttributesTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.AnnotationType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.AnnotationTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.IgnoreDependencyType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.IgnoreDependencyTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.PoolConfigType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.PoolConfigTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.JndiRefType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.JndiRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.ActivationConfigType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.ActivationConfigTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.javaee5.IconType;
import org.jboss.shrinkwrap.descriptor.impl.javaee5.IconTypeImpl;

/**
 * This class implements the <code> consumer-beanType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class ConsumerBeanTypeImpl<T> implements Child<T>, ConsumerBeanType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public ConsumerBeanTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public ConsumerBeanTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: xsd:string ElementType : description
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>description</code> elements, 
    * a new <code>description</code> element 
    * @param values list of <code>description</code> objects 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> description(String ... values)
   {
      if (values != null)
      {
         for(String name: values)
         {
            childNode.createChild("description").text(name);
         }
      }
      return this;
   }

   /**
    * Returns all <code>description</code> elements
    * @return list of <code>description</code> 
    */
public List<String> getAllDescription()
   {
      List<String> result = new ArrayList<String>();
      List<Node> nodes = childNode.get("description");
      for (Node node : nodes)
      {
         result.add(node.getText());
      }
      return result;
   }

   /**
    * Removes the <code>description</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeAllDescription()
   {
      childNode.removeChildren("description");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: xsd:token ElementType : display-name
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>display-name</code> elements, 
    * a new <code>display-name</code> element 
    * @param values list of <code>display-name</code> objects 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> displayName(String ... values)
   {
      if (values != null)
      {
         for(String name: values)
         {
            childNode.createChild("display-name").text(name);
         }
      }
      return this;
   }

   /**
    * Returns all <code>display-name</code> elements
    * @return list of <code>display-name</code> 
    */
public List<String> getAllDisplayName()
   {
      List<String> result = new ArrayList<String>();
      List<Node> nodes = childNode.get("display-name");
      for (Node node : nodes)
      {
         result.add(node.getText());
      }
      return result;
   }

   /**
    * Removes the <code>display-name</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeAllDisplayName()
   {
      childNode.removeChildren("display-name");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: javaee:iconType ElementType : icon
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>icon</code> element will be created and returned.
    * Otherwise, the first existing <code>icon</code> element will be returned.
    * @return the instance defined for the element <code>icon</code> 
    */
   public IconType<ConsumerBeanType<T>> getOrCreateIcon()
   {
      List<Node> nodeList = childNode.get("icon");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new IconTypeImpl<ConsumerBeanType<T>>(this, "icon", childNode, nodeList.get(0));
      }
      return createIcon();
   }

   /**
    * Creates a new <code>icon</code> element 
    * @return the new created instance of <code>IconType<ConsumerBeanType<T>></code> 
    */
   public IconType<ConsumerBeanType<T>> createIcon()
   {
      return new IconTypeImpl<ConsumerBeanType<T>>(this, "icon", childNode);
   }

   /**
    * Returns all <code>icon</code> elements
    * @return list of <code>icon</code> 
    */
   public List<IconType<ConsumerBeanType<T>>> getAllIcon()
   {
      List<IconType<ConsumerBeanType<T>>> list = new ArrayList<IconType<ConsumerBeanType<T>>>();
      List<Node> nodeList = childNode.get("icon");
      for(Node node: nodeList)
      {
         IconType<ConsumerBeanType<T>>  type = new IconTypeImpl<ConsumerBeanType<T>>(this, "icon", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>icon</code> elements 
    * @return the current instance of <code>IconType<ConsumerBeanType<T>></code> 
    */
   public ConsumerBeanType<T> removeAllIcon()
   {
      childNode.removeChildren("icon");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: javaee:xsdNMTOKENType ElementType : ejb-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>ejb-name</code> element
    * @param ejbName the value for the element <code>ejb-name</code> 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> ejbName(String ejbName)
   {
      childNode.getOrCreate("ejb-name").text(ejbName);
      return this;
   }

   /**
    * Returns the <code>ejb-name</code> element
    * @return the node defined for the element <code>ejb-name</code> 
    */
   public String getEjbName()
   {
      return childNode.getTextValueForPatternName("ejb-name");
   }

   /**
    * Removes the <code>ejb-name</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeEjbName()
   {
      childNode.removeChildren("ejb-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: javaee:fully-qualified-classType ElementType : ejb-class
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>ejb-class</code> element
    * @param ejbClass the value for the element <code>ejb-class</code> 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> ejbClass(String ejbClass)
   {
      childNode.getOrCreate("ejb-class").text(ejbClass);
      return this;
   }

   /**
    * Returns the <code>ejb-class</code> element
    * @return the node defined for the element <code>ejb-class</code> 
    */
   public String getEjbClass()
   {
      return childNode.getTextValueForPatternName("ejb-class");
   }

   /**
    * Removes the <code>ejb-class</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeEjbClass()
   {
      childNode.removeChildren("ejb-class");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: javaee:string ElementType : message-destination
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>message-destination</code> element
    * @param messageDestination the value for the element <code>message-destination</code> 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> messageDestination(String messageDestination)
   {
      childNode.getOrCreate("message-destination").text(messageDestination);
      return this;
   }

   /**
    * Returns the <code>message-destination</code> element
    * @return the node defined for the element <code>message-destination</code> 
    */
   public String getMessageDestination()
   {
      return childNode.getTextValueForPatternName("message-destination");
   }

   /**
    * Removes the <code>message-destination</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeMessageDestination()
   {
      childNode.removeChildren("message-destination");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: javaee:fully-qualified-classType ElementType : message-destination-type
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>message-destination-type</code> element
    * @param messageDestinationType the value for the element <code>message-destination-type</code> 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> messageDestinationType(String messageDestinationType)
   {
      childNode.getOrCreate("message-destination-type").text(messageDestinationType);
      return this;
   }

   /**
    * Returns the <code>message-destination-type</code> element
    * @return the node defined for the element <code>message-destination-type</code> 
    */
   public String getMessageDestinationType()
   {
      return childNode.getTextValueForPatternName("message-destination-type");
   }

   /**
    * Removes the <code>message-destination-type</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeMessageDestinationType()
   {
      childNode.removeChildren("message-destination-type");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:producerType ElementType : producer
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>producer</code> element will be created and returned.
    * Otherwise, the first existing <code>producer</code> element will be returned.
    * @return the instance defined for the element <code>producer</code> 
    */
   public ProducerType<ConsumerBeanType<T>> getOrCreateProducer()
   {
      List<Node> nodeList = childNode.get("producer");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ProducerTypeImpl<ConsumerBeanType<T>>(this, "producer", childNode, nodeList.get(0));
      }
      return createProducer();
   }

   /**
    * Creates a new <code>producer</code> element 
    * @return the new created instance of <code>ProducerType<ConsumerBeanType<T>></code> 
    */
   public ProducerType<ConsumerBeanType<T>> createProducer()
   {
      return new ProducerTypeImpl<ConsumerBeanType<T>>(this, "producer", childNode);
   }

   /**
    * Returns all <code>producer</code> elements
    * @return list of <code>producer</code> 
    */
   public List<ProducerType<ConsumerBeanType<T>>> getAllProducer()
   {
      List<ProducerType<ConsumerBeanType<T>>> list = new ArrayList<ProducerType<ConsumerBeanType<T>>>();
      List<Node> nodeList = childNode.get("producer");
      for(Node node: nodeList)
      {
         ProducerType<ConsumerBeanType<T>>  type = new ProducerTypeImpl<ConsumerBeanType<T>>(this, "producer", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>producer</code> elements 
    * @return the current instance of <code>ProducerType<ConsumerBeanType<T>></code> 
    */
   public ConsumerBeanType<T> removeAllProducer()
   {
      childNode.removeChildren("producer");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:producerType ElementType : local-producer
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>local-producer</code> element will be created and returned.
    * Otherwise, the first existing <code>local-producer</code> element will be returned.
    * @return the instance defined for the element <code>local-producer</code> 
    */
   public ProducerType<ConsumerBeanType<T>> getOrCreateLocalProducer()
   {
      List<Node> nodeList = childNode.get("local-producer");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ProducerTypeImpl<ConsumerBeanType<T>>(this, "local-producer", childNode, nodeList.get(0));
      }
      return createLocalProducer();
   }

   /**
    * Creates a new <code>local-producer</code> element 
    * @return the new created instance of <code>ProducerType<ConsumerBeanType<T>></code> 
    */
   public ProducerType<ConsumerBeanType<T>> createLocalProducer()
   {
      return new ProducerTypeImpl<ConsumerBeanType<T>>(this, "local-producer", childNode);
   }

   /**
    * Returns all <code>local-producer</code> elements
    * @return list of <code>local-producer</code> 
    */
   public List<ProducerType<ConsumerBeanType<T>>> getAllLocalProducer()
   {
      List<ProducerType<ConsumerBeanType<T>>> list = new ArrayList<ProducerType<ConsumerBeanType<T>>>();
      List<Node> nodeList = childNode.get("local-producer");
      for(Node node: nodeList)
      {
         ProducerType<ConsumerBeanType<T>>  type = new ProducerTypeImpl<ConsumerBeanType<T>>(this, "local-producer", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>local-producer</code> elements 
    * @return the current instance of <code>ProducerType<ConsumerBeanType<T>></code> 
    */
   public ConsumerBeanType<T> removeAllLocalProducer()
   {
      childNode.removeChildren("local-producer");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:method-attributesType ElementType : current-message
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>current-message</code> element with the given value will be created.
    * Otherwise, the existing <code>current-message</code> element will be returned.
    * @return  a new or existing instance of <code>MethodAttributesType<ConsumerBeanType<T>></code> 
    */
   public MethodAttributesType<ConsumerBeanType<T>> getOrCreateCurrentMessage()
   {
      Node node = childNode.getOrCreate("current-message");
      MethodAttributesType<ConsumerBeanType<T>> currentMessage = new MethodAttributesTypeImpl<ConsumerBeanType<T>>(this, "current-message", childNode, node);
      return currentMessage;
   }

   /**
    * Removes the <code>current-message</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeCurrentMessage()
   {
      childNode.removeChildren("current-message");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:message-propertiesType ElementType : message-properties
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>message-properties</code> element will be created and returned.
    * Otherwise, the first existing <code>message-properties</code> element will be returned.
    * @return the instance defined for the element <code>message-properties</code> 
    */
   public MessagePropertiesType<ConsumerBeanType<T>> getOrCreateMessageProperties()
   {
      List<Node> nodeList = childNode.get("message-properties");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new MessagePropertiesTypeImpl<ConsumerBeanType<T>>(this, "message-properties", childNode, nodeList.get(0));
      }
      return createMessageProperties();
   }

   /**
    * Creates a new <code>message-properties</code> element 
    * @return the new created instance of <code>MessagePropertiesType<ConsumerBeanType<T>></code> 
    */
   public MessagePropertiesType<ConsumerBeanType<T>> createMessageProperties()
   {
      return new MessagePropertiesTypeImpl<ConsumerBeanType<T>>(this, "message-properties", childNode);
   }

   /**
    * Returns all <code>message-properties</code> elements
    * @return list of <code>message-properties</code> 
    */
   public List<MessagePropertiesType<ConsumerBeanType<T>>> getAllMessageProperties()
   {
      List<MessagePropertiesType<ConsumerBeanType<T>>> list = new ArrayList<MessagePropertiesType<ConsumerBeanType<T>>>();
      List<Node> nodeList = childNode.get("message-properties");
      for(Node node: nodeList)
      {
         MessagePropertiesType<ConsumerBeanType<T>>  type = new MessagePropertiesTypeImpl<ConsumerBeanType<T>>(this, "message-properties", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>message-properties</code> elements 
    * @return the current instance of <code>MessagePropertiesType<ConsumerBeanType<T>></code> 
    */
   public ConsumerBeanType<T> removeAllMessageProperties()
   {
      childNode.removeChildren("message-properties");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:ejb-refType ElementType : ejb-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>ejb-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>ejb-ref</code> element will be returned.
    * @return the instance defined for the element <code>ejb-ref</code> 
    */
   public EjbRefType<ConsumerBeanType<T>> getOrCreateEjbRef()
   {
      List<Node> nodeList = childNode.get("ejb-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new EjbRefTypeImpl<ConsumerBeanType<T>>(this, "ejb-ref", childNode, nodeList.get(0));
      }
      return createEjbRef();
   }

   /**
    * Creates a new <code>ejb-ref</code> element 
    * @return the new created instance of <code>EjbRefType<ConsumerBeanType<T>></code> 
    */
   public EjbRefType<ConsumerBeanType<T>> createEjbRef()
   {
      return new EjbRefTypeImpl<ConsumerBeanType<T>>(this, "ejb-ref", childNode);
   }

   /**
    * Returns all <code>ejb-ref</code> elements
    * @return list of <code>ejb-ref</code> 
    */
   public List<EjbRefType<ConsumerBeanType<T>>> getAllEjbRef()
   {
      List<EjbRefType<ConsumerBeanType<T>>> list = new ArrayList<EjbRefType<ConsumerBeanType<T>>>();
      List<Node> nodeList = childNode.get("ejb-ref");
      for(Node node: nodeList)
      {
         EjbRefType<ConsumerBeanType<T>>  type = new EjbRefTypeImpl<ConsumerBeanType<T>>(this, "ejb-ref", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>ejb-ref</code> elements 
    * @return the current instance of <code>EjbRefType<ConsumerBeanType<T>></code> 
    */
   public ConsumerBeanType<T> removeAllEjbRef()
   {
      childNode.removeChildren("ejb-ref");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:ejb-local-refType ElementType : ejb-local-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>ejb-local-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>ejb-local-ref</code> element will be returned.
    * @return the instance defined for the element <code>ejb-local-ref</code> 
    */
   public EjbLocalRefType<ConsumerBeanType<T>> getOrCreateEjbLocalRef()
   {
      List<Node> nodeList = childNode.get("ejb-local-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new EjbLocalRefTypeImpl<ConsumerBeanType<T>>(this, "ejb-local-ref", childNode, nodeList.get(0));
      }
      return createEjbLocalRef();
   }

   /**
    * Creates a new <code>ejb-local-ref</code> element 
    * @return the new created instance of <code>EjbLocalRefType<ConsumerBeanType<T>></code> 
    */
   public EjbLocalRefType<ConsumerBeanType<T>> createEjbLocalRef()
   {
      return new EjbLocalRefTypeImpl<ConsumerBeanType<T>>(this, "ejb-local-ref", childNode);
   }

   /**
    * Returns all <code>ejb-local-ref</code> elements
    * @return list of <code>ejb-local-ref</code> 
    */
   public List<EjbLocalRefType<ConsumerBeanType<T>>> getAllEjbLocalRef()
   {
      List<EjbLocalRefType<ConsumerBeanType<T>>> list = new ArrayList<EjbLocalRefType<ConsumerBeanType<T>>>();
      List<Node> nodeList = childNode.get("ejb-local-ref");
      for(Node node: nodeList)
      {
         EjbLocalRefType<ConsumerBeanType<T>>  type = new EjbLocalRefTypeImpl<ConsumerBeanType<T>>(this, "ejb-local-ref", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>ejb-local-ref</code> elements 
    * @return the current instance of <code>EjbLocalRefType<ConsumerBeanType<T>></code> 
    */
   public ConsumerBeanType<T> removeAllEjbLocalRef()
   {
      childNode.removeChildren("ejb-local-ref");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:security-identityType ElementType : security-identity
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>security-identity</code> element with the given value will be created.
    * Otherwise, the existing <code>security-identity</code> element will be returned.
    * @return  a new or existing instance of <code>SecurityIdentityType<ConsumerBeanType<T>></code> 
    */
   public SecurityIdentityType<ConsumerBeanType<T>> getOrCreateSecurityIdentity()
   {
      Node node = childNode.getOrCreate("security-identity");
      SecurityIdentityType<ConsumerBeanType<T>> securityIdentity = new SecurityIdentityTypeImpl<ConsumerBeanType<T>>(this, "security-identity", childNode, node);
      return securityIdentity;
   }

   /**
    * Removes the <code>security-identity</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeSecurityIdentity()
   {
      childNode.removeChildren("security-identity");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:resource-refType ElementType : resource-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resource-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>resource-ref</code> element will be returned.
    * @return the instance defined for the element <code>resource-ref</code> 
    */
   public ResourceRefType<ConsumerBeanType<T>> getOrCreateResourceRef()
   {
      List<Node> nodeList = childNode.get("resource-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ResourceRefTypeImpl<ConsumerBeanType<T>>(this, "resource-ref", childNode, nodeList.get(0));
      }
      return createResourceRef();
   }

   /**
    * Creates a new <code>resource-ref</code> element 
    * @return the new created instance of <code>ResourceRefType<ConsumerBeanType<T>></code> 
    */
   public ResourceRefType<ConsumerBeanType<T>> createResourceRef()
   {
      return new ResourceRefTypeImpl<ConsumerBeanType<T>>(this, "resource-ref", childNode);
   }

   /**
    * Returns all <code>resource-ref</code> elements
    * @return list of <code>resource-ref</code> 
    */
   public List<ResourceRefType<ConsumerBeanType<T>>> getAllResourceRef()
   {
      List<ResourceRefType<ConsumerBeanType<T>>> list = new ArrayList<ResourceRefType<ConsumerBeanType<T>>>();
      List<Node> nodeList = childNode.get("resource-ref");
      for(Node node: nodeList)
      {
         ResourceRefType<ConsumerBeanType<T>>  type = new ResourceRefTypeImpl<ConsumerBeanType<T>>(this, "resource-ref", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>resource-ref</code> elements 
    * @return the current instance of <code>ResourceRefType<ConsumerBeanType<T>></code> 
    */
   public ConsumerBeanType<T> removeAllResourceRef()
   {
      childNode.removeChildren("resource-ref");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:resource-env-refType ElementType : resource-env-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resource-env-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>resource-env-ref</code> element will be returned.
    * @return the instance defined for the element <code>resource-env-ref</code> 
    */
   public ResourceEnvRefType<ConsumerBeanType<T>> getOrCreateResourceEnvRef()
   {
      List<Node> nodeList = childNode.get("resource-env-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ResourceEnvRefTypeImpl<ConsumerBeanType<T>>(this, "resource-env-ref", childNode, nodeList.get(0));
      }
      return createResourceEnvRef();
   }

   /**
    * Creates a new <code>resource-env-ref</code> element 
    * @return the new created instance of <code>ResourceEnvRefType<ConsumerBeanType<T>></code> 
    */
   public ResourceEnvRefType<ConsumerBeanType<T>> createResourceEnvRef()
   {
      return new ResourceEnvRefTypeImpl<ConsumerBeanType<T>>(this, "resource-env-ref", childNode);
   }

   /**
    * Returns all <code>resource-env-ref</code> elements
    * @return list of <code>resource-env-ref</code> 
    */
   public List<ResourceEnvRefType<ConsumerBeanType<T>>> getAllResourceEnvRef()
   {
      List<ResourceEnvRefType<ConsumerBeanType<T>>> list = new ArrayList<ResourceEnvRefType<ConsumerBeanType<T>>>();
      List<Node> nodeList = childNode.get("resource-env-ref");
      for(Node node: nodeList)
      {
         ResourceEnvRefType<ConsumerBeanType<T>>  type = new ResourceEnvRefTypeImpl<ConsumerBeanType<T>>(this, "resource-env-ref", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>resource-env-ref</code> elements 
    * @return the current instance of <code>ResourceEnvRefType<ConsumerBeanType<T>></code> 
    */
   public ConsumerBeanType<T> removeAllResourceEnvRef()
   {
      childNode.removeChildren("resource-env-ref");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:message-destination-refType ElementType : message-destination-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>message-destination-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>message-destination-ref</code> element will be returned.
    * @return the instance defined for the element <code>message-destination-ref</code> 
    */
   public MessageDestinationRefType<ConsumerBeanType<T>> getOrCreateMessageDestinationRef()
   {
      List<Node> nodeList = childNode.get("message-destination-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new MessageDestinationRefTypeImpl<ConsumerBeanType<T>>(this, "message-destination-ref", childNode, nodeList.get(0));
      }
      return createMessageDestinationRef();
   }

   /**
    * Creates a new <code>message-destination-ref</code> element 
    * @return the new created instance of <code>MessageDestinationRefType<ConsumerBeanType<T>></code> 
    */
   public MessageDestinationRefType<ConsumerBeanType<T>> createMessageDestinationRef()
   {
      return new MessageDestinationRefTypeImpl<ConsumerBeanType<T>>(this, "message-destination-ref", childNode);
   }

   /**
    * Returns all <code>message-destination-ref</code> elements
    * @return list of <code>message-destination-ref</code> 
    */
   public List<MessageDestinationRefType<ConsumerBeanType<T>>> getAllMessageDestinationRef()
   {
      List<MessageDestinationRefType<ConsumerBeanType<T>>> list = new ArrayList<MessageDestinationRefType<ConsumerBeanType<T>>>();
      List<Node> nodeList = childNode.get("message-destination-ref");
      for(Node node: nodeList)
      {
         MessageDestinationRefType<ConsumerBeanType<T>>  type = new MessageDestinationRefTypeImpl<ConsumerBeanType<T>>(this, "message-destination-ref", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>message-destination-ref</code> elements 
    * @return the current instance of <code>MessageDestinationRefType<ConsumerBeanType<T>></code> 
    */
   public ConsumerBeanType<T> removeAllMessageDestinationRef()
   {
      childNode.removeChildren("message-destination-ref");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: xsd:token ElementType : security-domain
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>security-domain</code> element
    * @param securityDomain the value for the element <code>security-domain</code> 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> securityDomain(String securityDomain)
   {
      childNode.getOrCreate("security-domain").text(securityDomain);
      return this;
   }

   /**
    * Returns the <code>security-domain</code> element
    * @return the node defined for the element <code>security-domain</code> 
    */
   public String getSecurityDomain()
   {
      return childNode.getTextValueForPatternName("security-domain");
   }

   /**
    * Removes the <code>security-domain</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeSecurityDomain()
   {
      childNode.removeChildren("security-domain");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:method-attributesType ElementType : method-attributes
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>method-attributes</code> element with the given value will be created.
    * Otherwise, the existing <code>method-attributes</code> element will be returned.
    * @return  a new or existing instance of <code>MethodAttributesType<ConsumerBeanType<T>></code> 
    */
   public MethodAttributesType<ConsumerBeanType<T>> getOrCreateMethodAttributes()
   {
      Node node = childNode.getOrCreate("method-attributes");
      MethodAttributesType<ConsumerBeanType<T>> methodAttributes = new MethodAttributesTypeImpl<ConsumerBeanType<T>>(this, "method-attributes", childNode, node);
      return methodAttributes;
   }

   /**
    * Removes the <code>method-attributes</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeMethodAttributes()
   {
      childNode.removeChildren("method-attributes");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: xsd:token ElementType : depends
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>depends</code> elements, 
    * a new <code>depends</code> element 
    * @param values list of <code>depends</code> objects 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> depends(String ... values)
   {
      if (values != null)
      {
         for(String name: values)
         {
            childNode.createChild("depends").text(name);
         }
      }
      return this;
   }

   /**
    * Returns all <code>depends</code> elements
    * @return list of <code>depends</code> 
    */
public List<String> getAllDepends()
   {
      List<String> result = new ArrayList<String>();
      List<Node> nodes = childNode.get("depends");
      for (Node node : nodes)
      {
         result.add(node.getText());
      }
      return result;
   }

   /**
    * Removes the <code>depends</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeAllDepends()
   {
      childNode.removeChildren("depends");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:annotationType ElementType : annotation
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>annotation</code> element will be created and returned.
    * Otherwise, the first existing <code>annotation</code> element will be returned.
    * @return the instance defined for the element <code>annotation</code> 
    */
   public AnnotationType<ConsumerBeanType<T>> getOrCreateAnnotation()
   {
      List<Node> nodeList = childNode.get("annotation");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new AnnotationTypeImpl<ConsumerBeanType<T>>(this, "annotation", childNode, nodeList.get(0));
      }
      return createAnnotation();
   }

   /**
    * Creates a new <code>annotation</code> element 
    * @return the new created instance of <code>AnnotationType<ConsumerBeanType<T>></code> 
    */
   public AnnotationType<ConsumerBeanType<T>> createAnnotation()
   {
      return new AnnotationTypeImpl<ConsumerBeanType<T>>(this, "annotation", childNode);
   }

   /**
    * Returns all <code>annotation</code> elements
    * @return list of <code>annotation</code> 
    */
   public List<AnnotationType<ConsumerBeanType<T>>> getAllAnnotation()
   {
      List<AnnotationType<ConsumerBeanType<T>>> list = new ArrayList<AnnotationType<ConsumerBeanType<T>>>();
      List<Node> nodeList = childNode.get("annotation");
      for(Node node: nodeList)
      {
         AnnotationType<ConsumerBeanType<T>>  type = new AnnotationTypeImpl<ConsumerBeanType<T>>(this, "annotation", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>annotation</code> elements 
    * @return the current instance of <code>AnnotationType<ConsumerBeanType<T>></code> 
    */
   public ConsumerBeanType<T> removeAllAnnotation()
   {
      childNode.removeChildren("annotation");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:ignore-dependencyType ElementType : ignore-dependency
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>ignore-dependency</code> element with the given value will be created.
    * Otherwise, the existing <code>ignore-dependency</code> element will be returned.
    * @return  a new or existing instance of <code>IgnoreDependencyType<ConsumerBeanType<T>></code> 
    */
   public IgnoreDependencyType<ConsumerBeanType<T>> getOrCreateIgnoreDependency()
   {
      Node node = childNode.getOrCreate("ignore-dependency");
      IgnoreDependencyType<ConsumerBeanType<T>> ignoreDependency = new IgnoreDependencyTypeImpl<ConsumerBeanType<T>>(this, "ignore-dependency", childNode, node);
      return ignoreDependency;
   }

   /**
    * Removes the <code>ignore-dependency</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeIgnoreDependency()
   {
      childNode.removeChildren("ignore-dependency");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: javaee:string ElementType : aop-domain-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>aop-domain-name</code> element
    * @param aopDomainName the value for the element <code>aop-domain-name</code> 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> aopDomainName(String aopDomainName)
   {
      childNode.getOrCreate("aop-domain-name").text(aopDomainName);
      return this;
   }

   /**
    * Returns the <code>aop-domain-name</code> element
    * @return the node defined for the element <code>aop-domain-name</code> 
    */
   public String getAopDomainName()
   {
      return childNode.getTextValueForPatternName("aop-domain-name");
   }

   /**
    * Removes the <code>aop-domain-name</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeAopDomainName()
   {
      childNode.removeChildren("aop-domain-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:pool-configType ElementType : pool-config
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>pool-config</code> element with the given value will be created.
    * Otherwise, the existing <code>pool-config</code> element will be returned.
    * @return  a new or existing instance of <code>PoolConfigType<ConsumerBeanType<T>></code> 
    */
   public PoolConfigType<ConsumerBeanType<T>> getOrCreatePoolConfig()
   {
      Node node = childNode.getOrCreate("pool-config");
      PoolConfigType<ConsumerBeanType<T>> poolConfig = new PoolConfigTypeImpl<ConsumerBeanType<T>>(this, "pool-config", childNode, node);
      return poolConfig;
   }

   /**
    * Removes the <code>pool-config</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removePoolConfig()
   {
      childNode.removeChildren("pool-config");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:jndi-refType ElementType : jndi-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>jndi-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>jndi-ref</code> element will be returned.
    * @return the instance defined for the element <code>jndi-ref</code> 
    */
   public JndiRefType<ConsumerBeanType<T>> getOrCreateJndiRef()
   {
      List<Node> nodeList = childNode.get("jndi-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new JndiRefTypeImpl<ConsumerBeanType<T>>(this, "jndi-ref", childNode, nodeList.get(0));
      }
      return createJndiRef();
   }

   /**
    * Creates a new <code>jndi-ref</code> element 
    * @return the new created instance of <code>JndiRefType<ConsumerBeanType<T>></code> 
    */
   public JndiRefType<ConsumerBeanType<T>> createJndiRef()
   {
      return new JndiRefTypeImpl<ConsumerBeanType<T>>(this, "jndi-ref", childNode);
   }

   /**
    * Returns all <code>jndi-ref</code> elements
    * @return list of <code>jndi-ref</code> 
    */
   public List<JndiRefType<ConsumerBeanType<T>>> getAllJndiRef()
   {
      List<JndiRefType<ConsumerBeanType<T>>> list = new ArrayList<JndiRefType<ConsumerBeanType<T>>>();
      List<Node> nodeList = childNode.get("jndi-ref");
      for(Node node: nodeList)
      {
         JndiRefType<ConsumerBeanType<T>>  type = new JndiRefTypeImpl<ConsumerBeanType<T>>(this, "jndi-ref", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>jndi-ref</code> elements 
    * @return the current instance of <code>JndiRefType<ConsumerBeanType<T>></code> 
    */
   public ConsumerBeanType<T> removeAllJndiRef()
   {
      childNode.removeChildren("jndi-ref");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: jboss:activation-configType ElementType : activation-config
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>activation-config</code> element with the given value will be created.
    * Otherwise, the existing <code>activation-config</code> element will be returned.
    * @return  a new or existing instance of <code>ActivationConfigType<ConsumerBeanType<T>></code> 
    */
   public ActivationConfigType<ConsumerBeanType<T>> getOrCreateActivationConfig()
   {
      Node node = childNode.getOrCreate("activation-config");
      ActivationConfigType<ConsumerBeanType<T>> activationConfig = new ActivationConfigTypeImpl<ConsumerBeanType<T>>(this, "activation-config", childNode, node);
      return activationConfig;
   }

   /**
    * Removes the <code>activation-config</code> element 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeActivationConfig()
   {
      childNode.removeChildren("activation-config");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConsumerBeanType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> id(String id)
   {
      childNode.attribute("id", id);
      return this;
   }

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
      public String getId()
   {
      return childNode.getAttribute("id");
   }

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>ConsumerBeanType<T></code> 
    */
   public ConsumerBeanType<T> removeId()
   {
      childNode.removeAttribute("id");
      return this;
   }
}
