package org.jboss.shrinkwrap.descriptor.impl.jboss51; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jboss51.MethodType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;

/**
 * This class implements the <code> methodType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class MethodTypeImpl<T> implements Child<T>, MethodType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public MethodTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public MethodTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MethodType ElementName: javaee:string ElementType : method-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>method-name</code> element
    * @param methodName the value for the element <code>method-name</code> 
    * @return the current instance of <code>MethodType<T></code> 
    */
   public MethodType<T> methodName(String methodName)
   {
      childNode.getOrCreate("method-name").text(methodName);
      return this;
   }

   /**
    * Returns the <code>method-name</code> element
    * @return the node defined for the element <code>method-name</code> 
    */
   public String getMethodName()
   {
      return childNode.getTextValueForPatternName("method-name");
   }

   /**
    * Removes the <code>method-name</code> element 
    * @return the current instance of <code>MethodType<T></code> 
    */
   public MethodType<T> removeMethodName()
   {
      childNode.removeChildren("method-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MethodType ElementName: xsd:boolean ElementType : read-only
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>read-only</code> element
    * @param readOnly the value for the element <code>read-only</code> 
    * @return the current instance of <code>MethodType<T></code> 
    */
   public MethodType<T> readOnly(Boolean readOnly)
   {
      childNode.getOrCreate("read-only").text(readOnly);
      return this;
   }

   /**
    * Returns the <code>read-only</code> element
    * @return the node defined for the element <code>read-only</code> 
    */
   public Boolean isReadOnly()
   {
      return Strings.isTrue(childNode.getTextValueForPatternName("read-only"));
   }

   /**
    * Removes the <code>read-only</code> element 
    * @return the current instance of <code>MethodType<T></code> 
    */
   public MethodType<T> removeReadOnly()
   {
      childNode.removeChildren("read-only");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MethodType ElementName: xsd:boolean ElementType : idempotent
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>idempotent</code> element
    * @param idempotent the value for the element <code>idempotent</code> 
    * @return the current instance of <code>MethodType<T></code> 
    */
   public MethodType<T> idempotent(Boolean idempotent)
   {
      childNode.getOrCreate("idempotent").text(idempotent);
      return this;
   }

   /**
    * Returns the <code>idempotent</code> element
    * @return the node defined for the element <code>idempotent</code> 
    */
   public Boolean isIdempotent()
   {
      return Strings.isTrue(childNode.getTextValueForPatternName("idempotent"));
   }

   /**
    * Removes the <code>idempotent</code> element 
    * @return the current instance of <code>MethodType<T></code> 
    */
   public MethodType<T> removeIdempotent()
   {
      childNode.removeChildren("idempotent");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MethodType ElementName: javaee:string ElementType : transaction-timeout
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>transaction-timeout</code> element
    * @param transactionTimeout the value for the element <code>transaction-timeout</code> 
    * @return the current instance of <code>MethodType<T></code> 
    */
   public MethodType<T> transactionTimeout(String transactionTimeout)
   {
      childNode.getOrCreate("transaction-timeout").text(transactionTimeout);
      return this;
   }

   /**
    * Returns the <code>transaction-timeout</code> element
    * @return the node defined for the element <code>transaction-timeout</code> 
    */
   public String getTransactionTimeout()
   {
      return childNode.getTextValueForPatternName("transaction-timeout");
   }

   /**
    * Removes the <code>transaction-timeout</code> element 
    * @return the current instance of <code>MethodType<T></code> 
    */
   public MethodType<T> removeTransactionTimeout()
   {
      childNode.removeChildren("transaction-timeout");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: MethodType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>MethodType<T></code> 
    */
   public MethodType<T> id(String id)
   {
      childNode.attribute("id", id);
      return this;
   }

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
      public String getId()
   {
      return childNode.getAttribute("id");
   }

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>MethodType<T></code> 
    */
   public MethodType<T> removeId()
   {
      childNode.removeAttribute("id");
      return this;
   }
}
