package org.jboss.shrinkwrap.descriptor.impl.jboss51; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jboss51.ServiceBeanType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jboss51.SecurityIdentityType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.SecurityIdentityTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.LocalBindingType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.LocalBindingTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.RemoteBindingType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.RemoteBindingTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.ClusterConfigType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.ClusterConfigTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.MethodAttributesType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.MethodAttributesTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.AnnotationType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.AnnotationTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.IgnoreDependencyType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.IgnoreDependencyTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.PoolConfigType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.PoolConfigTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.JndiRefType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.JndiRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.PortComponentType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.PortComponentTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jboss51.SecurityIdentityType;
import org.jboss.shrinkwrap.descriptor.impl.jboss51.SecurityIdentityTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.javaee5.IconType;
import org.jboss.shrinkwrap.descriptor.impl.javaee5.IconTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.EnvEntryType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.EnvEntryTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.EjbRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.EjbRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.EjbLocalRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.EjbLocalRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.ResourceRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.ResourceRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.ResourceEnvRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.ResourceEnvRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.MessageDestinationRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.MessageDestinationRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.PersistenceContextRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.PersistenceContextRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.PersistenceUnitRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.PersistenceUnitRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.LifecycleCallbackType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.LifecycleCallbackTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.LifecycleCallbackType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.LifecycleCallbackTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon51.ServiceRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon51.ServiceRefTypeImpl;

/**
 * This class implements the <code> service-beanType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class ServiceBeanTypeImpl<T> implements Child<T>, ServiceBeanType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public ServiceBeanTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public ServiceBeanTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: xsd:string ElementType : description
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>description</code> elements, 
    * a new <code>description</code> element 
    * @param values list of <code>description</code> objects 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> description(String ... values)
   {
      if (values != null)
      {
         for(String name: values)
         {
            childNode.createChild("description").text(name);
         }
      }
      return this;
   }

   /**
    * Returns all <code>description</code> elements
    * @return list of <code>description</code> 
    */
public List<String> getAllDescription()
   {
      List<String> result = new ArrayList<String>();
      List<Node> nodes = childNode.get("description");
      for (Node node : nodes)
      {
         result.add(node.getText());
      }
      return result;
   }

   /**
    * Removes the <code>description</code> element 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removeAllDescription()
   {
      childNode.removeChildren("description");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: xsd:token ElementType : display-name
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>display-name</code> elements, 
    * a new <code>display-name</code> element 
    * @param values list of <code>display-name</code> objects 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> displayName(String ... values)
   {
      if (values != null)
      {
         for(String name: values)
         {
            childNode.createChild("display-name").text(name);
         }
      }
      return this;
   }

   /**
    * Returns all <code>display-name</code> elements
    * @return list of <code>display-name</code> 
    */
public List<String> getAllDisplayName()
   {
      List<String> result = new ArrayList<String>();
      List<Node> nodes = childNode.get("display-name");
      for (Node node : nodes)
      {
         result.add(node.getText());
      }
      return result;
   }

   /**
    * Removes the <code>display-name</code> element 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removeAllDisplayName()
   {
      childNode.removeChildren("display-name");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: javaee:iconType ElementType : icon
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>icon</code> element will be created and returned.
    * Otherwise, the first existing <code>icon</code> element will be returned.
    * @return the instance defined for the element <code>icon</code> 
    */
   public IconType<ServiceBeanType<T>> getOrCreateIcon()
   {
      List<Node> nodeList = childNode.get("icon");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new IconTypeImpl<ServiceBeanType<T>>(this, "icon", childNode, nodeList.get(0));
      }
      return createIcon();
   }

   /**
    * Creates a new <code>icon</code> element 
    * @return the new created instance of <code>IconType<ServiceBeanType<T>></code> 
    */
   public IconType<ServiceBeanType<T>> createIcon()
   {
      return new IconTypeImpl<ServiceBeanType<T>>(this, "icon", childNode);
   }

   /**
    * Returns all <code>icon</code> elements
    * @return list of <code>icon</code> 
    */
   public List<IconType<ServiceBeanType<T>>> getAllIcon()
   {
      List<IconType<ServiceBeanType<T>>> list = new ArrayList<IconType<ServiceBeanType<T>>>();
      List<Node> nodeList = childNode.get("icon");
      for(Node node: nodeList)
      {
         IconType<ServiceBeanType<T>>  type = new IconTypeImpl<ServiceBeanType<T>>(this, "icon", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>icon</code> elements 
    * @return the current instance of <code>IconType<ServiceBeanType<T>></code> 
    */
   public ServiceBeanType<T> removeAllIcon()
   {
      childNode.removeChildren("icon");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: jboss:env-entryType ElementType : env-entry
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>env-entry</code> element will be created and returned.
    * Otherwise, the first existing <code>env-entry</code> element will be returned.
    * @return the instance defined for the element <code>env-entry</code> 
    */
   public EnvEntryType<ServiceBeanType<T>> getOrCreateEnvEntry()
   {
      List<Node> nodeList = childNode.get("env-entry");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new EnvEntryTypeImpl<ServiceBeanType<T>>(this, "env-entry", childNode, nodeList.get(0));
      }
      return createEnvEntry();
   }

   /**
    * Creates a new <code>env-entry</code> element 
    * @return the new created instance of <code>EnvEntryType<ServiceBeanType<T>></code> 
    */
   public EnvEntryType<ServiceBeanType<T>> createEnvEntry()
   {
      return new EnvEntryTypeImpl<ServiceBeanType<T>>(this, "env-entry", childNode);
   }

   /**
    * Returns all <code>env-entry</code> elements
    * @return list of <code>env-entry</code> 
    */
   public List<EnvEntryType<ServiceBeanType<T>>> getAllEnvEntry()
   {
      List<EnvEntryType<ServiceBeanType<T>>> list = new ArrayList<EnvEntryType<ServiceBeanType<T>>>();
      List<Node> nodeList = childNode.get("env-entry");
      for(Node node: nodeList)
      {
         EnvEntryType<ServiceBeanType<T>>  type = new EnvEntryTypeImpl<ServiceBeanType<T>>(this, "env-entry", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>env-entry</code> elements 
    * @return the current instance of <code>EnvEntryType<ServiceBeanType<T>></code> 
    */
   public ServiceBeanType<T> removeAllEnvEntry()
   {
      childNode.removeChildren("env-entry");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: jboss:ejb-refType ElementType : ejb-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>ejb-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>ejb-ref</code> element will be returned.
    * @return the instance defined for the element <code>ejb-ref</code> 
    */
   public EjbRefType<ServiceBeanType<T>> getOrCreateEjbRef()
   {
      List<Node> nodeList = childNode.get("ejb-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new EjbRefTypeImpl<ServiceBeanType<T>>(this, "ejb-ref", childNode, nodeList.get(0));
      }
      return createEjbRef();
   }

   /**
    * Creates a new <code>ejb-ref</code> element 
    * @return the new created instance of <code>EjbRefType<ServiceBeanType<T>></code> 
    */
   public EjbRefType<ServiceBeanType<T>> createEjbRef()
   {
      return new EjbRefTypeImpl<ServiceBeanType<T>>(this, "ejb-ref", childNode);
   }

   /**
    * Returns all <code>ejb-ref</code> elements
    * @return list of <code>ejb-ref</code> 
    */
   public List<EjbRefType<ServiceBeanType<T>>> getAllEjbRef()
   {
      List<EjbRefType<ServiceBeanType<T>>> list = new ArrayList<EjbRefType<ServiceBeanType<T>>>();
      List<Node> nodeList = childNode.get("ejb-ref");
      for(Node node: nodeList)
      {
         EjbRefType<ServiceBeanType<T>>  type = new EjbRefTypeImpl<ServiceBeanType<T>>(this, "ejb-ref", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>ejb-ref</code> elements 
    * @return the current instance of <code>EjbRefType<ServiceBeanType<T>></code> 
    */
   public ServiceBeanType<T> removeAllEjbRef()
   {
      childNode.removeChildren("ejb-ref");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: jboss:ejb-local-refType ElementType : ejb-local-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>ejb-local-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>ejb-local-ref</code> element will be returned.
    * @return the instance defined for the element <code>ejb-local-ref</code> 
    */
   public EjbLocalRefType<ServiceBeanType<T>> getOrCreateEjbLocalRef()
   {
      List<Node> nodeList = childNode.get("ejb-local-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new EjbLocalRefTypeImpl<ServiceBeanType<T>>(this, "ejb-local-ref", childNode, nodeList.get(0));
      }
      return createEjbLocalRef();
   }

   /**
    * Creates a new <code>ejb-local-ref</code> element 
    * @return the new created instance of <code>EjbLocalRefType<ServiceBeanType<T>></code> 
    */
   public EjbLocalRefType<ServiceBeanType<T>> createEjbLocalRef()
   {
      return new EjbLocalRefTypeImpl<ServiceBeanType<T>>(this, "ejb-local-ref", childNode);
   }

   /**
    * Returns all <code>ejb-local-ref</code> elements
    * @return list of <code>ejb-local-ref</code> 
    */
   public List<EjbLocalRefType<ServiceBeanType<T>>> getAllEjbLocalRef()
   {
      List<EjbLocalRefType<ServiceBeanType<T>>> list = new ArrayList<EjbLocalRefType<ServiceBeanType<T>>>();
      List<Node> nodeList = childNode.get("ejb-local-ref");
      for(Node node: nodeList)
      {
         EjbLocalRefType<ServiceBeanType<T>>  type = new EjbLocalRefTypeImpl<ServiceBeanType<T>>(this, "ejb-local-ref", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>ejb-local-ref</code> elements 
    * @return the current instance of <code>EjbLocalRefType<ServiceBeanType<T>></code> 
    */
   public ServiceBeanType<T> removeAllEjbLocalRef()
   {
      childNode.removeChildren("ejb-local-ref");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: jboss:resource-refType ElementType : resource-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resource-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>resource-ref</code> element will be returned.
    * @return the instance defined for the element <code>resource-ref</code> 
    */
   public ResourceRefType<ServiceBeanType<T>> getOrCreateResourceRef()
   {
      List<Node> nodeList = childNode.get("resource-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ResourceRefTypeImpl<ServiceBeanType<T>>(this, "resource-ref", childNode, nodeList.get(0));
      }
      return createResourceRef();
   }

   /**
    * Creates a new <code>resource-ref</code> element 
    * @return the new created instance of <code>ResourceRefType<ServiceBeanType<T>></code> 
    */
   public ResourceRefType<ServiceBeanType<T>> createResourceRef()
   {
      return new ResourceRefTypeImpl<ServiceBeanType<T>>(this, "resource-ref", childNode);
   }

   /**
    * Returns all <code>resource-ref</code> elements
    * @return list of <code>resource-ref</code> 
    */
   public List<ResourceRefType<ServiceBeanType<T>>> getAllResourceRef()
   {
      List<ResourceRefType<ServiceBeanType<T>>> list = new ArrayList<ResourceRefType<ServiceBeanType<T>>>();
      List<Node> nodeList = childNode.get("resource-ref");
      for(Node node: nodeList)
      {
         ResourceRefType<ServiceBeanType<T>>  type = new ResourceRefTypeImpl<ServiceBeanType<T>>(this, "resource-ref", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>resource-ref</code> elements 
    * @return the current instance of <code>ResourceRefType<ServiceBeanType<T>></code> 
    */
   public ServiceBeanType<T> removeAllResourceRef()
   {
      childNode.removeChildren("resource-ref");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: jboss:resource-env-refType ElementType : resource-env-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resource-env-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>resource-env-ref</code> element will be returned.
    * @return the instance defined for the element <code>resource-env-ref</code> 
    */
   public ResourceEnvRefType<ServiceBeanType<T>> getOrCreateResourceEnvRef()
   {
      List<Node> nodeList = childNode.get("resource-env-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ResourceEnvRefTypeImpl<ServiceBeanType<T>>(this, "resource-env-ref", childNode, nodeList.get(0));
      }
      return createResourceEnvRef();
   }

   /**
    * Creates a new <code>resource-env-ref</code> element 
    * @return the new created instance of <code>ResourceEnvRefType<ServiceBeanType<T>></code> 
    */
   public ResourceEnvRefType<ServiceBeanType<T>> createResourceEnvRef()
   {
      return new ResourceEnvRefTypeImpl<ServiceBeanType<T>>(this, "resource-env-ref", childNode);
   }

   /**
    * Returns all <code>resource-env-ref</code> elements
    * @return list of <code>resource-env-ref</code> 
    */
   public List<ResourceEnvRefType<ServiceBeanType<T>>> getAllResourceEnvRef()
   {
      List<ResourceEnvRefType<ServiceBeanType<T>>> list = new ArrayList<ResourceEnvRefType<ServiceBeanType<T>>>();
      List<Node> nodeList = childNode.get("resource-env-ref");
      for(Node node: nodeList)
      {
         ResourceEnvRefType<ServiceBeanType<T>>  type = new ResourceEnvRefTypeImpl<ServiceBeanType<T>>(this, "resource-env-ref", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>resource-env-ref</code> elements 
    * @return the current instance of <code>ResourceEnvRefType<ServiceBeanType<T>></code> 
    */
   public ServiceBeanType<T> removeAllResourceEnvRef()
   {
      childNode.removeChildren("resource-env-ref");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: jboss:message-destination-refType ElementType : message-destination-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>message-destination-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>message-destination-ref</code> element will be returned.
    * @return the instance defined for the element <code>message-destination-ref</code> 
    */
   public MessageDestinationRefType<ServiceBeanType<T>> getOrCreateMessageDestinationRef()
   {
      List<Node> nodeList = childNode.get("message-destination-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new MessageDestinationRefTypeImpl<ServiceBeanType<T>>(this, "message-destination-ref", childNode, nodeList.get(0));
      }
      return createMessageDestinationRef();
   }

   /**
    * Creates a new <code>message-destination-ref</code> element 
    * @return the new created instance of <code>MessageDestinationRefType<ServiceBeanType<T>></code> 
    */
   public MessageDestinationRefType<ServiceBeanType<T>> createMessageDestinationRef()
   {
      return new MessageDestinationRefTypeImpl<ServiceBeanType<T>>(this, "message-destination-ref", childNode);
   }

   /**
    * Returns all <code>message-destination-ref</code> elements
    * @return list of <code>message-destination-ref</code> 
    */
   public List<MessageDestinationRefType<ServiceBeanType<T>>> getAllMessageDestinationRef()
   {
      List<MessageDestinationRefType<ServiceBeanType<T>>> list = new ArrayList<MessageDestinationRefType<ServiceBeanType<T>>>();
      List<Node> nodeList = childNode.get("message-destination-ref");
      for(Node node: nodeList)
      {
         MessageDestinationRefType<ServiceBeanType<T>>  type = new MessageDestinationRefTypeImpl<ServiceBeanType<T>>(this, "message-destination-ref", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>message-destination-ref</code> elements 
    * @return the current instance of <code>MessageDestinationRefType<ServiceBeanType<T>></code> 
    */
   public ServiceBeanType<T> removeAllMessageDestinationRef()
   {
      childNode.removeChildren("message-destination-ref");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: jboss:persistence-context-refType ElementType : persistence-context-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>persistence-context-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>persistence-context-ref</code> element will be returned.
    * @return the instance defined for the element <code>persistence-context-ref</code> 
    */
   public PersistenceContextRefType<ServiceBeanType<T>> getOrCreatePersistenceContextRef()
   {
      List<Node> nodeList = childNode.get("persistence-context-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new PersistenceContextRefTypeImpl<ServiceBeanType<T>>(this, "persistence-context-ref", childNode, nodeList.get(0));
      }
      return createPersistenceContextRef();
   }

   /**
    * Creates a new <code>persistence-context-ref</code> element 
    * @return the new created instance of <code>PersistenceContextRefType<ServiceBeanType<T>></code> 
    */
   public PersistenceContextRefType<ServiceBeanType<T>> createPersistenceContextRef()
   {
      return new PersistenceContextRefTypeImpl<ServiceBeanType<T>>(this, "persistence-context-ref", childNode);
   }

   /**
    * Returns all <code>persistence-context-ref</code> elements
    * @return list of <code>persistence-context-ref</code> 
    */
   public List<PersistenceContextRefType<ServiceBeanType<T>>> getAllPersistenceContextRef()
   {
      List<PersistenceContextRefType<ServiceBeanType<T>>> list = new ArrayList<PersistenceContextRefType<ServiceBeanType<T>>>();
      List<Node> nodeList = childNode.get("persistence-context-ref");
      for(Node node: nodeList)
      {
         PersistenceContextRefType<ServiceBeanType<T>>  type = new PersistenceContextRefTypeImpl<ServiceBeanType<T>>(this, "persistence-context-ref", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>persistence-context-ref</code> elements 
    * @return the current instance of <code>PersistenceContextRefType<ServiceBeanType<T>></code> 
    */
   public ServiceBeanType<T> removeAllPersistenceContextRef()
   {
      childNode.removeChildren("persistence-context-ref");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: jboss:persistence-unit-refType ElementType : persistence-unit-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>persistence-unit-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>persistence-unit-ref</code> element will be returned.
    * @return the instance defined for the element <code>persistence-unit-ref</code> 
    */
   public PersistenceUnitRefType<ServiceBeanType<T>> getOrCreatePersistenceUnitRef()
   {
      List<Node> nodeList = childNode.get("persistence-unit-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new PersistenceUnitRefTypeImpl<ServiceBeanType<T>>(this, "persistence-unit-ref", childNode, nodeList.get(0));
      }
      return createPersistenceUnitRef();
   }

   /**
    * Creates a new <code>persistence-unit-ref</code> element 
    * @return the new created instance of <code>PersistenceUnitRefType<ServiceBeanType<T>></code> 
    */
   public PersistenceUnitRefType<ServiceBeanType<T>> createPersistenceUnitRef()
   {
      return new PersistenceUnitRefTypeImpl<ServiceBeanType<T>>(this, "persistence-unit-ref", childNode);
   }

   /**
    * Returns all <code>persistence-unit-ref</code> elements
    * @return list of <code>persistence-unit-ref</code> 
    */
   public List<PersistenceUnitRefType<ServiceBeanType<T>>> getAllPersistenceUnitRef()
   {
      List<PersistenceUnitRefType<ServiceBeanType<T>>> list = new ArrayList<PersistenceUnitRefType<ServiceBeanType<T>>>();
      List<Node> nodeList = childNode.get("persistence-unit-ref");
      for(Node node: nodeList)
      {
         PersistenceUnitRefType<ServiceBeanType<T>>  type = new PersistenceUnitRefTypeImpl<ServiceBeanType<T>>(this, "persistence-unit-ref", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>persistence-unit-ref</code> elements 
    * @return the current instance of <code>PersistenceUnitRefType<ServiceBeanType<T>></code> 
    */
   public ServiceBeanType<T> removeAllPersistenceUnitRef()
   {
      childNode.removeChildren("persistence-unit-ref");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: jboss:lifecycle-callbackType ElementType : post-construct
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>post-construct</code> element will be created and returned.
    * Otherwise, the first existing <code>post-construct</code> element will be returned.
    * @return the instance defined for the element <code>post-construct</code> 
    */
   public LifecycleCallbackType<ServiceBeanType<T>> getOrCreatePostConstruct()
   {
      List<Node> nodeList = childNode.get("post-construct");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new LifecycleCallbackTypeImpl<ServiceBeanType<T>>(this, "post-construct", childNode, nodeList.get(0));
      }
      return createPostConstruct();
   }

   /**
    * Creates a new <code>post-construct</code> element 
    * @return the new created instance of <code>LifecycleCallbackType<ServiceBeanType<T>></code> 
    */
   public LifecycleCallbackType<ServiceBeanType<T>> createPostConstruct()
   {
      return new LifecycleCallbackTypeImpl<ServiceBeanType<T>>(this, "post-construct", childNode);
   }

   /**
    * Returns all <code>post-construct</code> elements
    * @return list of <code>post-construct</code> 
    */
   public List<LifecycleCallbackType<ServiceBeanType<T>>> getAllPostConstruct()
   {
      List<LifecycleCallbackType<ServiceBeanType<T>>> list = new ArrayList<LifecycleCallbackType<ServiceBeanType<T>>>();
      List<Node> nodeList = childNode.get("post-construct");
      for(Node node: nodeList)
      {
         LifecycleCallbackType<ServiceBeanType<T>>  type = new LifecycleCallbackTypeImpl<ServiceBeanType<T>>(this, "post-construct", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>post-construct</code> elements 
    * @return the current instance of <code>LifecycleCallbackType<ServiceBeanType<T>></code> 
    */
   public ServiceBeanType<T> removeAllPostConstruct()
   {
      childNode.removeChildren("post-construct");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: jboss:lifecycle-callbackType ElementType : pre-destroy
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>pre-destroy</code> element will be created and returned.
    * Otherwise, the first existing <code>pre-destroy</code> element will be returned.
    * @return the instance defined for the element <code>pre-destroy</code> 
    */
   public LifecycleCallbackType<ServiceBeanType<T>> getOrCreatePreDestroy()
   {
      List<Node> nodeList = childNode.get("pre-destroy");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new LifecycleCallbackTypeImpl<ServiceBeanType<T>>(this, "pre-destroy", childNode, nodeList.get(0));
      }
      return createPreDestroy();
   }

   /**
    * Creates a new <code>pre-destroy</code> element 
    * @return the new created instance of <code>LifecycleCallbackType<ServiceBeanType<T>></code> 
    */
   public LifecycleCallbackType<ServiceBeanType<T>> createPreDestroy()
   {
      return new LifecycleCallbackTypeImpl<ServiceBeanType<T>>(this, "pre-destroy", childNode);
   }

   /**
    * Returns all <code>pre-destroy</code> elements
    * @return list of <code>pre-destroy</code> 
    */
   public List<LifecycleCallbackType<ServiceBeanType<T>>> getAllPreDestroy()
   {
      List<LifecycleCallbackType<ServiceBeanType<T>>> list = new ArrayList<LifecycleCallbackType<ServiceBeanType<T>>>();
      List<Node> nodeList = childNode.get("pre-destroy");
      for(Node node: nodeList)
      {
         LifecycleCallbackType<ServiceBeanType<T>>  type = new LifecycleCallbackTypeImpl<ServiceBeanType<T>>(this, "pre-destroy", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>pre-destroy</code> elements 
    * @return the current instance of <code>LifecycleCallbackType<ServiceBeanType<T>></code> 
    */
   public ServiceBeanType<T> removeAllPreDestroy()
   {
      childNode.removeChildren("pre-destroy");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: jboss:service-refType ElementType : service-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>service-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>service-ref</code> element will be returned.
    * @return the instance defined for the element <code>service-ref</code> 
    */
   public ServiceRefType<ServiceBeanType<T>> getOrCreateServiceRef()
   {
      List<Node> nodeList = childNode.get("service-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ServiceRefTypeImpl<ServiceBeanType<T>>(this, "service-ref", childNode, nodeList.get(0));
      }
      return createServiceRef();
   }

   /**
    * Creates a new <code>service-ref</code> element 
    * @return the new created instance of <code>ServiceRefType<ServiceBeanType<T>></code> 
    */
   public ServiceRefType<ServiceBeanType<T>> createServiceRef()
   {
      return new ServiceRefTypeImpl<ServiceBeanType<T>>(this, "service-ref", childNode);
   }

   /**
    * Returns all <code>service-ref</code> elements
    * @return list of <code>service-ref</code> 
    */
   public List<ServiceRefType<ServiceBeanType<T>>> getAllServiceRef()
   {
      List<ServiceRefType<ServiceBeanType<T>>> list = new ArrayList<ServiceRefType<ServiceBeanType<T>>>();
      List<Node> nodeList = childNode.get("service-ref");
      for(Node node: nodeList)
      {
         ServiceRefType<ServiceBeanType<T>>  type = new ServiceRefTypeImpl<ServiceBeanType<T>>(this, "service-ref", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>service-ref</code> elements 
    * @return the current instance of <code>ServiceRefType<ServiceBeanType<T>></code> 
    */
   public ServiceBeanType<T> removeAllServiceRef()
   {
      childNode.removeChildren("service-ref");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: javaee:xsdNMTOKENType ElementType : ejb-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>ejb-name</code> element
    * @param ejbName the value for the element <code>ejb-name</code> 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> ejbName(String ejbName)
   {
      childNode.getOrCreate("ejb-name").text(ejbName);
      return this;
   }

   /**
    * Returns the <code>ejb-name</code> element
    * @return the node defined for the element <code>ejb-name</code> 
    */
   public String getEjbName()
   {
      return childNode.getTextValueForPatternName("ejb-name");
   }

   /**
    * Removes the <code>ejb-name</code> element 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removeEjbName()
   {
      childNode.removeChildren("ejb-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: xsd:string ElementType : mapped-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>mapped-name</code> element
    * @param mappedName the value for the element <code>mapped-name</code> 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> mappedName(String mappedName)
   {
      childNode.getOrCreate("mapped-name").text(mappedName);
      return this;
   }

   /**
    * Returns the <code>mapped-name</code> element
    * @return the node defined for the element <code>mapped-name</code> 
    */
   public String getMappedName()
   {
      return childNode.getTextValueForPatternName("mapped-name");
   }

   /**
    * Removes the <code>mapped-name</code> element 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removeMappedName()
   {
      childNode.removeChildren("mapped-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: xsd:token ElementType : business-local
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>business-local</code> elements, 
    * a new <code>business-local</code> element 
    * @param values list of <code>business-local</code> objects 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> businessLocal(String ... values)
   {
      if (values != null)
      {
         for(String name: values)
         {
            childNode.createChild("business-local").text(name);
         }
      }
      return this;
   }

   /**
    * Returns all <code>business-local</code> elements
    * @return list of <code>business-local</code> 
    */
public List<String> getAllBusinessLocal()
   {
      List<String> result = new ArrayList<String>();
      List<Node> nodes = childNode.get("business-local");
      for (Node node : nodes)
      {
         result.add(node.getText());
      }
      return result;
   }

   /**
    * Removes the <code>business-local</code> element 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removeAllBusinessLocal()
   {
      childNode.removeChildren("business-local");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: xsd:token ElementType : business-remote
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>business-remote</code> elements, 
    * a new <code>business-remote</code> element 
    * @param values list of <code>business-remote</code> objects 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> businessRemote(String ... values)
   {
      if (values != null)
      {
         for(String name: values)
         {
            childNode.createChild("business-remote").text(name);
         }
      }
      return this;
   }

   /**
    * Returns all <code>business-remote</code> elements
    * @return list of <code>business-remote</code> 
    */
public List<String> getAllBusinessRemote()
   {
      List<String> result = new ArrayList<String>();
      List<Node> nodes = childNode.get("business-remote");
      for (Node node : nodes)
      {
         result.add(node.getText());
      }
      return result;
   }

   /**
    * Removes the <code>business-remote</code> element 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removeAllBusinessRemote()
   {
      childNode.removeChildren("business-remote");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: javaee:fully-qualified-classType ElementType : ejb-class
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>ejb-class</code> element
    * @param ejbClass the value for the element <code>ejb-class</code> 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> ejbClass(String ejbClass)
   {
      childNode.getOrCreate("ejb-class").text(ejbClass);
      return this;
   }

   /**
    * Returns the <code>ejb-class</code> element
    * @return the node defined for the element <code>ejb-class</code> 
    */
   public String getEjbClass()
   {
      return childNode.getTextValueForPatternName("ejb-class");
   }

   /**
    * Removes the <code>ejb-class</code> element 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removeEjbClass()
   {
      childNode.removeChildren("ejb-class");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: jboss:security-identityType ElementType : security-identity
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>security-identity</code> element with the given value will be created.
    * Otherwise, the existing <code>security-identity</code> element will be returned.
    * @return  a new or existing instance of <code>SecurityIdentityType<ServiceBeanType<T>></code> 
    */
   public SecurityIdentityType<ServiceBeanType<T>> getOrCreateSecurityIdentity()
   {
      Node node = childNode.getOrCreate("security-identity");
      SecurityIdentityType<ServiceBeanType<T>> securityIdentity = new SecurityIdentityTypeImpl<ServiceBeanType<T>>(this, "security-identity", childNode, node);
      return securityIdentity;
   }

   /**
    * Removes the <code>security-identity</code> element 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removeSecurityIdentity()
   {
      childNode.removeChildren("security-identity");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: xsd:token ElementType : object-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>object-name</code> element
    * @param objectName the value for the element <code>object-name</code> 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> objectName(String objectName)
   {
      childNode.getOrCreate("object-name").text(objectName);
      return this;
   }

   /**
    * Returns the <code>object-name</code> element
    * @return the node defined for the element <code>object-name</code> 
    */
   public String getObjectName()
   {
      return childNode.getTextValueForPatternName("object-name");
   }

   /**
    * Removes the <code>object-name</code> element 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removeObjectName()
   {
      childNode.removeChildren("object-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: javaee:string ElementType : management
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>management</code> element
    * @param management the value for the element <code>management</code> 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> management(String management)
   {
      childNode.getOrCreate("management").text(management);
      return this;
   }

   /**
    * Returns the <code>management</code> element
    * @return the node defined for the element <code>management</code> 
    */
   public String getManagement()
   {
      return childNode.getTextValueForPatternName("management");
   }

   /**
    * Removes the <code>management</code> element 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removeManagement()
   {
      childNode.removeChildren("management");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: javaee:string ElementType : xmbean
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>xmbean</code> element
    * @param xmbean the value for the element <code>xmbean</code> 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> xmbean(String xmbean)
   {
      childNode.getOrCreate("xmbean").text(xmbean);
      return this;
   }

   /**
    * Returns the <code>xmbean</code> element
    * @return the node defined for the element <code>xmbean</code> 
    */
   public String getXmbean()
   {
      return childNode.getTextValueForPatternName("xmbean");
   }

   /**
    * Removes the <code>xmbean</code> element 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removeXmbean()
   {
      childNode.removeChildren("xmbean");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: jboss:local-bindingType ElementType : local-binding
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>local-binding</code> element will be created and returned.
    * Otherwise, the first existing <code>local-binding</code> element will be returned.
    * @return the instance defined for the element <code>local-binding</code> 
    */
   public LocalBindingType<ServiceBeanType<T>> getOrCreateLocalBinding()
   {
      List<Node> nodeList = childNode.get("local-binding");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new LocalBindingTypeImpl<ServiceBeanType<T>>(this, "local-binding", childNode, nodeList.get(0));
      }
      return createLocalBinding();
   }

   /**
    * Creates a new <code>local-binding</code> element 
    * @return the new created instance of <code>LocalBindingType<ServiceBeanType<T>></code> 
    */
   public LocalBindingType<ServiceBeanType<T>> createLocalBinding()
   {
      return new LocalBindingTypeImpl<ServiceBeanType<T>>(this, "local-binding", childNode);
   }

   /**
    * Returns all <code>local-binding</code> elements
    * @return list of <code>local-binding</code> 
    */
   public List<LocalBindingType<ServiceBeanType<T>>> getAllLocalBinding()
   {
      List<LocalBindingType<ServiceBeanType<T>>> list = new ArrayList<LocalBindingType<ServiceBeanType<T>>>();
      List<Node> nodeList = childNode.get("local-binding");
      for(Node node: nodeList)
      {
         LocalBindingType<ServiceBeanType<T>>  type = new LocalBindingTypeImpl<ServiceBeanType<T>>(this, "local-binding", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>local-binding</code> elements 
    * @return the current instance of <code>LocalBindingType<ServiceBeanType<T>></code> 
    */
   public ServiceBeanType<T> removeAllLocalBinding()
   {
      childNode.removeChildren("local-binding");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: jboss:remote-bindingType ElementType : remote-binding
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>remote-binding</code> element will be created and returned.
    * Otherwise, the first existing <code>remote-binding</code> element will be returned.
    * @return the instance defined for the element <code>remote-binding</code> 
    */
   public RemoteBindingType<ServiceBeanType<T>> getOrCreateRemoteBinding()
   {
      List<Node> nodeList = childNode.get("remote-binding");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new RemoteBindingTypeImpl<ServiceBeanType<T>>(this, "remote-binding", childNode, nodeList.get(0));
      }
      return createRemoteBinding();
   }

   /**
    * Creates a new <code>remote-binding</code> element 
    * @return the new created instance of <code>RemoteBindingType<ServiceBeanType<T>></code> 
    */
   public RemoteBindingType<ServiceBeanType<T>> createRemoteBinding()
   {
      return new RemoteBindingTypeImpl<ServiceBeanType<T>>(this, "remote-binding", childNode);
   }

   /**
    * Returns all <code>remote-binding</code> elements
    * @return list of <code>remote-binding</code> 
    */
   public List<RemoteBindingType<ServiceBeanType<T>>> getAllRemoteBinding()
   {
      List<RemoteBindingType<ServiceBeanType<T>>> list = new ArrayList<RemoteBindingType<ServiceBeanType<T>>>();
      List<Node> nodeList = childNode.get("remote-binding");
      for(Node node: nodeList)
      {
         RemoteBindingType<ServiceBeanType<T>>  type = new RemoteBindingTypeImpl<ServiceBeanType<T>>(this, "remote-binding", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>remote-binding</code> elements 
    * @return the current instance of <code>RemoteBindingType<ServiceBeanType<T>></code> 
    */
   public ServiceBeanType<T> removeAllRemoteBinding()
   {
      childNode.removeChildren("remote-binding");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: xsd:token ElementType : jndi-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>jndi-name</code> element
    * @param jndiName the value for the element <code>jndi-name</code> 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> jndiName(String jndiName)
   {
      childNode.getOrCreate("jndi-name").text(jndiName);
      return this;
   }

   /**
    * Returns the <code>jndi-name</code> element
    * @return the node defined for the element <code>jndi-name</code> 
    */
   public String getJndiName()
   {
      return childNode.getTextValueForPatternName("jndi-name");
   }

   /**
    * Removes the <code>jndi-name</code> element 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removeJndiName()
   {
      childNode.removeChildren("jndi-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: xsd:token ElementType : home-jndi-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>home-jndi-name</code> element
    * @param homeJndiName the value for the element <code>home-jndi-name</code> 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> homeJndiName(String homeJndiName)
   {
      childNode.getOrCreate("home-jndi-name").text(homeJndiName);
      return this;
   }

   /**
    * Returns the <code>home-jndi-name</code> element
    * @return the node defined for the element <code>home-jndi-name</code> 
    */
   public String getHomeJndiName()
   {
      return childNode.getTextValueForPatternName("home-jndi-name");
   }

   /**
    * Removes the <code>home-jndi-name</code> element 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removeHomeJndiName()
   {
      childNode.removeChildren("home-jndi-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: xsd:token ElementType : local-jndi-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>local-jndi-name</code> element
    * @param localJndiName the value for the element <code>local-jndi-name</code> 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> localJndiName(String localJndiName)
   {
      childNode.getOrCreate("local-jndi-name").text(localJndiName);
      return this;
   }

   /**
    * Returns the <code>local-jndi-name</code> element
    * @return the node defined for the element <code>local-jndi-name</code> 
    */
   public String getLocalJndiName()
   {
      return childNode.getTextValueForPatternName("local-jndi-name");
   }

   /**
    * Removes the <code>local-jndi-name</code> element 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removeLocalJndiName()
   {
      childNode.removeChildren("local-jndi-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: xsd:token ElementType : jndi-binding-policy
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>jndi-binding-policy</code> element
    * @param jndiBindingPolicy the value for the element <code>jndi-binding-policy</code> 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> jndiBindingPolicy(String jndiBindingPolicy)
   {
      childNode.getOrCreate("jndi-binding-policy").text(jndiBindingPolicy);
      return this;
   }

   /**
    * Returns the <code>jndi-binding-policy</code> element
    * @return the node defined for the element <code>jndi-binding-policy</code> 
    */
   public String getJndiBindingPolicy()
   {
      return childNode.getTextValueForPatternName("jndi-binding-policy");
   }

   /**
    * Removes the <code>jndi-binding-policy</code> element 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removeJndiBindingPolicy()
   {
      childNode.removeChildren("jndi-binding-policy");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: javaee:true-falseType ElementType : clustered
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>clustered</code> element
    * @param clustered the value for the element <code>clustered</code> 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> clustered(String clustered)
   {
      childNode.getOrCreate("clustered").text(clustered);
      return this;
   }

   /**
    * Returns the <code>clustered</code> element
    * @return the node defined for the element <code>clustered</code> 
    */
   public String getClustered()
   {
      return childNode.getTextValueForPatternName("clustered");
   }

   /**
    * Removes the <code>clustered</code> element 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removeClustered()
   {
      childNode.removeChildren("clustered");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: jboss:cluster-configType ElementType : cluster-config
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>cluster-config</code> element with the given value will be created.
    * Otherwise, the existing <code>cluster-config</code> element will be returned.
    * @return  a new or existing instance of <code>ClusterConfigType<ServiceBeanType<T>></code> 
    */
   public ClusterConfigType<ServiceBeanType<T>> getOrCreateClusterConfig()
   {
      Node node = childNode.getOrCreate("cluster-config");
      ClusterConfigType<ServiceBeanType<T>> clusterConfig = new ClusterConfigTypeImpl<ServiceBeanType<T>>(this, "cluster-config", childNode, node);
      return clusterConfig;
   }

   /**
    * Removes the <code>cluster-config</code> element 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removeClusterConfig()
   {
      childNode.removeChildren("cluster-config");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: xsd:string ElementType : security-domain
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>security-domain</code> element
    * @param securityDomain the value for the element <code>security-domain</code> 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> securityDomain(String securityDomain)
   {
      childNode.getOrCreate("security-domain").text(securityDomain);
      return this;
   }

   /**
    * Returns the <code>security-domain</code> element
    * @return the node defined for the element <code>security-domain</code> 
    */
   public String getSecurityDomain()
   {
      return childNode.getTextValueForPatternName("security-domain");
   }

   /**
    * Removes the <code>security-domain</code> element 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removeSecurityDomain()
   {
      childNode.removeChildren("security-domain");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: jboss:method-attributesType ElementType : method-attributes
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>method-attributes</code> element with the given value will be created.
    * Otherwise, the existing <code>method-attributes</code> element will be returned.
    * @return  a new or existing instance of <code>MethodAttributesType<ServiceBeanType<T>></code> 
    */
   public MethodAttributesType<ServiceBeanType<T>> getOrCreateMethodAttributes()
   {
      Node node = childNode.getOrCreate("method-attributes");
      MethodAttributesType<ServiceBeanType<T>> methodAttributes = new MethodAttributesTypeImpl<ServiceBeanType<T>>(this, "method-attributes", childNode, node);
      return methodAttributes;
   }

   /**
    * Removes the <code>method-attributes</code> element 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removeMethodAttributes()
   {
      childNode.removeChildren("method-attributes");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: xsd:string ElementType : depends
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>depends</code> elements, 
    * a new <code>depends</code> element 
    * @param values list of <code>depends</code> objects 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> depends(String ... values)
   {
      if (values != null)
      {
         for(String name: values)
         {
            childNode.createChild("depends").text(name);
         }
      }
      return this;
   }

   /**
    * Returns all <code>depends</code> elements
    * @return list of <code>depends</code> 
    */
public List<String> getAllDepends()
   {
      List<String> result = new ArrayList<String>();
      List<Node> nodes = childNode.get("depends");
      for (Node node : nodes)
      {
         result.add(node.getText());
      }
      return result;
   }

   /**
    * Removes the <code>depends</code> element 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removeAllDepends()
   {
      childNode.removeChildren("depends");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: jboss:annotationType ElementType : annotation
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>annotation</code> element will be created and returned.
    * Otherwise, the first existing <code>annotation</code> element will be returned.
    * @return the instance defined for the element <code>annotation</code> 
    */
   public AnnotationType<ServiceBeanType<T>> getOrCreateAnnotation()
   {
      List<Node> nodeList = childNode.get("annotation");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new AnnotationTypeImpl<ServiceBeanType<T>>(this, "annotation", childNode, nodeList.get(0));
      }
      return createAnnotation();
   }

   /**
    * Creates a new <code>annotation</code> element 
    * @return the new created instance of <code>AnnotationType<ServiceBeanType<T>></code> 
    */
   public AnnotationType<ServiceBeanType<T>> createAnnotation()
   {
      return new AnnotationTypeImpl<ServiceBeanType<T>>(this, "annotation", childNode);
   }

   /**
    * Returns all <code>annotation</code> elements
    * @return list of <code>annotation</code> 
    */
   public List<AnnotationType<ServiceBeanType<T>>> getAllAnnotation()
   {
      List<AnnotationType<ServiceBeanType<T>>> list = new ArrayList<AnnotationType<ServiceBeanType<T>>>();
      List<Node> nodeList = childNode.get("annotation");
      for(Node node: nodeList)
      {
         AnnotationType<ServiceBeanType<T>>  type = new AnnotationTypeImpl<ServiceBeanType<T>>(this, "annotation", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>annotation</code> elements 
    * @return the current instance of <code>AnnotationType<ServiceBeanType<T>></code> 
    */
   public ServiceBeanType<T> removeAllAnnotation()
   {
      childNode.removeChildren("annotation");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: jboss:ignore-dependencyType ElementType : ignore-dependency
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>ignore-dependency</code> element with the given value will be created.
    * Otherwise, the existing <code>ignore-dependency</code> element will be returned.
    * @return  a new or existing instance of <code>IgnoreDependencyType<ServiceBeanType<T>></code> 
    */
   public IgnoreDependencyType<ServiceBeanType<T>> getOrCreateIgnoreDependency()
   {
      Node node = childNode.getOrCreate("ignore-dependency");
      IgnoreDependencyType<ServiceBeanType<T>> ignoreDependency = new IgnoreDependencyTypeImpl<ServiceBeanType<T>>(this, "ignore-dependency", childNode, node);
      return ignoreDependency;
   }

   /**
    * Removes the <code>ignore-dependency</code> element 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removeIgnoreDependency()
   {
      childNode.removeChildren("ignore-dependency");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: javaee:string ElementType : aop-domain-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>aop-domain-name</code> element
    * @param aopDomainName the value for the element <code>aop-domain-name</code> 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> aopDomainName(String aopDomainName)
   {
      childNode.getOrCreate("aop-domain-name").text(aopDomainName);
      return this;
   }

   /**
    * Returns the <code>aop-domain-name</code> element
    * @return the node defined for the element <code>aop-domain-name</code> 
    */
   public String getAopDomainName()
   {
      return childNode.getTextValueForPatternName("aop-domain-name");
   }

   /**
    * Removes the <code>aop-domain-name</code> element 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removeAopDomainName()
   {
      childNode.removeChildren("aop-domain-name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: jboss:pool-configType ElementType : pool-config
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>pool-config</code> element with the given value will be created.
    * Otherwise, the existing <code>pool-config</code> element will be returned.
    * @return  a new or existing instance of <code>PoolConfigType<ServiceBeanType<T>></code> 
    */
   public PoolConfigType<ServiceBeanType<T>> getOrCreatePoolConfig()
   {
      Node node = childNode.getOrCreate("pool-config");
      PoolConfigType<ServiceBeanType<T>> poolConfig = new PoolConfigTypeImpl<ServiceBeanType<T>>(this, "pool-config", childNode, node);
      return poolConfig;
   }

   /**
    * Removes the <code>pool-config</code> element 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removePoolConfig()
   {
      childNode.removeChildren("pool-config");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: javaee:true-falseType ElementType : concurrent
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>concurrent</code> element
    * @param concurrent the value for the element <code>concurrent</code> 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> concurrent(String concurrent)
   {
      childNode.getOrCreate("concurrent").text(concurrent);
      return this;
   }

   /**
    * Returns the <code>concurrent</code> element
    * @return the node defined for the element <code>concurrent</code> 
    */
   public String getConcurrent()
   {
      return childNode.getTextValueForPatternName("concurrent");
   }

   /**
    * Removes the <code>concurrent</code> element 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removeConcurrent()
   {
      childNode.removeChildren("concurrent");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: jboss:jndi-refType ElementType : jndi-ref
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>jndi-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>jndi-ref</code> element will be returned.
    * @return the instance defined for the element <code>jndi-ref</code> 
    */
   public JndiRefType<ServiceBeanType<T>> getOrCreateJndiRef()
   {
      List<Node> nodeList = childNode.get("jndi-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new JndiRefTypeImpl<ServiceBeanType<T>>(this, "jndi-ref", childNode, nodeList.get(0));
      }
      return createJndiRef();
   }

   /**
    * Creates a new <code>jndi-ref</code> element 
    * @return the new created instance of <code>JndiRefType<ServiceBeanType<T>></code> 
    */
   public JndiRefType<ServiceBeanType<T>> createJndiRef()
   {
      return new JndiRefTypeImpl<ServiceBeanType<T>>(this, "jndi-ref", childNode);
   }

   /**
    * Returns all <code>jndi-ref</code> elements
    * @return list of <code>jndi-ref</code> 
    */
   public List<JndiRefType<ServiceBeanType<T>>> getAllJndiRef()
   {
      List<JndiRefType<ServiceBeanType<T>>> list = new ArrayList<JndiRefType<ServiceBeanType<T>>>();
      List<Node> nodeList = childNode.get("jndi-ref");
      for(Node node: nodeList)
      {
         JndiRefType<ServiceBeanType<T>>  type = new JndiRefTypeImpl<ServiceBeanType<T>>(this, "jndi-ref", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>jndi-ref</code> elements 
    * @return the current instance of <code>JndiRefType<ServiceBeanType<T>></code> 
    */
   public ServiceBeanType<T> removeAllJndiRef()
   {
      childNode.removeChildren("jndi-ref");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: jboss:port-componentType ElementType : port-component
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>port-component</code> element with the given value will be created.
    * Otherwise, the existing <code>port-component</code> element will be returned.
    * @return  a new or existing instance of <code>PortComponentType<ServiceBeanType<T>></code> 
    */
   public PortComponentType<ServiceBeanType<T>> getOrCreatePortComponent()
   {
      Node node = childNode.getOrCreate("port-component");
      PortComponentType<ServiceBeanType<T>> portComponent = new PortComponentTypeImpl<ServiceBeanType<T>>(this, "port-component", childNode, node);
      return portComponent;
   }

   /**
    * Removes the <code>port-component</code> element 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removePortComponent()
   {
      childNode.removeChildren("port-component");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: jboss:security-identityType ElementType : ejb-timeout-identity
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>ejb-timeout-identity</code> element with the given value will be created.
    * Otherwise, the existing <code>ejb-timeout-identity</code> element will be returned.
    * @return  a new or existing instance of <code>SecurityIdentityType<ServiceBeanType<T>></code> 
    */
   public SecurityIdentityType<ServiceBeanType<T>> getOrCreateEjbTimeoutIdentity()
   {
      Node node = childNode.getOrCreate("ejb-timeout-identity");
      SecurityIdentityType<ServiceBeanType<T>> ejbTimeoutIdentity = new SecurityIdentityTypeImpl<ServiceBeanType<T>>(this, "ejb-timeout-identity", childNode, node);
      return ejbTimeoutIdentity;
   }

   /**
    * Removes the <code>ejb-timeout-identity</code> element 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removeEjbTimeoutIdentity()
   {
      childNode.removeChildren("ejb-timeout-identity");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServiceBeanType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> id(String id)
   {
      childNode.attribute("id", id);
      return this;
   }

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
      public String getId()
   {
      return childNode.getAttribute("id");
   }

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>ServiceBeanType<T></code> 
    */
   public ServiceBeanType<T> removeId()
   {
      childNode.removeAttribute("id");
      return this;
   }
}
