package org.jboss.shrinkwrap.descriptor.impl.jbossdeployment10; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.DeploymentType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.FilterType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment10.FilterTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.DependenciesType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment10.DependenciesTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.ExclusionsType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment10.ExclusionsTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.ResourcesType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment10.ResourcesTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.TransformerSetType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment10.TransformerSetTypeImpl;

/**
 * This class implements the <code> deploymentType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class DeploymentTypeImpl<T> implements Child<T>, DeploymentType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public DeploymentTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public DeploymentTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DeploymentType ElementName: jboss:filterType ElementType : exports
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exports</code> element with the given value will be created.
    * Otherwise, the existing <code>exports</code> element will be returned.
    * @return  a new or existing instance of <code>FilterType<DeploymentType<T>></code> 
    */
   public FilterType<DeploymentType<T>> getOrCreateExports()
   {
      Node node = childNode.getOrCreate("exports");
      FilterType<DeploymentType<T>> exports = new FilterTypeImpl<DeploymentType<T>>(this, "exports", childNode, node);
      return exports;
   }

   /**
    * Removes the <code>exports</code> element 
    * @return the current instance of <code>DeploymentType<T></code> 
    */
   public DeploymentType<T> removeExports()
   {
      childNode.removeChildren("exports");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DeploymentType ElementName: jboss:dependenciesType ElementType : dependencies
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>dependencies</code> element with the given value will be created.
    * Otherwise, the existing <code>dependencies</code> element will be returned.
    * @return  a new or existing instance of <code>DependenciesType<DeploymentType<T>></code> 
    */
   public DependenciesType<DeploymentType<T>> getOrCreateDependencies()
   {
      Node node = childNode.getOrCreate("dependencies");
      DependenciesType<DeploymentType<T>> dependencies = new DependenciesTypeImpl<DeploymentType<T>>(this, "dependencies", childNode, node);
      return dependencies;
   }

   /**
    * Removes the <code>dependencies</code> element 
    * @return the current instance of <code>DeploymentType<T></code> 
    */
   public DeploymentType<T> removeDependencies()
   {
      childNode.removeChildren("dependencies");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DeploymentType ElementName: jboss:exclusionsType ElementType : exclusions
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exclusions</code> element with the given value will be created.
    * Otherwise, the existing <code>exclusions</code> element will be returned.
    * @return  a new or existing instance of <code>ExclusionsType<DeploymentType<T>></code> 
    */
   public ExclusionsType<DeploymentType<T>> getOrCreateExclusions()
   {
      Node node = childNode.getOrCreate("exclusions");
      ExclusionsType<DeploymentType<T>> exclusions = new ExclusionsTypeImpl<DeploymentType<T>>(this, "exclusions", childNode, node);
      return exclusions;
   }

   /**
    * Removes the <code>exclusions</code> element 
    * @return the current instance of <code>DeploymentType<T></code> 
    */
   public DeploymentType<T> removeExclusions()
   {
      childNode.removeChildren("exclusions");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DeploymentType ElementName: jboss:resourcesType ElementType : resources
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resources</code> element with the given value will be created.
    * Otherwise, the existing <code>resources</code> element will be returned.
    * @return  a new or existing instance of <code>ResourcesType<DeploymentType<T>></code> 
    */
   public ResourcesType<DeploymentType<T>> getOrCreateResources()
   {
      Node node = childNode.getOrCreate("resources");
      ResourcesType<DeploymentType<T>> resources = new ResourcesTypeImpl<DeploymentType<T>>(this, "resources", childNode, node);
      return resources;
   }

   /**
    * Removes the <code>resources</code> element 
    * @return the current instance of <code>DeploymentType<T></code> 
    */
   public DeploymentType<T> removeResources()
   {
      childNode.removeChildren("resources");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DeploymentType ElementName: jboss:transformerSetType ElementType : transformers
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>transformers</code> element with the given value will be created.
    * Otherwise, the existing <code>transformers</code> element will be returned.
    * @return  a new or existing instance of <code>TransformerSetType<DeploymentType<T>></code> 
    */
   public TransformerSetType<DeploymentType<T>> getOrCreateTransformers()
   {
      Node node = childNode.getOrCreate("transformers");
      TransformerSetType<DeploymentType<T>> transformers = new TransformerSetTypeImpl<DeploymentType<T>>(this, "transformers", childNode, node);
      return transformers;
   }

   /**
    * Removes the <code>transformers</code> element 
    * @return the current instance of <code>DeploymentType<T></code> 
    */
   public DeploymentType<T> removeTransformers()
   {
      childNode.removeChildren("transformers");
      return this;
   }
}
