package org.jboss.shrinkwrap.descriptor.impl.jbossdeployment11; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment11.ResourcesType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment11.ResourceType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment11.ResourceTypeImpl;

/**
 * This class implements the <code> resourcesType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class ResourcesTypeImpl<T> implements Child<T>, ResourcesType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public ResourcesTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public ResourcesTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourcesType ElementName: jboss:resourceType ElementType : resource-root
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resource-root</code> element will be created and returned.
    * Otherwise, the first existing <code>resource-root</code> element will be returned.
    * @return the instance defined for the element <code>resource-root</code> 
    */
   public ResourceType<ResourcesType<T>> getOrCreateResourceRoot()
   {
      List<Node> nodeList = childNode.get("resource-root");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ResourceTypeImpl<ResourcesType<T>>(this, "resource-root", childNode, nodeList.get(0));
      }
      return createResourceRoot();
   }

   /**
    * Creates a new <code>resource-root</code> element 
    * @return the new created instance of <code>ResourceType<ResourcesType<T>></code> 
    */
   public ResourceType<ResourcesType<T>> createResourceRoot()
   {
      return new ResourceTypeImpl<ResourcesType<T>>(this, "resource-root", childNode);
   }

   /**
    * Returns all <code>resource-root</code> elements
    * @return list of <code>resource-root</code> 
    */
   public List<ResourceType<ResourcesType<T>>> getAllResourceRoot()
   {
      List<ResourceType<ResourcesType<T>>> list = new ArrayList<ResourceType<ResourcesType<T>>>();
      List<Node> nodeList = childNode.get("resource-root");
      for(Node node: nodeList)
      {
         ResourceType<ResourcesType<T>>  type = new ResourceTypeImpl<ResourcesType<T>>(this, "resource-root", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>resource-root</code> elements 
    * @return the current instance of <code>ResourceType<ResourcesType<T>></code> 
    */
   public ResourcesType<T> removeAllResourceRoot()
   {
      childNode.removeChildren("resource-root");
      return this;
   }
}
