package org.jboss.shrinkwrap.descriptor.impl.jbossmodule13; 

import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.ModuleDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.FilterType;
import org.jboss.shrinkwrap.descriptor.impl.jbossmodule13.FilterTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.DependenciesType;
import org.jboss.shrinkwrap.descriptor.impl.jbossmodule13.DependenciesTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.ResourcesType;
import org.jboss.shrinkwrap.descriptor.impl.jbossmodule13.ResourcesTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.ClassNameType;
import org.jboss.shrinkwrap.descriptor.impl.jbossmodule13.ClassNameTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.PropertyListType;
import org.jboss.shrinkwrap.descriptor.impl.jbossmodule13.PropertyListTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.PermissionsType;
import org.jboss.shrinkwrap.descriptor.impl.jbossmodule13.PermissionsTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.FilterType;
import org.jboss.shrinkwrap.descriptor.impl.jbossmodule13.FilterTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.DependenciesType;
import org.jboss.shrinkwrap.descriptor.impl.jbossmodule13.DependenciesTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.ResourcesType;
import org.jboss.shrinkwrap.descriptor.impl.jbossmodule13.ResourcesTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.ClassNameType;
import org.jboss.shrinkwrap.descriptor.impl.jbossmodule13.ClassNameTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.PropertyListType;
import org.jboss.shrinkwrap.descriptor.impl.jbossmodule13.PropertyListTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.PermissionsType;
import org.jboss.shrinkwrap.descriptor.impl.jbossmodule13.PermissionsTypeImpl;
import java.util.Map.Entry;

import org.jboss.shrinkwrap.descriptor.api.DescriptorNamespace;

import org.jboss.shrinkwrap.descriptor.spi.node.NodeDescriptorImplBase;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

/** 
 * <p> 
 * This deployment descriptor provides the functionalities as described in the  specification
 * <p> 
 * Example:
 * <p> 
 * <code> 
 *     ModuleDescriptor descriptor = Descriptors.create(ModuleDescriptor.class);
 * </code> 
 *
 *
 * @author <a href="mailto:tcrawley@redhat.com">Toby Crawley</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class ModuleDescriptorImpl extends NodeDescriptorImplBase implements DescriptorNamespace<ModuleDescriptor>, ModuleDescriptor
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private Node model;

   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public ModuleDescriptorImpl(String descriptorName)
   {
       this(descriptorName, new Node("module"));
   }

   public ModuleDescriptorImpl(String descriptorName, Node node)
   {
      super(descriptorName);
      this.model = node;
      addDefaultNamespaces();
   }

   // -------------------------------------------------------------------------------------||
   // Methods 
   // -------------------------------------------------------------------------------------||

   public Node getRootNode()
   {
      return model;
   }



   // -------------------------------------------------------------------------------------||
   // Namespace 
   // -------------------------------------------------------------------------------------||


   /**
    * Adds the default namespaces as defined in the specification 
    * @return the current instance of <code>ModuleDescriptor</code> 
    */
   public ModuleDescriptor addDefaultNamespaces()
   {
      addNamespace("xmlns", "urn:jboss:module:1.3");
     return this;
   }

   /**
    * Adds a new namespace 
    * @return the current instance of <code>ModuleDescriptor</code> 
    */
   public ModuleDescriptor addNamespace(String name, String value)
   {
      model.attribute(name, value);
      return this;
   }

   /**
    * Returns all defined namespaces. 
    * @return all defined namespaces 
    */
   public List<String> getNamespaces()
   {
      List<String> namespaceList = new ArrayList<String>();
      java.util.Map<String, String> attributes = model.getAttributes();
      for (Entry<String, String> e : attributes.entrySet())
      {
         final String name = e.getKey();
         final String value = e.getValue();
         if (value != null && value.startsWith("http://")) 
         {
            namespaceList.add(name + "=" + value);
         }
      }
      return namespaceList;
   }

   /**
    * Removes all existing namespaces. 
    * @return the current instance of <code>ModuleDescriptor</code> 
    */
   public ModuleDescriptor removeAllNamespaces()
   {
      List<String> nameSpaceKeys = new ArrayList<String>();
      java.util.Map<String, String> attributes = model.getAttributes();
      for (Entry<String, String> e : attributes.entrySet())
      {
         final String name = e.getKey();
         final String value = e.getValue();
         if (value != null && value.startsWith("http://")) 
         {
            nameSpaceKeys.add(name);
         }
      }
      for (String name: nameSpaceKeys)
      {
         model.removeAttribute(name);
      }
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDescriptor ElementName: jboss:filterType ElementType : exports
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exports</code> element with the given value will be created.
    * Otherwise, the existing <code>exports</code> element will be returned.
    * @return  a new or existing instance of <code>FilterType<ModuleDescriptor></code> 
    */
   public FilterType<ModuleDescriptor> getOrCreateExports()
   {
      Node node = model.getOrCreate("exports");
      FilterType<ModuleDescriptor> exports = new FilterTypeImpl<ModuleDescriptor>(this, "exports", model, node);
      return exports;
   }

   /**
    * Removes the <code>exports</code> element 
    * @return the current instance of <code>ModuleDescriptor</code> 
    */
   public ModuleDescriptor removeExports()
   {
      model.removeChildren("exports");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDescriptor ElementName: jboss:dependenciesType ElementType : dependencies
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>dependencies</code> element with the given value will be created.
    * Otherwise, the existing <code>dependencies</code> element will be returned.
    * @return  a new or existing instance of <code>DependenciesType<ModuleDescriptor></code> 
    */
   public DependenciesType<ModuleDescriptor> getOrCreateDependencies()
   {
      Node node = model.getOrCreate("dependencies");
      DependenciesType<ModuleDescriptor> dependencies = new DependenciesTypeImpl<ModuleDescriptor>(this, "dependencies", model, node);
      return dependencies;
   }

   /**
    * Removes the <code>dependencies</code> element 
    * @return the current instance of <code>ModuleDescriptor</code> 
    */
   public ModuleDescriptor removeDependencies()
   {
      model.removeChildren("dependencies");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDescriptor ElementName: jboss:resourcesType ElementType : resources
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resources</code> element with the given value will be created.
    * Otherwise, the existing <code>resources</code> element will be returned.
    * @return  a new or existing instance of <code>ResourcesType<ModuleDescriptor></code> 
    */
   public ResourcesType<ModuleDescriptor> getOrCreateResources()
   {
      Node node = model.getOrCreate("resources");
      ResourcesType<ModuleDescriptor> resources = new ResourcesTypeImpl<ModuleDescriptor>(this, "resources", model, node);
      return resources;
   }

   /**
    * Removes the <code>resources</code> element 
    * @return the current instance of <code>ModuleDescriptor</code> 
    */
   public ModuleDescriptor removeResources()
   {
      model.removeChildren("resources");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDescriptor ElementName: jboss:classNameType ElementType : main-class
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>main-class</code> element with the given value will be created.
    * Otherwise, the existing <code>main-class</code> element will be returned.
    * @return  a new or existing instance of <code>ClassNameType<ModuleDescriptor></code> 
    */
   public ClassNameType<ModuleDescriptor> getOrCreateMainClass()
   {
      Node node = model.getOrCreate("main-class");
      ClassNameType<ModuleDescriptor> mainClass = new ClassNameTypeImpl<ModuleDescriptor>(this, "main-class", model, node);
      return mainClass;
   }

   /**
    * Removes the <code>main-class</code> element 
    * @return the current instance of <code>ModuleDescriptor</code> 
    */
   public ModuleDescriptor removeMainClass()
   {
      model.removeChildren("main-class");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDescriptor ElementName: jboss:propertyListType ElementType : properties
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>properties</code> element with the given value will be created.
    * Otherwise, the existing <code>properties</code> element will be returned.
    * @return  a new or existing instance of <code>PropertyListType<ModuleDescriptor></code> 
    */
   public PropertyListType<ModuleDescriptor> getOrCreateProperties()
   {
      Node node = model.getOrCreate("properties");
      PropertyListType<ModuleDescriptor> properties = new PropertyListTypeImpl<ModuleDescriptor>(this, "properties", model, node);
      return properties;
   }

   /**
    * Removes the <code>properties</code> element 
    * @return the current instance of <code>ModuleDescriptor</code> 
    */
   public ModuleDescriptor removeProperties()
   {
      model.removeChildren("properties");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDescriptor ElementName: jboss:permissionsType ElementType : permissions
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>permissions</code> element with the given value will be created.
    * Otherwise, the existing <code>permissions</code> element will be returned.
    * @return  a new or existing instance of <code>PermissionsType<ModuleDescriptor></code> 
    */
   public PermissionsType<ModuleDescriptor> getOrCreatePermissions()
   {
      Node node = model.getOrCreate("permissions");
      PermissionsType<ModuleDescriptor> permissions = new PermissionsTypeImpl<ModuleDescriptor>(this, "permissions", model, node);
      return permissions;
   }

   /**
    * Removes the <code>permissions</code> element 
    * @return the current instance of <code>ModuleDescriptor</code> 
    */
   public ModuleDescriptor removePermissions()
   {
      model.removeChildren("permissions");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDescriptor ElementName: xsd:string ElementType : name
   // MaxOccurs: -  isGeneric: false   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>name</code> attribute
    * @param name the value for the attribute <code>name</code> 
    * @return the current instance of <code>ModuleDescriptor</code> 
    */
   public ModuleDescriptor name(String name)
   {
      model.attribute("name", name);
      return this;
   }

   /**
    * Returns the <code>name</code> attribute
    * @return the value defined for the attribute <code>name</code> 
    */
      public String getName()
   {
      return model.getAttribute("name");
   }

   /**
    * Removes the <code>name</code> attribute 
    * @return the current instance of <code>ModuleDescriptor</code> 
    */
   public ModuleDescriptor removeName()
   {
      model.removeAttribute("name");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleDescriptor ElementName: xsd:string ElementType : slot
   // MaxOccurs: -  isGeneric: false   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>slot</code> attribute
    * @param slot the value for the attribute <code>slot</code> 
    * @return the current instance of <code>ModuleDescriptor</code> 
    */
   public ModuleDescriptor slot(String slot)
   {
      model.attribute("slot", slot);
      return this;
   }

   /**
    * Returns the <code>slot</code> attribute
    * @return the value defined for the attribute <code>slot</code> 
    */
      public String getSlot()
   {
      return model.getAttribute("slot");
   }

   /**
    * Removes the <code>slot</code> attribute 
    * @return the current instance of <code>ModuleDescriptor</code> 
    */
   public ModuleDescriptor removeSlot()
   {
      model.removeAttribute("slot");
      return this;
   }

}
