package org.jboss.shrinkwrap.descriptor.impl.jbossmodule13; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.ResourcesType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.ResourceType;
import org.jboss.shrinkwrap.descriptor.impl.jbossmodule13.ResourceTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.ArtifactType;
import org.jboss.shrinkwrap.descriptor.impl.jbossmodule13.ArtifactTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.ArtifactType;
import org.jboss.shrinkwrap.descriptor.impl.jbossmodule13.ArtifactTypeImpl;

/**
 * This class implements the <code> resourcesType </code> xsd type 
 * @author <a href="mailto:tcrawley@redhat.com">Toby Crawley</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class ResourcesTypeImpl<T> implements Child<T>, ResourcesType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public ResourcesTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public ResourcesTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourcesType ElementName: jboss:resourceType ElementType : resource-root
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resource-root</code> element will be created and returned.
    * Otherwise, the first existing <code>resource-root</code> element will be returned.
    * @return the instance defined for the element <code>resource-root</code> 
    */
   public ResourceType<ResourcesType<T>> getOrCreateResourceRoot()
   {
      List<Node> nodeList = childNode.get("resource-root");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ResourceTypeImpl<ResourcesType<T>>(this, "resource-root", childNode, nodeList.get(0));
      }
      return createResourceRoot();
   }

   /**
    * Creates a new <code>resource-root</code> element 
    * @return the new created instance of <code>ResourceType<ResourcesType<T>></code> 
    */
   public ResourceType<ResourcesType<T>> createResourceRoot()
   {
      return new ResourceTypeImpl<ResourcesType<T>>(this, "resource-root", childNode);
   }

   /**
    * Returns all <code>resource-root</code> elements
    * @return list of <code>resource-root</code> 
    */
   public List<ResourceType<ResourcesType<T>>> getAllResourceRoot()
   {
      List<ResourceType<ResourcesType<T>>> list = new ArrayList<ResourceType<ResourcesType<T>>>();
      List<Node> nodeList = childNode.get("resource-root");
      for(Node node: nodeList)
      {
         ResourceType<ResourcesType<T>>  type = new ResourceTypeImpl<ResourcesType<T>>(this, "resource-root", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>resource-root</code> elements 
    * @return the current instance of <code>ResourceType<ResourcesType<T>></code> 
    */
   public ResourcesType<T> removeAllResourceRoot()
   {
      childNode.removeChildren("resource-root");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourcesType ElementName: jboss:artifactType ElementType : artifact
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>artifact</code> element will be created and returned.
    * Otherwise, the first existing <code>artifact</code> element will be returned.
    * @return the instance defined for the element <code>artifact</code> 
    */
   public ArtifactType<ResourcesType<T>> getOrCreateArtifact()
   {
      List<Node> nodeList = childNode.get("artifact");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ArtifactTypeImpl<ResourcesType<T>>(this, "artifact", childNode, nodeList.get(0));
      }
      return createArtifact();
   }

   /**
    * Creates a new <code>artifact</code> element 
    * @return the new created instance of <code>ArtifactType<ResourcesType<T>></code> 
    */
   public ArtifactType<ResourcesType<T>> createArtifact()
   {
      return new ArtifactTypeImpl<ResourcesType<T>>(this, "artifact", childNode);
   }

   /**
    * Returns all <code>artifact</code> elements
    * @return list of <code>artifact</code> 
    */
   public List<ArtifactType<ResourcesType<T>>> getAllArtifact()
   {
      List<ArtifactType<ResourcesType<T>>> list = new ArrayList<ArtifactType<ResourcesType<T>>>();
      List<Node> nodeList = childNode.get("artifact");
      for(Node node: nodeList)
      {
         ArtifactType<ResourcesType<T>>  type = new ArtifactTypeImpl<ResourcesType<T>>(this, "artifact", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>artifact</code> elements 
    * @return the current instance of <code>ArtifactType<ResourcesType<T>></code> 
    */
   public ResourcesType<T> removeAllArtifact()
   {
      childNode.removeChildren("artifact");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourcesType ElementName: jboss:artifactType ElementType : native-artifact
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>native-artifact</code> element will be created and returned.
    * Otherwise, the first existing <code>native-artifact</code> element will be returned.
    * @return the instance defined for the element <code>native-artifact</code> 
    */
   public ArtifactType<ResourcesType<T>> getOrCreateNativeArtifact()
   {
      List<Node> nodeList = childNode.get("native-artifact");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ArtifactTypeImpl<ResourcesType<T>>(this, "native-artifact", childNode, nodeList.get(0));
      }
      return createNativeArtifact();
   }

   /**
    * Creates a new <code>native-artifact</code> element 
    * @return the new created instance of <code>ArtifactType<ResourcesType<T>></code> 
    */
   public ArtifactType<ResourcesType<T>> createNativeArtifact()
   {
      return new ArtifactTypeImpl<ResourcesType<T>>(this, "native-artifact", childNode);
   }

   /**
    * Returns all <code>native-artifact</code> elements
    * @return list of <code>native-artifact</code> 
    */
   public List<ArtifactType<ResourcesType<T>>> getAllNativeArtifact()
   {
      List<ArtifactType<ResourcesType<T>>> list = new ArrayList<ArtifactType<ResourcesType<T>>>();
      List<Node> nodeList = childNode.get("native-artifact");
      for(Node node: nodeList)
      {
         ArtifactType<ResourcesType<T>>  type = new ArtifactTypeImpl<ResourcesType<T>>(this, "native-artifact", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>native-artifact</code> elements 
    * @return the current instance of <code>ArtifactType<ResourcesType<T>></code> 
    */
   public ResourcesType<T> removeAllNativeArtifact()
   {
      childNode.removeChildren("native-artifact");
      return this;
   }
}
