package org.jboss.shrinkwrap.descriptor.impl.jbossweb60; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.ClassLoadingType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.LoaderRepositoryType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon60.LoaderRepositoryTypeImpl;

/**
 * This class implements the <code> class-loadingType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class ClassLoadingTypeImpl<T> implements Child<T>, ClassLoadingType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public ClassLoadingTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public ClassLoadingTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ClassLoadingType ElementName: jboss:loader-repositoryType ElementType : loader-repository
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>loader-repository</code> element with the given value will be created.
    * Otherwise, the existing <code>loader-repository</code> element will be returned.
    * @return  a new or existing instance of <code>LoaderRepositoryType<ClassLoadingType<T>></code> 
    */
   public LoaderRepositoryType<ClassLoadingType<T>> getOrCreateLoaderRepository()
   {
      Node node = childNode.getOrCreate("loader-repository");
      LoaderRepositoryType<ClassLoadingType<T>> loaderRepository = new LoaderRepositoryTypeImpl<ClassLoadingType<T>>(this, "loader-repository", childNode, node);
      return loaderRepository;
   }

   /**
    * Removes the <code>loader-repository</code> element 
    * @return the current instance of <code>ClassLoadingType<T></code> 
    */
   public ClassLoadingType<T> removeLoaderRepository()
   {
      childNode.removeChildren("loader-repository");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ClassLoadingType ElementName: xsd:boolean ElementType : java2ClassLoadingCompliance
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>java2ClassLoadingCompliance</code> attribute
    * @param java2ClassLoadingCompliance the value for the attribute <code>java2ClassLoadingCompliance</code> 
    * @return the current instance of <code>ClassLoadingType<T></code> 
    */
   public ClassLoadingType<T> javaClassLoadingCompliance(Boolean java2ClassLoadingCompliance)
   {
      childNode.attribute("java2ClassLoadingCompliance", java2ClassLoadingCompliance);
      return this;
   }

   /**
    * Returns the <code>java2ClassLoadingCompliance</code> attribute
    * @return the value defined for the attribute <code>java2ClassLoadingCompliance</code> 
    */
   public Boolean isJavaClassLoadingCompliance()
   {
      return Strings.isTrue(childNode.getAttribute("java2ClassLoadingCompliance"));
   }

   /**
    * Removes the <code>java2ClassLoadingCompliance</code> attribute 
    * @return the current instance of <code>ClassLoadingType<T></code> 
    */
   public ClassLoadingType<T> removeJavaClassLoadingCompliance()
   {
      childNode.removeAttribute("java2ClassLoadingCompliance");
      return this;
   }
}
