package org.jboss.shrinkwrap.descriptor.impl.jbossweb60; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.HttpMethodConstraintType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.EmptyRoleSemanticType;
import org.jboss.shrinkwrap.descriptor.api.webcommon30.TransportGuaranteeType;

/**
 * This class implements the <code> http-method-constraintType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class HttpMethodConstraintTypeImpl<T> implements Child<T>, HttpMethodConstraintType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public HttpMethodConstraintTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public HttpMethodConstraintTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: HttpMethodConstraintType ElementName: xsd:token ElementType : method
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>method</code> element
    * @param method the value for the element <code>method</code> 
    * @return the current instance of <code>HttpMethodConstraintType<T></code> 
    */
   public HttpMethodConstraintType<T> method(String method)
   {
      childNode.getOrCreate("method").text(method);
      return this;
   }

   /**
    * Returns the <code>method</code> element
    * @return the node defined for the element <code>method</code> 
    */
   public String getMethod()
   {
      return childNode.getTextValueForPatternName("method");
   }

   /**
    * Removes the <code>method</code> element 
    * @return the current instance of <code>HttpMethodConstraintType<T></code> 
    */
   public HttpMethodConstraintType<T> removeMethod()
   {
      childNode.removeChildren("method");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: HttpMethodConstraintType ElementName: jboss:empty-role-semanticType ElementType : empty-role-semantic
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: true isDataType: false
   // --------------------------------------------------------------------------------------------------------||
   /**
    * Sets the <code>empty-role-semantic</code> element
    * @param emptyRoleSemantic the value for the element <code>empty-role-semantic</code> 
    * @return the current instance of <code>HttpMethodConstraintType<T></code> 
    */
   public HttpMethodConstraintType<T> emptyRoleSemantic(EmptyRoleSemanticType emptyRoleSemantic)
   {
      childNode.getOrCreate("empty-role-semantic").text(emptyRoleSemantic);
      return this;
   }
   /**
    * Sets the <code>empty-role-semantic</code> element
    * @param emptyRoleSemantic the value for the element <code>empty-role-semantic</code> 
    * @return the current instance of <code>HttpMethodConstraintType<T></code> 
    */
   public HttpMethodConstraintType<T> emptyRoleSemantic(String emptyRoleSemantic)
   {
      childNode.getOrCreate("empty-role-semantic").text(emptyRoleSemantic);
      return this;
   }

   /**
    * Returns the <code>empty-role-semantic</code> element
    * @return the value found for the element <code>empty-role-semantic</code> 
    */
   public EmptyRoleSemanticType getEmptyRoleSemantic()
   {
      return EmptyRoleSemanticType.getFromStringValue(childNode.getTextValueForPatternName("empty-role-semantic"));
   }

   /**
    * Returns the <code>empty-role-semantic</code> element
    * @return the value found for the element <code>empty-role-semantic</code> 
    */
   public String  getEmptyRoleSemanticAsString()
   {
      return childNode.getTextValueForPatternName("empty-role-semantic");
   }

   /**
    * Removes the <code>empty-role-semantic</code> attribute 
    * @return the current instance of <code>HttpMethodConstraintType<T></code> 
    */
   public HttpMethodConstraintType<T> removeEmptyRoleSemantic()
   {
      childNode.removeAttribute("empty-role-semantic");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: HttpMethodConstraintType ElementName: javaee:transport-guaranteeType ElementType : transport-guarantee
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: true isDataType: false
   // --------------------------------------------------------------------------------------------------------||
   /**
    * Sets the <code>transport-guarantee</code> element
    * @param transportGuarantee the value for the element <code>transport-guarantee</code> 
    * @return the current instance of <code>HttpMethodConstraintType<T></code> 
    */
   public HttpMethodConstraintType<T> transportGuarantee(TransportGuaranteeType transportGuarantee)
   {
      childNode.getOrCreate("transport-guarantee").text(transportGuarantee);
      return this;
   }
   /**
    * Sets the <code>transport-guarantee</code> element
    * @param transportGuarantee the value for the element <code>transport-guarantee</code> 
    * @return the current instance of <code>HttpMethodConstraintType<T></code> 
    */
   public HttpMethodConstraintType<T> transportGuarantee(String transportGuarantee)
   {
      childNode.getOrCreate("transport-guarantee").text(transportGuarantee);
      return this;
   }

   /**
    * Returns the <code>transport-guarantee</code> element
    * @return the value found for the element <code>transport-guarantee</code> 
    */
   public TransportGuaranteeType getTransportGuarantee()
   {
      return TransportGuaranteeType.getFromStringValue(childNode.getTextValueForPatternName("transport-guarantee"));
   }

   /**
    * Returns the <code>transport-guarantee</code> element
    * @return the value found for the element <code>transport-guarantee</code> 
    */
   public String  getTransportGuaranteeAsString()
   {
      return childNode.getTextValueForPatternName("transport-guarantee");
   }

   /**
    * Removes the <code>transport-guarantee</code> attribute 
    * @return the current instance of <code>HttpMethodConstraintType<T></code> 
    */
   public HttpMethodConstraintType<T> removeTransportGuarantee()
   {
      childNode.removeAttribute("transport-guarantee");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: HttpMethodConstraintType ElementName: xsd:token ElementType : roles-allowed
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>roles-allowed</code> elements, 
    * a new <code>roles-allowed</code> element 
    * @param values list of <code>roles-allowed</code> objects 
    * @return the current instance of <code>HttpMethodConstraintType<T></code> 
    */
   public HttpMethodConstraintType<T> rolesAllowed(String ... values)
   {
      if (values != null)
      {
         for(String name: values)
         {
            childNode.createChild("roles-allowed").text(name);
         }
      }
      return this;
   }

   /**
    * Returns all <code>roles-allowed</code> elements
    * @return list of <code>roles-allowed</code> 
    */
public List<String> getAllRolesAllowed()
   {
      List<String> result = new ArrayList<String>();
      List<Node> nodes = childNode.get("roles-allowed");
      for (Node node : nodes)
      {
         result.add(node.getText());
      }
      return result;
   }

   /**
    * Removes the <code>roles-allowed</code> element 
    * @return the current instance of <code>HttpMethodConstraintType<T></code> 
    */
   public HttpMethodConstraintType<T> removeAllRolesAllowed()
   {
      childNode.removeChildren("roles-allowed");
      return this;
   }
}
