package org.jboss.shrinkwrap.descriptor.impl.jbossweb60; 

import org.jboss.shrinkwrap.descriptor.api.jbossweb60.JbossWebDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.ClassLoadingType;
import org.jboss.shrinkwrap.descriptor.impl.jbossweb60.ClassLoadingTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.javaee6.GenericBooleanType;
import org.jboss.shrinkwrap.descriptor.api.javaee6.GenericBooleanType;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.ReplicationConfigType;
import org.jboss.shrinkwrap.descriptor.impl.jbossweb60.ReplicationConfigTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.SecurityRoleType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon60.SecurityRoleTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.MessageDestinationType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon60.MessageDestinationTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.WebserviceDescriptionType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon60.WebserviceDescriptionTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.ServletType;
import org.jboss.shrinkwrap.descriptor.impl.jbossweb60.ServletTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.PassivationConfigType;
import org.jboss.shrinkwrap.descriptor.impl.jbossweb60.PassivationConfigTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.AnnotationType;
import org.jboss.shrinkwrap.descriptor.impl.jbossweb60.AnnotationTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.JbossWebVersionType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.EnvEntryType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon60.EnvEntryTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.EjbRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon60.EjbRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.EjbLocalRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon60.EjbLocalRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.ResourceRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon60.ResourceRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.ResourceEnvRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon60.ResourceEnvRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.MessageDestinationRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon60.MessageDestinationRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.PersistenceContextRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon60.PersistenceContextRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.PersistenceUnitRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon60.PersistenceUnitRefTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.LifecycleCallbackType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon60.LifecycleCallbackTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.LifecycleCallbackType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon60.LifecycleCallbackTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.DataSourceType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon60.DataSourceTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.ServiceRefType;
import org.jboss.shrinkwrap.descriptor.impl.jbosscommon60.ServiceRefTypeImpl;
import java.util.Map.Entry;

import org.jboss.shrinkwrap.descriptor.api.DescriptorNamespace;

import org.jboss.shrinkwrap.descriptor.spi.node.NodeDescriptorImplBase;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

/** 
 * <p> 
 * This deployment descriptor provides the functionalities as described in the  specification
 * <p> 
 * Example:
 * <p> 
 * <code> 
 *     JbossWebDescriptor descriptor = Descriptors.create(JbossWebDescriptor.class);
 * </code> 
 *
 *
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class JbossWebDescriptorImpl extends NodeDescriptorImplBase implements DescriptorNamespace<JbossWebDescriptor>, JbossWebDescriptor
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private Node model;

   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public JbossWebDescriptorImpl(String descriptorName)
   {
       this(descriptorName, new Node("jboss-web"));
   }

   public JbossWebDescriptorImpl(String descriptorName, Node node)
   {
      super(descriptorName);
      this.model = node;
      addDefaultNamespaces();
   }

   // -------------------------------------------------------------------------------------||
   // Methods 
   // -------------------------------------------------------------------------------------||

   public Node getRootNode()
   {
      return model;
   }



   // -------------------------------------------------------------------------------------||
   // Namespace 
   // -------------------------------------------------------------------------------------||


   /**
    * Adds the default namespaces as defined in the specification 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor addDefaultNamespaces()
   {
      addNamespace("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
      addNamespace("xsi:schemaLocation", "http://www.jboss.com/xml/ns/javaee http://www.jboss.org/j2ee/schema/jboss-web_6_0.xsd");
      addNamespace("xmlns", "http://www.jboss.com/xml/ns/javaee");
     return this;
   }

   /**
    * Adds a new namespace 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor addNamespace(String name, String value)
   {
      model.attribute(name, value);
      return this;
   }

   /**
    * Returns all defined namespaces. 
    * @return all defined namespaces 
    */
   public List<String> getNamespaces()
   {
      List<String> namespaceList = new ArrayList<String>();
      java.util.Map<String, String> attributes = model.getAttributes();
      for (Entry<String, String> e : attributes.entrySet())
      {
         final String name = e.getKey();
         final String value = e.getValue();
         if (value != null && value.startsWith("http://")) 
         {
            namespaceList.add(name + "=" + value);
         }
      }
      return namespaceList;
   }

   /**
    * Removes all existing namespaces. 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor removeAllNamespaces()
   {
      List<String> nameSpaceKeys = new ArrayList<String>();
      java.util.Map<String, String> attributes = model.getAttributes();
      for (Entry<String, String> e : attributes.entrySet())
      {
         final String name = e.getKey();
         final String value = e.getValue();
         if (value != null && value.startsWith("http://")) 
         {
            nameSpaceKeys.add(name);
         }
      }
      for (String name: nameSpaceKeys)
      {
         model.removeAttribute(name);
      }
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:class-loadingType ElementType : class-loading
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>class-loading</code> element with the given value will be created.
    * Otherwise, the existing <code>class-loading</code> element will be returned.
    * @return  a new or existing instance of <code>ClassLoadingType<JbossWebDescriptor></code> 
    */
   public ClassLoadingType<JbossWebDescriptor> getOrCreateClassLoading()
   {
      Node node = model.getOrCreate("class-loading");
      ClassLoadingType<JbossWebDescriptor> classLoading = new ClassLoadingTypeImpl<JbossWebDescriptor>(this, "class-loading", model, node);
      return classLoading;
   }

   /**
    * Removes the <code>class-loading</code> element 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor removeClassLoading()
   {
      model.removeChildren("class-loading");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: xsd:token ElementType : security-domain
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>security-domain</code> element
    * @param securityDomain the value for the element <code>security-domain</code> 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor securityDomain(String securityDomain)
   {
      model.getOrCreate("security-domain").text(securityDomain);
      return this;
   }

   /**
    * Returns the <code>security-domain</code> element
    * @return the node defined for the element <code>security-domain</code> 
    */
   public String getSecurityDomain()
   {
      return model.getTextValueForPatternName("security-domain");
   }

   /**
    * Removes the <code>security-domain</code> element 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor removeSecurityDomain()
   {
      model.removeChildren("security-domain");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: javaee:generic-booleanType ElementType : jacc-star-role-allow
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: true isDataType: false
   // --------------------------------------------------------------------------------------------------------||
   /**
    * Sets the <code>jacc-star-role-allow</code> element
    * @param jaccStarRoleAllow the value for the element <code>jacc-star-role-allow</code> 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor jaccStarRoleAllow(GenericBooleanType jaccStarRoleAllow)
   {
      model.getOrCreate("jacc-star-role-allow").text(jaccStarRoleAllow);
      return this;
   }
   /**
    * Sets the <code>jacc-star-role-allow</code> element
    * @param jaccStarRoleAllow the value for the element <code>jacc-star-role-allow</code> 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor jaccStarRoleAllow(String jaccStarRoleAllow)
   {
      model.getOrCreate("jacc-star-role-allow").text(jaccStarRoleAllow);
      return this;
   }

   /**
    * Returns the <code>jacc-star-role-allow</code> element
    * @return the value found for the element <code>jacc-star-role-allow</code> 
    */
   public GenericBooleanType getJaccStarRoleAllow()
   {
      return GenericBooleanType.getFromStringValue(model.getTextValueForPatternName("jacc-star-role-allow"));
   }

   /**
    * Returns the <code>jacc-star-role-allow</code> element
    * @return the value found for the element <code>jacc-star-role-allow</code> 
    */
   public String  getJaccStarRoleAllowAsString()
   {
      return model.getTextValueForPatternName("jacc-star-role-allow");
   }

   /**
    * Removes the <code>jacc-star-role-allow</code> attribute 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor removeJaccStarRoleAllow()
   {
      model.removeAttribute("jacc-star-role-allow");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: javaee:string ElementType : context-root
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>context-root</code> element
    * @param contextRoot the value for the element <code>context-root</code> 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor contextRoot(String contextRoot)
   {
      model.getOrCreate("context-root").text(contextRoot);
      return this;
   }

   /**
    * Returns the <code>context-root</code> element
    * @return the node defined for the element <code>context-root</code> 
    */
   public String getContextRoot()
   {
      return model.getTextValueForPatternName("context-root");
   }

   /**
    * Removes the <code>context-root</code> element 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor removeContextRoot()
   {
      model.removeChildren("context-root");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: javaee:string ElementType : virtual-host
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>virtual-host</code> elements, 
    * a new <code>virtual-host</code> element 
    * @param values list of <code>virtual-host</code> objects 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor virtualHost(String ... values)
   {
      if (values != null)
      {
         for(String name: values)
         {
            model.createChild("virtual-host").text(name);
         }
      }
      return this;
   }

   /**
    * Returns all <code>virtual-host</code> elements
    * @return list of <code>virtual-host</code> 
    */
public List<String> getAllVirtualHost()
   {
      List<String> result = new ArrayList<String>();
      List<Node> nodes = model.get("virtual-host");
      for (Node node : nodes)
      {
         result.add(node.getText());
      }
      return result;
   }

   /**
    * Removes the <code>virtual-host</code> element 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor removeAllVirtualHost()
   {
      model.removeChildren("virtual-host");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: javaee:generic-booleanType ElementType : use-session-cookies
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: true isDataType: false
   // --------------------------------------------------------------------------------------------------------||
   /**
    * Sets the <code>use-session-cookies</code> element
    * @param useSessionCookies the value for the element <code>use-session-cookies</code> 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor useSessionCookies(GenericBooleanType useSessionCookies)
   {
      model.getOrCreate("use-session-cookies").text(useSessionCookies);
      return this;
   }
   /**
    * Sets the <code>use-session-cookies</code> element
    * @param useSessionCookies the value for the element <code>use-session-cookies</code> 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor useSessionCookies(String useSessionCookies)
   {
      model.getOrCreate("use-session-cookies").text(useSessionCookies);
      return this;
   }

   /**
    * Returns the <code>use-session-cookies</code> element
    * @return the value found for the element <code>use-session-cookies</code> 
    */
   public GenericBooleanType getUseSessionCookies()
   {
      return GenericBooleanType.getFromStringValue(model.getTextValueForPatternName("use-session-cookies"));
   }

   /**
    * Returns the <code>use-session-cookies</code> element
    * @return the value found for the element <code>use-session-cookies</code> 
    */
   public String  getUseSessionCookiesAsString()
   {
      return model.getTextValueForPatternName("use-session-cookies");
   }

   /**
    * Removes the <code>use-session-cookies</code> attribute 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor removeUseSessionCookies()
   {
      model.removeAttribute("use-session-cookies");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:replication-configType ElementType : replication-config
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>replication-config</code> element with the given value will be created.
    * Otherwise, the existing <code>replication-config</code> element will be returned.
    * @return  a new or existing instance of <code>ReplicationConfigType<JbossWebDescriptor></code> 
    */
   public ReplicationConfigType<JbossWebDescriptor> getOrCreateReplicationConfig()
   {
      Node node = model.getOrCreate("replication-config");
      ReplicationConfigType<JbossWebDescriptor> replicationConfig = new ReplicationConfigTypeImpl<JbossWebDescriptor>(this, "replication-config", model, node);
      return replicationConfig;
   }

   /**
    * Removes the <code>replication-config</code> element 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor removeReplicationConfig()
   {
      model.removeChildren("replication-config");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:security-roleType ElementType : security-role
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>security-role</code> element will be created and returned.
    * Otherwise, the first existing <code>security-role</code> element will be returned.
    * @return the instance defined for the element <code>security-role</code> 
    */
   public SecurityRoleType<JbossWebDescriptor> getOrCreateSecurityRole()
   {
      List<Node> nodeList = model.get("security-role");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new SecurityRoleTypeImpl<JbossWebDescriptor>(this, "security-role", model, nodeList.get(0));
      }
      return createSecurityRole();
   }

   /**
    * Creates a new <code>security-role</code> element 
    * @return the new created instance of <code>SecurityRoleType<JbossWebDescriptor></code> 
    */
   public SecurityRoleType<JbossWebDescriptor> createSecurityRole()
   {
      return new SecurityRoleTypeImpl<JbossWebDescriptor>(this, "security-role", model);
   }

   /**
    * Returns all <code>security-role</code> elements
    * @return list of <code>security-role</code> 
    */
   public List<SecurityRoleType<JbossWebDescriptor>> getAllSecurityRole()
   {
      List<SecurityRoleType<JbossWebDescriptor>> list = new ArrayList<SecurityRoleType<JbossWebDescriptor>>();
      List<Node> nodeList = model.get("security-role");
      for(Node node: nodeList)
      {
         SecurityRoleType<JbossWebDescriptor>  type = new SecurityRoleTypeImpl<JbossWebDescriptor>(this, "security-role", model, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>security-role</code> elements 
    * @return the current instance of <code>SecurityRoleType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllSecurityRole()
   {
      model.removeChildren("security-role");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:message-destinationType ElementType : message-destination
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>message-destination</code> element will be created and returned.
    * Otherwise, the first existing <code>message-destination</code> element will be returned.
    * @return the instance defined for the element <code>message-destination</code> 
    */
   public MessageDestinationType<JbossWebDescriptor> getOrCreateMessageDestination()
   {
      List<Node> nodeList = model.get("message-destination");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new MessageDestinationTypeImpl<JbossWebDescriptor>(this, "message-destination", model, nodeList.get(0));
      }
      return createMessageDestination();
   }

   /**
    * Creates a new <code>message-destination</code> element 
    * @return the new created instance of <code>MessageDestinationType<JbossWebDescriptor></code> 
    */
   public MessageDestinationType<JbossWebDescriptor> createMessageDestination()
   {
      return new MessageDestinationTypeImpl<JbossWebDescriptor>(this, "message-destination", model);
   }

   /**
    * Returns all <code>message-destination</code> elements
    * @return list of <code>message-destination</code> 
    */
   public List<MessageDestinationType<JbossWebDescriptor>> getAllMessageDestination()
   {
      List<MessageDestinationType<JbossWebDescriptor>> list = new ArrayList<MessageDestinationType<JbossWebDescriptor>>();
      List<Node> nodeList = model.get("message-destination");
      for(Node node: nodeList)
      {
         MessageDestinationType<JbossWebDescriptor>  type = new MessageDestinationTypeImpl<JbossWebDescriptor>(this, "message-destination", model, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>message-destination</code> elements 
    * @return the current instance of <code>MessageDestinationType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllMessageDestination()
   {
      model.removeChildren("message-destination");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:webservice-descriptionType ElementType : webservice-description
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>webservice-description</code> element will be created and returned.
    * Otherwise, the first existing <code>webservice-description</code> element will be returned.
    * @return the instance defined for the element <code>webservice-description</code> 
    */
   public WebserviceDescriptionType<JbossWebDescriptor> getOrCreateWebserviceDescription()
   {
      List<Node> nodeList = model.get("webservice-description");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new WebserviceDescriptionTypeImpl<JbossWebDescriptor>(this, "webservice-description", model, nodeList.get(0));
      }
      return createWebserviceDescription();
   }

   /**
    * Creates a new <code>webservice-description</code> element 
    * @return the new created instance of <code>WebserviceDescriptionType<JbossWebDescriptor></code> 
    */
   public WebserviceDescriptionType<JbossWebDescriptor> createWebserviceDescription()
   {
      return new WebserviceDescriptionTypeImpl<JbossWebDescriptor>(this, "webservice-description", model);
   }

   /**
    * Returns all <code>webservice-description</code> elements
    * @return list of <code>webservice-description</code> 
    */
   public List<WebserviceDescriptionType<JbossWebDescriptor>> getAllWebserviceDescription()
   {
      List<WebserviceDescriptionType<JbossWebDescriptor>> list = new ArrayList<WebserviceDescriptionType<JbossWebDescriptor>>();
      List<Node> nodeList = model.get("webservice-description");
      for(Node node: nodeList)
      {
         WebserviceDescriptionType<JbossWebDescriptor>  type = new WebserviceDescriptionTypeImpl<JbossWebDescriptor>(this, "webservice-description", model, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>webservice-description</code> elements 
    * @return the current instance of <code>WebserviceDescriptionType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllWebserviceDescription()
   {
      model.removeChildren("webservice-description");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: xsd:token ElementType : depends
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>depends</code> elements, 
    * a new <code>depends</code> element 
    * @param values list of <code>depends</code> objects 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor depends(String ... values)
   {
      if (values != null)
      {
         for(String name: values)
         {
            model.createChild("depends").text(name);
         }
      }
      return this;
   }

   /**
    * Returns all <code>depends</code> elements
    * @return list of <code>depends</code> 
    */
public List<String> getAllDepends()
   {
      List<String> result = new ArrayList<String>();
      List<Node> nodes = model.get("depends");
      for (Node node : nodes)
      {
         result.add(node.getText());
      }
      return result;
   }

   /**
    * Removes the <code>depends</code> element 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor removeAllDepends()
   {
      model.removeChildren("depends");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:servletType ElementType : servlet
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>servlet</code> element will be created and returned.
    * Otherwise, the first existing <code>servlet</code> element will be returned.
    * @return the instance defined for the element <code>servlet</code> 
    */
   public ServletType<JbossWebDescriptor> getOrCreateServlet()
   {
      List<Node> nodeList = model.get("servlet");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ServletTypeImpl<JbossWebDescriptor>(this, "servlet", model, nodeList.get(0));
      }
      return createServlet();
   }

   /**
    * Creates a new <code>servlet</code> element 
    * @return the new created instance of <code>ServletType<JbossWebDescriptor></code> 
    */
   public ServletType<JbossWebDescriptor> createServlet()
   {
      return new ServletTypeImpl<JbossWebDescriptor>(this, "servlet", model);
   }

   /**
    * Returns all <code>servlet</code> elements
    * @return list of <code>servlet</code> 
    */
   public List<ServletType<JbossWebDescriptor>> getAllServlet()
   {
      List<ServletType<JbossWebDescriptor>> list = new ArrayList<ServletType<JbossWebDescriptor>>();
      List<Node> nodeList = model.get("servlet");
      for(Node node: nodeList)
      {
         ServletType<JbossWebDescriptor>  type = new ServletTypeImpl<JbossWebDescriptor>(this, "servlet", model, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>servlet</code> elements 
    * @return the current instance of <code>ServletType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllServlet()
   {
      model.removeChildren("servlet");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: xsd:integer ElementType : max-active-sessions
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>max-active-sessions</code> element
    * @param maxActiveSessions the value for the element <code>max-active-sessions</code> 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor maxActiveSessions(Integer maxActiveSessions)
   {
      model.getOrCreate("max-active-sessions").text(maxActiveSessions);
      return this;
   }

   /**
    * Returns the <code>max-active-sessions</code> element
    * @return the node defined for the element <code>max-active-sessions</code> 
    */
   public Integer getMaxActiveSessions()
   {
      if (model.getTextValueForPatternName("max-active-sessions") != null && !model.getTextValueForPatternName("max-active-sessions").equals("null")) {
         return Integer.valueOf(model.getTextValueForPatternName("max-active-sessions"));
      }
      return null;
   }

   /**
    * Removes the <code>max-active-sessions</code> element 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor removeMaxActiveSessions()
   {
      model.removeChildren("max-active-sessions");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:passivation-configType ElementType : passivation-config
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>passivation-config</code> element with the given value will be created.
    * Otherwise, the existing <code>passivation-config</code> element will be returned.
    * @return  a new or existing instance of <code>PassivationConfigType<JbossWebDescriptor></code> 
    */
   public PassivationConfigType<JbossWebDescriptor> getOrCreatePassivationConfig()
   {
      Node node = model.getOrCreate("passivation-config");
      PassivationConfigType<JbossWebDescriptor> passivationConfig = new PassivationConfigTypeImpl<JbossWebDescriptor>(this, "passivation-config", model, node);
      return passivationConfig;
   }

   /**
    * Removes the <code>passivation-config</code> element 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor removePassivationConfig()
   {
      model.removeChildren("passivation-config");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:annotationType ElementType : annotation
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>annotation</code> element with the given value will be created.
    * Otherwise, the existing <code>annotation</code> element will be returned.
    * @return  a new or existing instance of <code>AnnotationType<JbossWebDescriptor></code> 
    */
   public AnnotationType<JbossWebDescriptor> getOrCreateAnnotation()
   {
      Node node = model.getOrCreate("annotation");
      AnnotationType<JbossWebDescriptor> annotation = new AnnotationTypeImpl<JbossWebDescriptor>(this, "annotation", model, node);
      return annotation;
   }

   /**
    * Removes the <code>annotation</code> element 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor removeAnnotation()
   {
      model.removeChildren("annotation");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:jboss-web-versionType ElementType : version
   // MaxOccurs: -  isGeneric: false   isAttribute: true isEnum: true isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>version</code> attribute
    * @param version the value for the attribute <code>version</code> 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor version(JbossWebVersionType version)
   {
      model.attribute("version", version);
      return this;
   }

   /**
    * Sets the <code>version</code> attribute
    * @param version the value for the attribute <code>version</code> 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor version(String version)
   {
      model.attribute("version", version);
      return this;
   }

   /**
    * Returns the <code>version</code> attribute
    * @return the value defined for the attribute <code>version</code> 
    */
   public JbossWebVersionType getVersion()
   {
      return JbossWebVersionType.getFromStringValue(model.getAttribute("version"));
   }

   /**
    * Returns the <code>version</code> attribute
    * @return the value found for the element <code>version</code> 
    */
   public String  getVersionAsString()
   {
      return model.getAttribute("version");
   }

   /**
    * Removes the <code>version</code> attribute 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor removeVersion()
   {
      model.removeAttribute("version");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:env-entryType ElementType : env-entry
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>env-entry</code> element will be created and returned.
    * Otherwise, the first existing <code>env-entry</code> element will be returned.
    * @return the instance defined for the element <code>env-entry</code> 
    */
   public EnvEntryType<JbossWebDescriptor> getOrCreateEnvEntry()
   {
      List<Node> nodeList = model.get("env-entry");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new EnvEntryTypeImpl<JbossWebDescriptor>(this, "env-entry", model, nodeList.get(0));
      }
      return createEnvEntry();
   }

   /**
    * Creates a new <code>env-entry</code> element 
    * @return the new created instance of <code>EnvEntryType<JbossWebDescriptor></code> 
    */
   public EnvEntryType<JbossWebDescriptor> createEnvEntry()
   {
      return new EnvEntryTypeImpl<JbossWebDescriptor>(this, "env-entry", model);
   }

   /**
    * Returns all <code>env-entry</code> elements
    * @return list of <code>env-entry</code> 
    */
   public List<EnvEntryType<JbossWebDescriptor>> getAllEnvEntry()
   {
      List<EnvEntryType<JbossWebDescriptor>> list = new ArrayList<EnvEntryType<JbossWebDescriptor>>();
      List<Node> nodeList = model.get("env-entry");
      for(Node node: nodeList)
      {
         EnvEntryType<JbossWebDescriptor>  type = new EnvEntryTypeImpl<JbossWebDescriptor>(this, "env-entry", model, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>env-entry</code> elements 
    * @return the current instance of <code>EnvEntryType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllEnvEntry()
   {
      model.removeChildren("env-entry");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:ejb-refType ElementType : ejb-ref
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>ejb-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>ejb-ref</code> element will be returned.
    * @return the instance defined for the element <code>ejb-ref</code> 
    */
   public EjbRefType<JbossWebDescriptor> getOrCreateEjbRef()
   {
      List<Node> nodeList = model.get("ejb-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new EjbRefTypeImpl<JbossWebDescriptor>(this, "ejb-ref", model, nodeList.get(0));
      }
      return createEjbRef();
   }

   /**
    * Creates a new <code>ejb-ref</code> element 
    * @return the new created instance of <code>EjbRefType<JbossWebDescriptor></code> 
    */
   public EjbRefType<JbossWebDescriptor> createEjbRef()
   {
      return new EjbRefTypeImpl<JbossWebDescriptor>(this, "ejb-ref", model);
   }

   /**
    * Returns all <code>ejb-ref</code> elements
    * @return list of <code>ejb-ref</code> 
    */
   public List<EjbRefType<JbossWebDescriptor>> getAllEjbRef()
   {
      List<EjbRefType<JbossWebDescriptor>> list = new ArrayList<EjbRefType<JbossWebDescriptor>>();
      List<Node> nodeList = model.get("ejb-ref");
      for(Node node: nodeList)
      {
         EjbRefType<JbossWebDescriptor>  type = new EjbRefTypeImpl<JbossWebDescriptor>(this, "ejb-ref", model, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>ejb-ref</code> elements 
    * @return the current instance of <code>EjbRefType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllEjbRef()
   {
      model.removeChildren("ejb-ref");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:ejb-local-refType ElementType : ejb-local-ref
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>ejb-local-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>ejb-local-ref</code> element will be returned.
    * @return the instance defined for the element <code>ejb-local-ref</code> 
    */
   public EjbLocalRefType<JbossWebDescriptor> getOrCreateEjbLocalRef()
   {
      List<Node> nodeList = model.get("ejb-local-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new EjbLocalRefTypeImpl<JbossWebDescriptor>(this, "ejb-local-ref", model, nodeList.get(0));
      }
      return createEjbLocalRef();
   }

   /**
    * Creates a new <code>ejb-local-ref</code> element 
    * @return the new created instance of <code>EjbLocalRefType<JbossWebDescriptor></code> 
    */
   public EjbLocalRefType<JbossWebDescriptor> createEjbLocalRef()
   {
      return new EjbLocalRefTypeImpl<JbossWebDescriptor>(this, "ejb-local-ref", model);
   }

   /**
    * Returns all <code>ejb-local-ref</code> elements
    * @return list of <code>ejb-local-ref</code> 
    */
   public List<EjbLocalRefType<JbossWebDescriptor>> getAllEjbLocalRef()
   {
      List<EjbLocalRefType<JbossWebDescriptor>> list = new ArrayList<EjbLocalRefType<JbossWebDescriptor>>();
      List<Node> nodeList = model.get("ejb-local-ref");
      for(Node node: nodeList)
      {
         EjbLocalRefType<JbossWebDescriptor>  type = new EjbLocalRefTypeImpl<JbossWebDescriptor>(this, "ejb-local-ref", model, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>ejb-local-ref</code> elements 
    * @return the current instance of <code>EjbLocalRefType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllEjbLocalRef()
   {
      model.removeChildren("ejb-local-ref");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:resource-refType ElementType : resource-ref
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resource-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>resource-ref</code> element will be returned.
    * @return the instance defined for the element <code>resource-ref</code> 
    */
   public ResourceRefType<JbossWebDescriptor> getOrCreateResourceRef()
   {
      List<Node> nodeList = model.get("resource-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ResourceRefTypeImpl<JbossWebDescriptor>(this, "resource-ref", model, nodeList.get(0));
      }
      return createResourceRef();
   }

   /**
    * Creates a new <code>resource-ref</code> element 
    * @return the new created instance of <code>ResourceRefType<JbossWebDescriptor></code> 
    */
   public ResourceRefType<JbossWebDescriptor> createResourceRef()
   {
      return new ResourceRefTypeImpl<JbossWebDescriptor>(this, "resource-ref", model);
   }

   /**
    * Returns all <code>resource-ref</code> elements
    * @return list of <code>resource-ref</code> 
    */
   public List<ResourceRefType<JbossWebDescriptor>> getAllResourceRef()
   {
      List<ResourceRefType<JbossWebDescriptor>> list = new ArrayList<ResourceRefType<JbossWebDescriptor>>();
      List<Node> nodeList = model.get("resource-ref");
      for(Node node: nodeList)
      {
         ResourceRefType<JbossWebDescriptor>  type = new ResourceRefTypeImpl<JbossWebDescriptor>(this, "resource-ref", model, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>resource-ref</code> elements 
    * @return the current instance of <code>ResourceRefType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllResourceRef()
   {
      model.removeChildren("resource-ref");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:resource-env-refType ElementType : resource-env-ref
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resource-env-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>resource-env-ref</code> element will be returned.
    * @return the instance defined for the element <code>resource-env-ref</code> 
    */
   public ResourceEnvRefType<JbossWebDescriptor> getOrCreateResourceEnvRef()
   {
      List<Node> nodeList = model.get("resource-env-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ResourceEnvRefTypeImpl<JbossWebDescriptor>(this, "resource-env-ref", model, nodeList.get(0));
      }
      return createResourceEnvRef();
   }

   /**
    * Creates a new <code>resource-env-ref</code> element 
    * @return the new created instance of <code>ResourceEnvRefType<JbossWebDescriptor></code> 
    */
   public ResourceEnvRefType<JbossWebDescriptor> createResourceEnvRef()
   {
      return new ResourceEnvRefTypeImpl<JbossWebDescriptor>(this, "resource-env-ref", model);
   }

   /**
    * Returns all <code>resource-env-ref</code> elements
    * @return list of <code>resource-env-ref</code> 
    */
   public List<ResourceEnvRefType<JbossWebDescriptor>> getAllResourceEnvRef()
   {
      List<ResourceEnvRefType<JbossWebDescriptor>> list = new ArrayList<ResourceEnvRefType<JbossWebDescriptor>>();
      List<Node> nodeList = model.get("resource-env-ref");
      for(Node node: nodeList)
      {
         ResourceEnvRefType<JbossWebDescriptor>  type = new ResourceEnvRefTypeImpl<JbossWebDescriptor>(this, "resource-env-ref", model, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>resource-env-ref</code> elements 
    * @return the current instance of <code>ResourceEnvRefType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllResourceEnvRef()
   {
      model.removeChildren("resource-env-ref");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:message-destination-refType ElementType : message-destination-ref
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>message-destination-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>message-destination-ref</code> element will be returned.
    * @return the instance defined for the element <code>message-destination-ref</code> 
    */
   public MessageDestinationRefType<JbossWebDescriptor> getOrCreateMessageDestinationRef()
   {
      List<Node> nodeList = model.get("message-destination-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new MessageDestinationRefTypeImpl<JbossWebDescriptor>(this, "message-destination-ref", model, nodeList.get(0));
      }
      return createMessageDestinationRef();
   }

   /**
    * Creates a new <code>message-destination-ref</code> element 
    * @return the new created instance of <code>MessageDestinationRefType<JbossWebDescriptor></code> 
    */
   public MessageDestinationRefType<JbossWebDescriptor> createMessageDestinationRef()
   {
      return new MessageDestinationRefTypeImpl<JbossWebDescriptor>(this, "message-destination-ref", model);
   }

   /**
    * Returns all <code>message-destination-ref</code> elements
    * @return list of <code>message-destination-ref</code> 
    */
   public List<MessageDestinationRefType<JbossWebDescriptor>> getAllMessageDestinationRef()
   {
      List<MessageDestinationRefType<JbossWebDescriptor>> list = new ArrayList<MessageDestinationRefType<JbossWebDescriptor>>();
      List<Node> nodeList = model.get("message-destination-ref");
      for(Node node: nodeList)
      {
         MessageDestinationRefType<JbossWebDescriptor>  type = new MessageDestinationRefTypeImpl<JbossWebDescriptor>(this, "message-destination-ref", model, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>message-destination-ref</code> elements 
    * @return the current instance of <code>MessageDestinationRefType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllMessageDestinationRef()
   {
      model.removeChildren("message-destination-ref");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:persistence-context-refType ElementType : persistence-context-ref
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>persistence-context-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>persistence-context-ref</code> element will be returned.
    * @return the instance defined for the element <code>persistence-context-ref</code> 
    */
   public PersistenceContextRefType<JbossWebDescriptor> getOrCreatePersistenceContextRef()
   {
      List<Node> nodeList = model.get("persistence-context-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new PersistenceContextRefTypeImpl<JbossWebDescriptor>(this, "persistence-context-ref", model, nodeList.get(0));
      }
      return createPersistenceContextRef();
   }

   /**
    * Creates a new <code>persistence-context-ref</code> element 
    * @return the new created instance of <code>PersistenceContextRefType<JbossWebDescriptor></code> 
    */
   public PersistenceContextRefType<JbossWebDescriptor> createPersistenceContextRef()
   {
      return new PersistenceContextRefTypeImpl<JbossWebDescriptor>(this, "persistence-context-ref", model);
   }

   /**
    * Returns all <code>persistence-context-ref</code> elements
    * @return list of <code>persistence-context-ref</code> 
    */
   public List<PersistenceContextRefType<JbossWebDescriptor>> getAllPersistenceContextRef()
   {
      List<PersistenceContextRefType<JbossWebDescriptor>> list = new ArrayList<PersistenceContextRefType<JbossWebDescriptor>>();
      List<Node> nodeList = model.get("persistence-context-ref");
      for(Node node: nodeList)
      {
         PersistenceContextRefType<JbossWebDescriptor>  type = new PersistenceContextRefTypeImpl<JbossWebDescriptor>(this, "persistence-context-ref", model, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>persistence-context-ref</code> elements 
    * @return the current instance of <code>PersistenceContextRefType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllPersistenceContextRef()
   {
      model.removeChildren("persistence-context-ref");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:persistence-unit-refType ElementType : persistence-unit-ref
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>persistence-unit-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>persistence-unit-ref</code> element will be returned.
    * @return the instance defined for the element <code>persistence-unit-ref</code> 
    */
   public PersistenceUnitRefType<JbossWebDescriptor> getOrCreatePersistenceUnitRef()
   {
      List<Node> nodeList = model.get("persistence-unit-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new PersistenceUnitRefTypeImpl<JbossWebDescriptor>(this, "persistence-unit-ref", model, nodeList.get(0));
      }
      return createPersistenceUnitRef();
   }

   /**
    * Creates a new <code>persistence-unit-ref</code> element 
    * @return the new created instance of <code>PersistenceUnitRefType<JbossWebDescriptor></code> 
    */
   public PersistenceUnitRefType<JbossWebDescriptor> createPersistenceUnitRef()
   {
      return new PersistenceUnitRefTypeImpl<JbossWebDescriptor>(this, "persistence-unit-ref", model);
   }

   /**
    * Returns all <code>persistence-unit-ref</code> elements
    * @return list of <code>persistence-unit-ref</code> 
    */
   public List<PersistenceUnitRefType<JbossWebDescriptor>> getAllPersistenceUnitRef()
   {
      List<PersistenceUnitRefType<JbossWebDescriptor>> list = new ArrayList<PersistenceUnitRefType<JbossWebDescriptor>>();
      List<Node> nodeList = model.get("persistence-unit-ref");
      for(Node node: nodeList)
      {
         PersistenceUnitRefType<JbossWebDescriptor>  type = new PersistenceUnitRefTypeImpl<JbossWebDescriptor>(this, "persistence-unit-ref", model, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>persistence-unit-ref</code> elements 
    * @return the current instance of <code>PersistenceUnitRefType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllPersistenceUnitRef()
   {
      model.removeChildren("persistence-unit-ref");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:lifecycle-callbackType ElementType : post-construct
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>post-construct</code> element will be created and returned.
    * Otherwise, the first existing <code>post-construct</code> element will be returned.
    * @return the instance defined for the element <code>post-construct</code> 
    */
   public LifecycleCallbackType<JbossWebDescriptor> getOrCreatePostConstruct()
   {
      List<Node> nodeList = model.get("post-construct");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new LifecycleCallbackTypeImpl<JbossWebDescriptor>(this, "post-construct", model, nodeList.get(0));
      }
      return createPostConstruct();
   }

   /**
    * Creates a new <code>post-construct</code> element 
    * @return the new created instance of <code>LifecycleCallbackType<JbossWebDescriptor></code> 
    */
   public LifecycleCallbackType<JbossWebDescriptor> createPostConstruct()
   {
      return new LifecycleCallbackTypeImpl<JbossWebDescriptor>(this, "post-construct", model);
   }

   /**
    * Returns all <code>post-construct</code> elements
    * @return list of <code>post-construct</code> 
    */
   public List<LifecycleCallbackType<JbossWebDescriptor>> getAllPostConstruct()
   {
      List<LifecycleCallbackType<JbossWebDescriptor>> list = new ArrayList<LifecycleCallbackType<JbossWebDescriptor>>();
      List<Node> nodeList = model.get("post-construct");
      for(Node node: nodeList)
      {
         LifecycleCallbackType<JbossWebDescriptor>  type = new LifecycleCallbackTypeImpl<JbossWebDescriptor>(this, "post-construct", model, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>post-construct</code> elements 
    * @return the current instance of <code>LifecycleCallbackType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllPostConstruct()
   {
      model.removeChildren("post-construct");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:lifecycle-callbackType ElementType : pre-destroy
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>pre-destroy</code> element will be created and returned.
    * Otherwise, the first existing <code>pre-destroy</code> element will be returned.
    * @return the instance defined for the element <code>pre-destroy</code> 
    */
   public LifecycleCallbackType<JbossWebDescriptor> getOrCreatePreDestroy()
   {
      List<Node> nodeList = model.get("pre-destroy");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new LifecycleCallbackTypeImpl<JbossWebDescriptor>(this, "pre-destroy", model, nodeList.get(0));
      }
      return createPreDestroy();
   }

   /**
    * Creates a new <code>pre-destroy</code> element 
    * @return the new created instance of <code>LifecycleCallbackType<JbossWebDescriptor></code> 
    */
   public LifecycleCallbackType<JbossWebDescriptor> createPreDestroy()
   {
      return new LifecycleCallbackTypeImpl<JbossWebDescriptor>(this, "pre-destroy", model);
   }

   /**
    * Returns all <code>pre-destroy</code> elements
    * @return list of <code>pre-destroy</code> 
    */
   public List<LifecycleCallbackType<JbossWebDescriptor>> getAllPreDestroy()
   {
      List<LifecycleCallbackType<JbossWebDescriptor>> list = new ArrayList<LifecycleCallbackType<JbossWebDescriptor>>();
      List<Node> nodeList = model.get("pre-destroy");
      for(Node node: nodeList)
      {
         LifecycleCallbackType<JbossWebDescriptor>  type = new LifecycleCallbackTypeImpl<JbossWebDescriptor>(this, "pre-destroy", model, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>pre-destroy</code> elements 
    * @return the current instance of <code>LifecycleCallbackType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllPreDestroy()
   {
      model.removeChildren("pre-destroy");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:data-sourceType ElementType : data-source
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>data-source</code> element will be created and returned.
    * Otherwise, the first existing <code>data-source</code> element will be returned.
    * @return the instance defined for the element <code>data-source</code> 
    */
   public DataSourceType<JbossWebDescriptor> getOrCreateDataSource()
   {
      List<Node> nodeList = model.get("data-source");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new DataSourceTypeImpl<JbossWebDescriptor>(this, "data-source", model, nodeList.get(0));
      }
      return createDataSource();
   }

   /**
    * Creates a new <code>data-source</code> element 
    * @return the new created instance of <code>DataSourceType<JbossWebDescriptor></code> 
    */
   public DataSourceType<JbossWebDescriptor> createDataSource()
   {
      return new DataSourceTypeImpl<JbossWebDescriptor>(this, "data-source", model);
   }

   /**
    * Returns all <code>data-source</code> elements
    * @return list of <code>data-source</code> 
    */
   public List<DataSourceType<JbossWebDescriptor>> getAllDataSource()
   {
      List<DataSourceType<JbossWebDescriptor>> list = new ArrayList<DataSourceType<JbossWebDescriptor>>();
      List<Node> nodeList = model.get("data-source");
      for(Node node: nodeList)
      {
         DataSourceType<JbossWebDescriptor>  type = new DataSourceTypeImpl<JbossWebDescriptor>(this, "data-source", model, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>data-source</code> elements 
    * @return the current instance of <code>DataSourceType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllDataSource()
   {
      model.removeChildren("data-source");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:service-refType ElementType : service-ref
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>service-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>service-ref</code> element will be returned.
    * @return the instance defined for the element <code>service-ref</code> 
    */
   public ServiceRefType<JbossWebDescriptor> getOrCreateServiceRef()
   {
      List<Node> nodeList = model.get("service-ref");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ServiceRefTypeImpl<JbossWebDescriptor>(this, "service-ref", model, nodeList.get(0));
      }
      return createServiceRef();
   }

   /**
    * Creates a new <code>service-ref</code> element 
    * @return the new created instance of <code>ServiceRefType<JbossWebDescriptor></code> 
    */
   public ServiceRefType<JbossWebDescriptor> createServiceRef()
   {
      return new ServiceRefTypeImpl<JbossWebDescriptor>(this, "service-ref", model);
   }

   /**
    * Returns all <code>service-ref</code> elements
    * @return list of <code>service-ref</code> 
    */
   public List<ServiceRefType<JbossWebDescriptor>> getAllServiceRef()
   {
      List<ServiceRefType<JbossWebDescriptor>> list = new ArrayList<ServiceRefType<JbossWebDescriptor>>();
      List<Node> nodeList = model.get("service-ref");
      for(Node node: nodeList)
      {
         ServiceRefType<JbossWebDescriptor>  type = new ServiceRefTypeImpl<JbossWebDescriptor>(this, "service-ref", model, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>service-ref</code> elements 
    * @return the current instance of <code>ServiceRefType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllServiceRef()
   {
      model.removeChildren("service-ref");
      return this;
   }

}
