package org.jboss.shrinkwrap.descriptor.impl.jbossweb60; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.ServletSecurityType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.webcommon30.TransportGuaranteeType;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.HttpMethodConstraintType;
import org.jboss.shrinkwrap.descriptor.impl.jbossweb60.HttpMethodConstraintTypeImpl;

/**
 * This class implements the <code> servlet-securityType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class ServletSecurityTypeImpl<T> implements Child<T>, ServletSecurityType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public ServletSecurityTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public ServletSecurityTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServletSecurityType ElementName: xsd:token ElementType : empty-role-semantic
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>empty-role-semantic</code> element
    * @param emptyRoleSemantic the value for the element <code>empty-role-semantic</code> 
    * @return the current instance of <code>ServletSecurityType<T></code> 
    */
   public ServletSecurityType<T> emptyRoleSemantic(String emptyRoleSemantic)
   {
      childNode.getOrCreate("empty-role-semantic").text(emptyRoleSemantic);
      return this;
   }

   /**
    * Returns the <code>empty-role-semantic</code> element
    * @return the node defined for the element <code>empty-role-semantic</code> 
    */
   public String getEmptyRoleSemantic()
   {
      return childNode.getTextValueForPatternName("empty-role-semantic");
   }

   /**
    * Removes the <code>empty-role-semantic</code> element 
    * @return the current instance of <code>ServletSecurityType<T></code> 
    */
   public ServletSecurityType<T> removeEmptyRoleSemantic()
   {
      childNode.removeChildren("empty-role-semantic");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServletSecurityType ElementName: javaee:transport-guaranteeType ElementType : transport-guarantee
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: true isDataType: false
   // --------------------------------------------------------------------------------------------------------||
   /**
    * Sets the <code>transport-guarantee</code> element
    * @param transportGuarantee the value for the element <code>transport-guarantee</code> 
    * @return the current instance of <code>ServletSecurityType<T></code> 
    */
   public ServletSecurityType<T> transportGuarantee(TransportGuaranteeType transportGuarantee)
   {
      childNode.getOrCreate("transport-guarantee").text(transportGuarantee);
      return this;
   }
   /**
    * Sets the <code>transport-guarantee</code> element
    * @param transportGuarantee the value for the element <code>transport-guarantee</code> 
    * @return the current instance of <code>ServletSecurityType<T></code> 
    */
   public ServletSecurityType<T> transportGuarantee(String transportGuarantee)
   {
      childNode.getOrCreate("transport-guarantee").text(transportGuarantee);
      return this;
   }

   /**
    * Returns the <code>transport-guarantee</code> element
    * @return the value found for the element <code>transport-guarantee</code> 
    */
   public TransportGuaranteeType getTransportGuarantee()
   {
      return TransportGuaranteeType.getFromStringValue(childNode.getTextValueForPatternName("transport-guarantee"));
   }

   /**
    * Returns the <code>transport-guarantee</code> element
    * @return the value found for the element <code>transport-guarantee</code> 
    */
   public String  getTransportGuaranteeAsString()
   {
      return childNode.getTextValueForPatternName("transport-guarantee");
   }

   /**
    * Removes the <code>transport-guarantee</code> attribute 
    * @return the current instance of <code>ServletSecurityType<T></code> 
    */
   public ServletSecurityType<T> removeTransportGuarantee()
   {
      childNode.removeAttribute("transport-guarantee");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServletSecurityType ElementName: xsd:token ElementType : roles-allowed
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>roles-allowed</code> elements, 
    * a new <code>roles-allowed</code> element 
    * @param values list of <code>roles-allowed</code> objects 
    * @return the current instance of <code>ServletSecurityType<T></code> 
    */
   public ServletSecurityType<T> rolesAllowed(String ... values)
   {
      if (values != null)
      {
         for(String name: values)
         {
            childNode.createChild("roles-allowed").text(name);
         }
      }
      return this;
   }

   /**
    * Returns all <code>roles-allowed</code> elements
    * @return list of <code>roles-allowed</code> 
    */
public List<String> getAllRolesAllowed()
   {
      List<String> result = new ArrayList<String>();
      List<Node> nodes = childNode.get("roles-allowed");
      for (Node node : nodes)
      {
         result.add(node.getText());
      }
      return result;
   }

   /**
    * Removes the <code>roles-allowed</code> element 
    * @return the current instance of <code>ServletSecurityType<T></code> 
    */
   public ServletSecurityType<T> removeAllRolesAllowed()
   {
      childNode.removeChildren("roles-allowed");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServletSecurityType ElementName: jboss:http-method-constraintType ElementType : http-method-constraint
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>http-method-constraint</code> element will be created and returned.
    * Otherwise, the first existing <code>http-method-constraint</code> element will be returned.
    * @return the instance defined for the element <code>http-method-constraint</code> 
    */
   public HttpMethodConstraintType<ServletSecurityType<T>> getOrCreateHttpMethodConstraint()
   {
      List<Node> nodeList = childNode.get("http-method-constraint");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new HttpMethodConstraintTypeImpl<ServletSecurityType<T>>(this, "http-method-constraint", childNode, nodeList.get(0));
      }
      return createHttpMethodConstraint();
   }

   /**
    * Creates a new <code>http-method-constraint</code> element 
    * @return the new created instance of <code>HttpMethodConstraintType<ServletSecurityType<T>></code> 
    */
   public HttpMethodConstraintType<ServletSecurityType<T>> createHttpMethodConstraint()
   {
      return new HttpMethodConstraintTypeImpl<ServletSecurityType<T>>(this, "http-method-constraint", childNode);
   }

   /**
    * Returns all <code>http-method-constraint</code> elements
    * @return list of <code>http-method-constraint</code> 
    */
   public List<HttpMethodConstraintType<ServletSecurityType<T>>> getAllHttpMethodConstraint()
   {
      List<HttpMethodConstraintType<ServletSecurityType<T>>> list = new ArrayList<HttpMethodConstraintType<ServletSecurityType<T>>>();
      List<Node> nodeList = childNode.get("http-method-constraint");
      for(Node node: nodeList)
      {
         HttpMethodConstraintType<ServletSecurityType<T>>  type = new HttpMethodConstraintTypeImpl<ServletSecurityType<T>>(this, "http-method-constraint", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>http-method-constraint</code> elements 
    * @return the current instance of <code>HttpMethodConstraintType<ServletSecurityType<T>></code> 
    */
   public ServletSecurityType<T> removeAllHttpMethodConstraint()
   {
      childNode.removeChildren("http-method-constraint");
      return this;
   }
}
